/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import net.serenitybdd.core.pages.SystemClock;

public class StepDelayer {
    private final SystemClock clock;

    public StepDelayer(SystemClock clock) {
        this.clock = clock;
    }

    public WaitForBuilder waitFor(int duration) {
        return new WaitForBuilder(duration);
    }

    public class WaitForBuilder {
        private final int duration;
        private static final int MILLISECONDS_IN_A_SECOND = 1000;
        private static final int MILLISECONDS_IN_A_MINUTE = 60000;
        private static final int MILLISECONDS_IN_AN_HOUR = 3600000;

        public WaitForBuilder(int duration) {
            this.duration = duration;
        }

        public void millisecond() {
            StepDelayer.this.clock.pauseFor(this.duration);
        }

        public void milliseconds() {
            StepDelayer.this.clock.pauseFor(this.duration);
        }

        public void second() {
            StepDelayer.this.clock.pauseFor(this.duration * 1000);
        }

        public void seconds() {
            StepDelayer.this.clock.pauseFor(this.duration * 1000);
        }

        public void minute() {
            StepDelayer.this.clock.pauseFor(this.duration * 60000);
        }

        public void minutes() {
            StepDelayer.this.clock.pauseFor(this.duration * 60000);
        }

        public void hour() {
            StepDelayer.this.clock.pauseFor(this.duration * 3600000);
        }

        public void hours() {
            StepDelayer.this.clock.pauseFor(this.duration * 3600000);
        }
    }
}

