/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations.locators;

import io.appium.java_client.AppiumDriver;
import java.lang.reflect.Field;
import net.thucydides.core.annotations.locators.SmartAjaxElementLocator;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.MobilePlatform;
import net.thucydides.core.webdriver.appium.AppiumConfiguration;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;

public final class SmartElementLocatorFactory
implements ElementLocatorFactory {
    private final WebDriver webDriver;
    private int timeoutInSeconds;
    private MobilePlatform platform;

    public SmartElementLocatorFactory(WebDriver webDriver, int timeoutInSeconds) {
        this.webDriver = webDriver;
        this.timeoutInSeconds = timeoutInSeconds;
        this.platform = this.platformFor(webDriver);
    }

    private MobilePlatform platformFor(WebDriver webDriver) {
        if (webDriver instanceof AppiumDriver) {
            AppiumConfiguration appiumConfiguration = AppiumConfiguration.from((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
            return appiumConfiguration.getTargetPlatform();
        }
        return MobilePlatform.NONE;
    }

    public ElementLocator createLocator(Field field) {
        return new SmartAjaxElementLocator(this.webDriver, field, this.platform, this.timeoutInSeconds);
    }
}

