/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations.locators;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.serenitybdd.core.pages.WebElementDescriber;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WebElementFacadeImpl;
import net.thucydides.core.annotations.ImplementedBy;
import net.thucydides.core.annotations.NotImplementedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class SmartElementHandler
implements InvocationHandler {
    private final ElementLocator locator;
    private final WebDriver driver;
    private final Class<?> implementerClass;
    private final long timeoutInMilliseconds;

    private Class<?> getImplementer(Class<?> interfaceType) {
        if (!interfaceType.isInterface()) {
            throw new NotImplementedException(interfaceType.getSimpleName() + " is not an interface");
        }
        Class<? extends WebElementFacadeImpl> implementerClass = null;
        net.serenitybdd.core.annotations.ImplementedBy implBy = interfaceType.getAnnotation(net.serenitybdd.core.annotations.ImplementedBy.class);
        if (implBy == null) {
            ImplementedBy implByDep = interfaceType.getAnnotation(ImplementedBy.class);
            if (implByDep == null) {
                throw new NotImplementedException(interfaceType.getSimpleName() + " is not implemented by any class (or not annotated by @ImplementedBy)");
            }
            implementerClass = implByDep.value();
        } else {
            implementerClass = implBy.value();
        }
        if (!interfaceType.isAssignableFrom(implementerClass)) {
            throw new NotImplementedException(String.format("implementer Class '%s' does not implement the interface '%s'", implementerClass, interfaceType.getName()));
        }
        return implementerClass;
    }

    public SmartElementHandler(Class<?> interfaceType, ElementLocator locator, WebDriver driver, long timeoutInMilliseconds) {
        this.driver = driver;
        this.locator = locator;
        if (!WebElementFacade.class.isAssignableFrom(interfaceType)) {
            throw new NotImplementedException("interface not assignable to WebElementFacade");
        }
        this.implementerClass = this.getImplementer(interfaceType);
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objects) throws Throwable {
        try {
            if ("getWrappedElement".equals(method.getName())) {
                return this.locator.findElement();
            }
            if ("toString".equals(method.getName())) {
                return this.toStringForElement();
            }
            Object webElementFacadeExt = this.newElementInstance(this.driver, this.locator, this.timeoutInMilliseconds);
            return method.invoke(this.implementerClass.cast(webElementFacadeExt), objects);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private Object newElementInstance(WebDriver driver, ElementLocator locator, long timeoutInMilliseconds) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor = this.implementerClass.getConstructor(WebDriver.class, ElementLocator.class, Long.TYPE);
        return constructor.newInstance(driver, locator, timeoutInMilliseconds);
    }

    private String toStringForElement() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Object webElementFacadeExt = this.newElementInstance(this.driver, this.locator, 100L);
        if (webElementFacadeExt == null) {
            return "<" + this.locator.toString() + ">";
        }
        return new WebElementDescriber().webElementDescription((WebElement)webElementFacadeExt, this.locator);
    }
}

