/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import com.google.inject.Inject;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.imageio.ImageIO;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.screenshots.QueuedScreenshot;
import net.thucydides.core.screenshots.ScreenshotProcessor;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleThreadScreenshotProcessor
implements ScreenshotProcessor {
    Thread screenshotThread;
    final Queue<QueuedScreenshot> queue;
    private final EnvironmentVariables environmentVariables;
    private final Logger logger = LoggerFactory.getLogger(SingleThreadScreenshotProcessor.class);
    boolean done = false;

    @Inject
    public SingleThreadScreenshotProcessor(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.queue = new ConcurrentLinkedQueue<QueuedScreenshot>();
        this.start();
    }

    public void start() {
        this.screenshotThread = new Thread(new Processor(this.queue));
        this.screenshotThread.setDaemon(true);
        this.screenshotThread.start();
    }

    @Override
    public void waitUntilDone() {
        while (!this.isEmpty()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void terminate() {
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueScreenshot(QueuedScreenshot queuedScreenshot) {
        this.queue.offer(queuedScreenshot);
        Queue<QueuedScreenshot> queue = this.queue;
        synchronized (queue) {
            this.queue.notifyAll();
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    class Processor
    implements Runnable {
        private final Queue<QueuedScreenshot> queue;

        Processor(Queue<QueuedScreenshot> queue) {
            this.queue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!SingleThreadScreenshotProcessor.this.done) {
                Queue<QueuedScreenshot> queue = this.queue;
                synchronized (queue) {
                    this.saveQueuedScreenshot();
                    try {
                        if (!SingleThreadScreenshotProcessor.this.done) {
                            this.queue.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        private void saveQueuedScreenshot() {
            while (!this.queue.isEmpty()) {
                QueuedScreenshot queuedScreenshot = this.queue.poll();
                if (queuedScreenshot == null) continue;
                this.processScreenshot(queuedScreenshot);
            }
        }

        private void processScreenshot(QueuedScreenshot queuedScreenshot) {
            if (!queuedScreenshot.getDestinationFile().exists()) {
                this.resizeOrMoveScreenshot(queuedScreenshot);
            }
        }

        private void resizeOrMoveScreenshot(QueuedScreenshot queuedScreenshot) {
            if (this.shouldResize(queuedScreenshot)) {
                this.resizeScreenshot(queuedScreenshot);
            } else {
                this.moveScreenshot(queuedScreenshot);
            }
        }

        private int getResizedWidth() {
            return ThucydidesSystemProperty.THUCYDIDES_RESIZED_IMAGE_WIDTH.integerFrom(SingleThreadScreenshotProcessor.this.environmentVariables);
        }

        private boolean shouldResize(QueuedScreenshot queuedScreenshot) {
            BufferedImage image;
            if (this.getResizedWidth() > 0 && (image = this.readImage(queuedScreenshot)) != null) {
                int width = image.getData().getWidth();
                return width != this.getResizedWidth();
            }
            return false;
        }

        private BufferedImage readImage(QueuedScreenshot queuedScreenshot) {
            BufferedImage image = null;
            try {
                image = ImageIO.read(queuedScreenshot.getSourceFile());
            }
            catch (IOException e) {
                SingleThreadScreenshotProcessor.this.logger.warn("Failed to read the stored screenshot (possibly an out of memory error): " + e.getMessage());
            }
            return image;
        }

        private void moveScreenshot(QueuedScreenshot queuedScreenshot) {
            try {
                CopyOption[] options = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
                Path sourcePath = queuedScreenshot.getSourceFile().toPath();
                Path destinationPath = queuedScreenshot.getDestinationFile().toPath();
                Path destinationDir = queuedScreenshot.getDestinationFile().toPath().getParent();
                if (Files.notExists(destinationDir, new LinkOption[0])) {
                    Files.createDirectories(destinationDir, new FileAttribute[0]);
                }
                if (Files.notExists(destinationPath, new LinkOption[0])) {
                    Files.copy(sourcePath, destinationPath, options);
                }
                try {
                    Files.deleteIfExists(sourcePath);
                }
                catch (IOException e) {
                    queuedScreenshot.getSourceFile().deleteOnExit();
                }
            }
            catch (Throwable e) {
                SingleThreadScreenshotProcessor.this.logger.warn("Failed to copy the screenshot to the destination directory: " + e.getMessage());
            }
        }

        private void resizeScreenshot(QueuedScreenshot queuedScreenshot) {
            try {
                if (!queuedScreenshot.getDestinationFile().exists()) {
                    this.saveResizedScreenshot(queuedScreenshot);
                }
                Files.deleteIfExists(queuedScreenshot.getSourceFile().toPath());
            }
            catch (Throwable e) {
                SingleThreadScreenshotProcessor.this.logger.warn("Failed to resize screenshot: using original size " + e.getMessage());
                this.moveScreenshot(queuedScreenshot);
            }
        }

        private void saveResizedScreenshot(QueuedScreenshot queuedScreenshot) throws IOException {
            BufferedImage image = ImageIO.read(queuedScreenshot.getSourceFile());
            int width = image.getData().getWidth();
            int height = image.getData().getHeight();
            int targetWidth = this.getResizedWidth();
            int targetHeight = (int)((double)targetWidth / (double)width * (double)height);
            BufferedImage resizedImage = this.resize(image, targetWidth, targetHeight);
            ImageIO.write((RenderedImage)resizedImage, "png", queuedScreenshot.getDestinationFile());
        }

        private BufferedImage resize(BufferedImage image, int width, int height) {
            int type = image.getType() == 0 ? 2 : image.getType();
            BufferedImage resizedImage = new BufferedImage(width, height, type);
            Graphics2D g = resizedImage.createGraphics();
            g.setComposite(AlphaComposite.Src);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawImage(image, 0, 0, width, height, null);
            g.dispose();
            return resizedImage;
        }
    }
}

