/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel;

import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.connection.ConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Window {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Object lock = new Object();
    protected final int maxPacketSize;
    protected int size;

    public Window(int initialWinSize, int maxPacketSize) {
        this.size = initialWinSize;
        this.maxPacketSize = maxPacketSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(int inc) {
        Object object = this.lock;
        synchronized (object) {
            this.size += inc;
            this.log.debug("Increasing by {} up to {}", (Object)inc, (Object)this.size);
            this.lock.notifyAll();
        }
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(int dec) throws ConnectionException {
        Object object = this.lock;
        synchronized (object) {
            this.size -= dec;
            this.log.debug("Consuming by " + dec + " down to " + this.size);
            if (this.size < 0) {
                throw new ConnectionException("Window consumed to below 0");
            }
        }
    }

    public String toString() {
        return "[winSize=" + this.size + "]";
    }

    public static final class Local
    extends Window {
        private final int initialSize;
        private final int threshold;

        public Local(int initialWinSize, int maxPacketSize) {
            super(initialWinSize, maxPacketSize);
            this.initialSize = initialWinSize;
            this.threshold = Math.min(maxPacketSize * 20, this.initialSize / 4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int neededAdjustment() {
            Object object = this.lock;
            synchronized (object) {
                return this.size - this.threshold <= 0 ? this.initialSize - this.size : 0;
            }
        }
    }

    public static final class Remote
    extends Window {
        public Remote(int initialWinSize, int maxPacketSize) {
            super(initialWinSize, maxPacketSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int awaitExpansion(int was) throws ConnectionException {
            Object object = this.lock;
            synchronized (object) {
                while (this.size <= was) {
                    this.log.debug("Waiting, need size to grow from {} bytes", (Object)was);
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException ie) {
                        throw new ConnectionException(ie);
                    }
                }
                return this.size;
            }
        }

        @Override
        public void consume(int howMuch) {
            try {
                super.consume(howMuch);
            }
            catch (ConnectionException e) {
                throw new SSHRuntimeException(e);
            }
        }
    }
}

