/*
 * Decompiled with CFR 0.152.
 */
package net.scarlettsystems.android.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import net.scarlettsystems.android.widget.Helpers;
import net.scarlettsystems.android.widget.R;

public class FlexTextView
extends AppCompatTextView {
    private final int DEF_MODE = 0;
    private final boolean DEF_ENABLED = true;
    private final boolean DEF_COLLAPSE_ENABLED = true;
    private final int DEF_BUT_RES = R.drawable.net_scarlettsystems_android_ic_chevron_down;
    private final int DEF_BUT_SIZE = Helpers.Dp2Pix(24, this.getContext());
    private final int DEF_BUT_MARGIN = Helpers.Dp2Pix(16, this.getContext());
    private final int DEF_BUT_DIR = -1;
    private final int DEF_ANIM_TIME = this.getResources().getInteger(0x10E0001);
    private final float DEF_INTERPOLATION_FACTOR = 1.0f;
    private LinearLayout mView;
    private ImageView mButtonView;
    private ScrollView mScrollView;
    private int mButtonSize;
    private int mMode = 0;
    private int mMaxCollapsedLines;
    private int mAnimationDuration = this.DEF_ANIM_TIME;
    private float mInterpolationFactor = 1.0f;
    private int mButtonDirection = -1;
    private boolean mEnabled = true;
    private boolean mCollapseEnabled = true;
    private boolean mAnimationsEnabled = true;
    private boolean mScrollEnabled = false;
    private boolean mCollapsed = true;
    private boolean mLayoutComplete = false;
    private Handler mHandler = new Handler();
    private ValueAnimator mTextViewAnimator = null;
    private ValueAnimator mButtonAnimator = null;
    public static final int COLLAPSING = 0;
    public static final int SCROLLING = 1;
    public static final int RESIZING = 2;
    public static final int ANTI_CLOCKWISE = -1;
    public static final int NONE = 0;
    public static final int CLOCKWISE = 1;

    public FlexTextView(Context context) {
        super(context);
        this.initialise();
    }

    public FlexTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialise();
        this.applyAttributes(context, attrs);
    }

    public FlexTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialise();
        this.applyAttributes(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyAttributes(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FlexTextView, 0, 0);
        try {
            this.setMode(ta.getInt(R.styleable.FlexTextView_ftv_mode, 0));
            this.setEnabled(ta.getBoolean(R.styleable.FlexTextView_ftv_enabled, true));
            this.setCollapseEnabled(ta.getBoolean(R.styleable.FlexTextView_ftv_collapsible, true));
            this.setAnimationsEnabled(ta.getBoolean(R.styleable.FlexTextView_ftv_animation_enabled, true));
            this.setButtonResource(ta.getResourceId(R.styleable.FlexTextView_ftv_button_image, this.DEF_BUT_RES));
            this.setButtonSize(ta.getDimensionPixelSize(R.styleable.FlexTextView_ftv_button_size, this.DEF_BUT_SIZE));
            this.setButtonMargin(ta.getDimensionPixelSize(R.styleable.FlexTextView_ftv_button_margin, this.DEF_BUT_MARGIN));
            this.setButtonRotationDirection(ta.getInt(R.styleable.FlexTextView_ftv_button_rotation, -1));
        }
        finally {
            ta.recycle();
        }
    }

    private void initialise() {
        this.mView = (LinearLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.net_scarlettsystems_android_widget_flextextview, (ViewGroup)this.getParent(), false);
        this.configureTextView();
        this.configureButton();
        this.configureScrollView();
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                FlexTextView.this.mLayoutComplete = true;
                FlexTextView.this.refresh();
                if (Build.VERSION.SDK_INT >= 16) {
                    FlexTextView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    FlexTextView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.getParent() != this.mScrollView) {
            ViewGroup parent = (ViewGroup)this.getParent();
            this.mView.setLayoutParams(this.getLayoutParams());
            this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            int index = parent.indexOfChild((View)this);
            parent.removeViewAt(index);
            this.mScrollView.addView((View)this);
            parent.addView((View)this.mView, index);
        }
    }

    public void invalidate() {
        super.invalidate();
        this.post(new Runnable(){

            @Override
            public void run() {
                FlexTextView.this.refresh();
            }
        });
    }

    public void requestLayout() {
        super.requestLayout();
    }

    private void configureTextView() {
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FlexTextView.this.onTextClick();
            }
        });
    }

    public void setText(final CharSequence text, final TextView.BufferType type) {
        this.animateTextChange(new Runnable(){

            @Override
            public void run() {
                FlexTextView.super.setText(text, type);
            }
        });
    }

    private void configureButton() {
        this.mButtonView = (ImageView)this.mView.findViewById(R.id.net_scarlettsystems_android_widget_flextextview_button);
        this.mButtonView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FlexTextView.this.onButtonClick();
            }
        });
    }

    private void configureScrollView() {
        this.mScrollView = (ScrollView)this.mView.findViewById(R.id.net_scarlettsystems_android_widget_flextextview_scroll);
        this.mScrollView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return !FlexTextView.this.mScrollEnabled || !FlexTextView.this.mEnabled;
            }
        });
    }

    private void onTextClick() {
        this.clickAction();
    }

    private void onButtonClick() {
        this.clickAction();
    }

    private void clickAction() {
        if (!this.mEnabled) {
            return;
        }
        if (!this.mCollapseEnabled) {
            return;
        }
        if (this.mMode != 0) {
            return;
        }
        this.mCollapsed ^= true;
        this.sizeTextView(this.getTextHeight());
        this.sizeButton(this.getButtonSize(), this.getButtonAngle());
    }

    private void refresh() {
        if (!this.mLayoutComplete) {
            return;
        }
        this.scrollToStart();
        switch (this.mMode) {
            case 0: {
                if (!this.isButtonNeeded()) {
                    this.mCollapsed = true;
                }
                this.sizeTextView(this.getTextHeight());
                this.sizeButton(this.getButtonSize(), this.getButtonAngle());
                break;
            }
            case 1: {
                this.mCollapsed = true;
                this.sizeTextView(this.getTextHeight());
                this.sizeButton(0, 0.0f);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private void scrollToStart() {
        if (this.mScrollView.getScrollY() != 0) {
            if (this.mAnimationsEnabled) {
                this.mScrollView.smoothScrollTo(0, 0);
            } else {
                this.mScrollView.scrollTo(0, 0);
            }
        }
    }

    private int getCollapsedTextHeight() {
        if (this.mView.getLayoutParams().height == -2) {
            Log.e((String)"FTV", (String)"It's wrapped.");
        } else {
            Log.e((String)"FTV", (String)"It's not.");
        }
        int collapsedHeight = this.getLineHeight() * (this.mMaxCollapsedLines - 1) + this.getLastLineHeight() + this.getPaddingTop() + this.getPaddingBottom();
        return Math.min(collapsedHeight, this.getExpandedTextHeight());
    }

    private int getExpandedTextHeight() {
        return (this.getLineCount() - 1) * this.getLineHeight() + this.getLastLineHeight();
    }

    private int getLastLineHeight() {
        return Math.round(this.getPaint().getFontMetrics().bottom - this.getPaint().getFontMetrics().top);
    }

    private int getTextHeight() {
        if (this.mCollapsed) {
            return this.getCollapsedTextHeight();
        }
        return this.getExpandedTextHeight();
    }

    private void sizeTextView(int size) {
        this.stopTextViewAnimation();
        if (this.mAnimationsEnabled) {
            this.mTextViewAnimator = ValueAnimator.ofInt((int[])new int[]{this.mScrollView.getHeight(), size});
            this.mTextViewAnimator.setDuration((long)this.mAnimationDuration);
            this.mTextViewAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator(this.mInterpolationFactor));
            this.mTextViewAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator va) {
                    FlexTextView.this.setHeight((View)FlexTextView.this.mScrollView, (Integer)va.getAnimatedValue());
                }
            });
            this.mTextViewAnimator.start();
        } else {
            this.setHeight((View)this.mScrollView, size);
        }
    }

    private void stopTextViewAnimation() {
        if (this.mTextViewAnimator == null) {
            return;
        }
        if (!this.mTextViewAnimator.isStarted()) {
            return;
        }
        this.mTextViewAnimator.cancel();
    }

    private void sizeButton(int size, float angle) {
        this.stopButtonAnimation();
        if (this.mAnimationsEnabled) {
            final float startAngle = this.mButtonView.getRotation();
            final float deltaAngle = angle - startAngle;
            this.mButtonAnimator = ValueAnimator.ofInt((int[])new int[]{this.mButtonView.getHeight(), size});
            this.mButtonAnimator.setDuration((long)this.mAnimationDuration);
            this.mButtonAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator(this.mInterpolationFactor));
            this.mButtonAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator va) {
                    FlexTextView.this.setHeight((View)FlexTextView.this.mButtonView, (Integer)va.getAnimatedValue());
                    FlexTextView.this.mButtonView.setRotation(startAngle + va.getAnimatedFraction() * deltaAngle);
                }
            });
            this.mButtonAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    if (Math.abs(FlexTextView.this.mButtonView.getRotation()) == 360.0f) {
                        FlexTextView.this.mButtonView.setRotation(0.0f);
                    }
                }
            });
            this.mButtonAnimator.start();
        } else {
            this.setHeight((View)this.mButtonView, size);
            if (angle == 360.0f) {
                this.mButtonView.setRotation(0.0f);
            } else {
                this.mButtonView.setRotation(angle);
            }
        }
    }

    private void stopButtonAnimation() {
        if (this.mButtonAnimator == null) {
            return;
        }
        if (!this.mButtonAnimator.isStarted()) {
            return;
        }
        this.mButtonAnimator.cancel();
    }

    private boolean isButtonNeeded() {
        boolean collapsedIsSmaller = this.getCollapsedTextHeight() < this.getExpandedTextHeight();
        return collapsedIsSmaller && this.mCollapseEnabled;
    }

    private int getButtonSize() {
        if (this.isButtonNeeded()) {
            return this.mButtonSize;
        }
        return 0;
    }

    private float getButtonAngle() {
        if (this.mCollapsed) {
            if (Math.abs(this.mButtonView.getRotation()) >= 180.0f) {
                return 360 * this.mButtonDirection;
            }
            return 0.0f;
        }
        return 180 * this.mButtonDirection;
    }

    private void setHeight(View v, int h) {
        ViewGroup.LayoutParams lp = v.getLayoutParams();
        lp.height = h;
        v.setLayoutParams(lp);
    }

    private void animateTextChange(Runnable changeAction) {
        if (this.mAnimationsEnabled && this.mLayoutComplete) {
            this.fadeOutText(changeAction);
        } else {
            changeAction.run();
            this.refresh();
        }
    }

    private void fadeOutText(final Runnable changeAction) {
        this.animate().cancel();
        this.animate().alpha(0.0f).setDuration((long)this.mAnimationDuration).setInterpolator((TimeInterpolator)new AccelerateInterpolator(this.mInterpolationFactor)).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animation) {
                FlexTextView.this.mHandler.post(changeAction);
                FlexTextView.this.refresh();
            }

            public void onAnimationEnd(Animator animation) {
                FlexTextView.this.mHandler.post(changeAction);
                FlexTextView.this.refresh();
                FlexTextView.this.fadeInText();
            }
        }).start();
    }

    private void fadeInText() {
        this.animate().alpha(1.0f).setDuration((long)this.mAnimationDuration).setInterpolator((TimeInterpolator)new DecelerateInterpolator(this.mInterpolationFactor)).setListener(null).start();
    }

    public void enable() {
        this.mEnabled = true;
    }

    public void disable() {
        this.mEnabled = false;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setCollapseEnabled(boolean collapseEnabled) {
        this.mEnabled = collapseEnabled;
    }

    public void setAnimationsEnabled(boolean enabled) {
        this.mAnimationsEnabled = enabled;
    }

    public boolean isAnimationEnabled() {
        return this.mAnimationsEnabled;
    }

    public void setAnimationDuration(int duration) {
        this.mAnimationDuration = duration;
    }

    public void setInterpolationFactor(float factor) {
        this.mInterpolationFactor = factor;
    }

    public void setButtonRotationDirection(int direction) {
        this.mButtonDirection = direction;
    }

    public void setMode(int mode) {
        this.mMode = mode;
        switch (this.mMode) {
            case 0: {
                super.setMaxLines(Integer.MAX_VALUE);
                this.mScrollEnabled = false;
                this.mScrollView.setVerticalScrollBarEnabled(false);
                break;
            }
            case 1: {
                super.setMaxLines(Integer.MAX_VALUE);
                this.mScrollEnabled = true;
                this.mScrollView.setVerticalScrollBarEnabled(true);
                break;
            }
            case 2: {
                break;
            }
        }
        this.refresh();
    }

    public void setMaxLines(int value) {
        if (value < 1) {
            throw new IllegalArgumentException("Max collapsed lines cannot be fewer than 1.");
        }
        this.mMaxCollapsedLines = value;
    }

    public void setButtonSize(int size) {
        this.mButtonSize = size;
        this.refresh();
    }

    public void setButtonMargin(int margin) {
        ((LinearLayout.LayoutParams)this.mButtonView.getLayoutParams()).topMargin = margin;
    }

    public void setButtonBitmap(Bitmap bm) {
        this.mButtonView.setImageBitmap(bm);
    }

    public void setButtonDrawable(Drawable drawable2) {
        this.mButtonView.setImageDrawable(drawable2);
    }

    public void setButtonResource(@DrawableRes int resId) {
        this.mButtonView.setImageResource(resId);
    }

    public void setButtonTint(@ColorInt int colour) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.mButtonView.setImageTintList(ColorStateList.valueOf((int)colour));
        } else {
            this.mButtonView.setColorFilter(colour);
        }
    }

    public void setButtonAlpha(float alpha) {
        this.mButtonView.setAlpha(alpha);
    }
}

