/*
 * Decompiled with CFR 0.152.
 */
package net.scarlettsystems.android.widget;

import android.os.Handler;
import android.os.Looper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

class ProgressManager {
    ProgressManager() {
    }

    public static void forget(String url) {
        DispatchingProgressListener.forget(url);
    }

    public static void expect(String url, UIonProgressListener listener) {
        DispatchingProgressListener.expect(url, listener);
    }

    public static class OkHttpProgressResponseBody
    extends ResponseBody {
        private final HttpUrl url;
        private final ResponseBody responseBody;
        private final ResponseProgressListener progressListener;
        private BufferedSource bufferedSource;

        OkHttpProgressResponseBody(HttpUrl url, ResponseBody responseBody, ResponseProgressListener progressListener) {
            this.url = url;
            this.responseBody = responseBody;
            this.progressListener = progressListener;
        }

        public MediaType contentType() {
            return this.responseBody.contentType();
        }

        public long contentLength() {
            return this.responseBody.contentLength();
        }

        public BufferedSource source() {
            if (this.bufferedSource == null) {
                this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
            }
            return this.bufferedSource;
        }

        private Source source(Source source) {
            return new ForwardingSource(source){
                long totalBytesRead;
                {
                    this.totalBytesRead = 0L;
                }

                public long read(Buffer sink, long byteCount) throws IOException {
                    long bytesRead = super.read(sink, byteCount);
                    long fullLength = OkHttpProgressResponseBody.this.responseBody.contentLength();
                    this.totalBytesRead = bytesRead == -1L ? fullLength : (this.totalBytesRead += bytesRead);
                    OkHttpProgressResponseBody.this.progressListener.update(OkHttpProgressResponseBody.this.url, this.totalBytesRead, fullLength);
                    return bytesRead;
                }
            };
        }
    }

    public static class DispatchingProgressListener
    implements ResponseProgressListener {
        private static final Map<String, UIonProgressListener> LISTENERS = new HashMap<String, UIonProgressListener>();
        private static final Map<String, Long> PROGRESSES = new HashMap<String, Long>();
        private final Handler handler = new Handler(Looper.getMainLooper());

        DispatchingProgressListener() {
        }

        static void forget(String url) {
            LISTENERS.remove(url);
            PROGRESSES.remove(url);
        }

        static void expect(String url, UIonProgressListener listener) {
            LISTENERS.put(url, listener);
        }

        @Override
        public void update(HttpUrl url, final long bytesRead, final long contentLength) {
            String key = url.toString();
            final UIonProgressListener listener = LISTENERS.get(key);
            if (listener == null) {
                return;
            }
            if (contentLength <= bytesRead) {
                DispatchingProgressListener.forget(key);
            }
            if (this.needsDispatch(key, bytesRead, contentLength, listener.getGranularityPercent())) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        listener.onProgress(bytesRead, contentLength);
                    }
                });
            }
        }

        private boolean needsDispatch(String key, long current, long total, float granularity) {
            if (granularity == 0.0f || current == 0L || total == current) {
                return true;
            }
            float percent = 100.0f * (float)current / (float)total;
            long currentProgress = (long)(percent / granularity);
            Long lastProgress = PROGRESSES.get(key);
            if (lastProgress == null || currentProgress != lastProgress) {
                PROGRESSES.put(key, currentProgress);
                return true;
            }
            return false;
        }
    }

    public static interface UIonProgressListener {
        public void onProgress(long var1, long var3);

        public float getGranularityPercent();
    }

    public static interface ResponseProgressListener {
        public void update(HttpUrl var1, long var2, long var4);
    }
}

