/*
 * Decompiled with CFR 0.152.
 */
package net.scarlettsystems.android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import net.scarlettsystems.android.widget.R;
import net.scarlettsystems.android.widget.ScarlettPagerAdapter;

public class EasyViewPager
extends ViewPager {
    private ScarlettPagerAdapter mAdapter;
    private boolean mSwipeable = true;

    public EasyViewPager(Context context) {
        super(context);
        this.initialise();
    }

    public EasyViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.applyAttributes(context, attrs);
        this.initialise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyAttributes(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.EasyViewPager, 0, 0);
        try {
            this.mSwipeable = ta.getBoolean(R.styleable.EasyViewPager_swipeable, true);
        }
        finally {
            ta.recycle();
        }
    }

    private void initialise() {
        this.mAdapter = new ScarlettPagerAdapter();
        this.setAdapter(this.mAdapter);
    }

    public void addPage(View view) {
        this.mAdapter.addView(view);
    }

    public void addPage(View view, int index) {
        this.mAdapter.addView(view, index);
    }

    public View getPage(int index) {
        return this.mAdapter.getView(index);
    }

    public void removePage(int index) {
        this.mAdapter.removeView(index);
    }

    public void enableSwipe() {
        this.mSwipeable = true;
    }

    public void disableSwipe() {
        this.mSwipeable = false;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.mSwipeable) {
            return super.onInterceptTouchEvent(event);
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mSwipeable) {
            return super.onTouchEvent(event);
        }
        return false;
    }
}

