/*
 * Decompiled with CFR 0.152.
 */
package net.scarlettsystems.android.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

class CardAnimator
extends SimpleItemAnimator {
    private Context mContext;
    private RecyclerView mRecyclerView;
    private float mInterpolationFactor = 1.0f;
    private int mStaggerDelay = 64;
    private int mDuration;
    private int mDirection;
    private int mTranslationAmount = 100;
    public static final int EAST = 0;
    public static final int NORTH = 2;
    public static final int WEST = 4;
    public static final int SOUTH = 6;
    public static final int DIRECTION_IN = 0;
    public static final int DIRECTION_OUT = 1;

    public CardAnimator(Context context, RecyclerView recyclerView) {
        this.mContext = context;
        this.mDuration = this.mContext.getResources().getInteger(0x10E0001);
        this.mRecyclerView = recyclerView;
    }

    public boolean animateRemove(final RecyclerView.ViewHolder holder) {
        int[] firstVisibleItems = ((StaggeredGridLayoutManager)this.mRecyclerView.getLayoutManager()).findFirstVisibleItemPositions(null);
        int firstVisibleItem = firstVisibleItems[firstVisibleItems.length - 1];
        holder.itemView.setAlpha(1.0f);
        Animator animator = this.getAnimator(this.mDirection, 1);
        animator.setDuration((long)this.mDuration);
        animator.setInterpolator((TimeInterpolator)new AccelerateInterpolator(this.mInterpolationFactor));
        animator.setTarget((Object)holder.itemView);
        animator.setStartDelay((long)(this.mStaggerDelay * Math.max(0, holder.getLayoutPosition() - firstVisibleItem)));
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                CardAnimator.this.dispatchRemoveFinished(holder);
                super.onAnimationEnd(animation);
            }
        });
        animator.start();
        return true;
    }

    public boolean animateAdd(final RecyclerView.ViewHolder holder) {
        int[] firstVisibleItems = ((StaggeredGridLayoutManager)this.mRecyclerView.getLayoutManager()).findFirstVisibleItemPositions(null);
        int firstVisibleItem = firstVisibleItems[firstVisibleItems.length - 1];
        holder.itemView.setAlpha(0.0f);
        Animator animator = this.getAnimator(this.mDirection, 0);
        animator.setDuration((long)this.mDuration);
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator(this.mInterpolationFactor));
        animator.setTarget((Object)holder.itemView);
        animator.setStartDelay((long)(this.mStaggerDelay * Math.max(0, holder.getLayoutPosition() - firstVisibleItem)));
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                CardAnimator.this.dispatchAddFinished(holder);
                super.onAnimationEnd(animation);
            }
        });
        animator.start();
        return true;
    }

    public boolean animateMove(RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
        float deltaX = toX - fromX;
        holder.itemView.animate().translationX(deltaX).setDuration((long)this.mDuration).start();
        return false;
    }

    public boolean animateChange(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder, int fromLeft, int fromTop, int toLeft, int toTop) {
        return false;
    }

    public void runPendingAnimations() {
    }

    public void endAnimation(RecyclerView.ViewHolder item) {
    }

    public void endAnimations() {
    }

    public boolean isRunning() {
        return false;
    }

    private Animator getAnimator(int from, int direction) {
        int multiplier;
        String axisName;
        switch (direction) {
            case 0: {
                int startPos = this.mTranslationAmount;
                int finalPos = 0;
                break;
            }
            case 1: {
                int startPos = 0;
                int finalPos = this.mTranslationAmount;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid direction.");
            }
        }
        switch (from) {
            case 2: 
            case 6: {
                axisName = "translationY";
                break;
            }
            case 0: 
            case 4: {
                axisName = "translationX";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid direction.");
            }
        }
        switch (from) {
            case 0: 
            case 6: {
                multiplier = 1;
                break;
            }
            case 2: 
            case 4: {
                multiplier = -1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid direction.");
            }
        }
        ObjectAnimator animator = new ObjectAnimator();
        animator.setPropertyName(axisName);
        animator.setIntValues(new int[]{startPos *= multiplier, finalPos *= multiplier});
        return animator;
    }

    public float getInterpolationFactor() {
        return this.mInterpolationFactor;
    }

    public void setInterpolationFactor(float value) {
        this.mInterpolationFactor = value;
    }

    public int getStaggerDelay() {
        return this.mStaggerDelay;
    }

    public void setStaggerDelay(int value) {
        this.mStaggerDelay = value;
    }

    public int getAnimationDuration() {
        return this.mDuration;
    }

    public void setAnimationDuration(int value) {
        this.mDuration = value;
    }

    public int getDirection() {
        return this.mDirection;
    }

    public void setDirection(int direction) {
        this.mDirection = direction;
    }

    public int getTranslationAmount() {
        return this.mTranslationAmount;
    }

    public void setTranslationAmount(int value) {
        this.mTranslationAmount = value;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Direction {
    }
}

