/*
 * Decompiled with CFR 0.152.
 */
package net.savantly.pm2j;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.savantly.pm2j.Pm2Locator;
import net.savantly.pm2j.Pm2ProcessInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Pm2Connector {
    private static final Logger log = LogManager.getLogger(Pm2Connector.class);
    private static ObjectMapper objectMapper = new ObjectMapper();
    private String pm2Path;
    private String pm2Home;

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }

    public Pm2Connector() {
        this.pm2Path = Pm2Locator.getBinaryLocationFromPath("pm2");
        this.pm2Home = Pm2Locator.getPm2Home();
    }

    public Pm2Connector(String pm2Path) {
        this.pm2Path = pm2Path;
        this.pm2Home = Pm2Locator.getPm2Home();
    }

    public Pm2Connector(String pm2Path, String pm2Home) {
        this.pm2Path = pm2Path;
        this.pm2Home = pm2Home;
    }

    public void getPm2Version() {
        this.executePm2Command("-v");
    }

    public void killPm2() {
        this.executePm2Command("kill");
    }

    public void stopPm2() {
        this.executePm2Command("stop", "all");
    }

    public boolean ensureRunning() {
        this.executePm2Command("prettylist");
        return true;
    }

    public List<Pm2ProcessInfo> getPm2Processes() {
        if (!this.ensureRunning()) {
            throw new RuntimeException("pm2 is not running");
        }
        String json = this.executePm2Command("prettylist");
        ArrayList<Pm2ProcessInfo> pm2Processes = new ArrayList<Pm2ProcessInfo>();
        try {
            pm2Processes.addAll((Collection)objectMapper.readValue(json, pm2Processes.getClass()));
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        return pm2Processes;
    }

    public Pm2ProcessInfo getPm2Processes(int id) {
        List<Pm2ProcessInfo> pm2Processes = this.getPm2Processes();
        for (Pm2ProcessInfo pm2ProcessInfo : pm2Processes) {
            if (pm2ProcessInfo.getPm_id() != id) continue;
            return pm2ProcessInfo;
        }
        return null;
    }

    public void startPm2(String configFilePath) {
        File configFile = new File(configFilePath);
        if (!configFile.canRead()) {
            throw new RuntimeException(String.format("Cannot read the config file: %s", configFilePath));
        }
        log.info("Using configuration file: {}", (Object)configFilePath);
        this.executePm2Command("start", configFilePath);
    }

    private String executePm2Command(String ... args) {
        String[] parameters = new String[args.length + 1];
        parameters[0] = this.pm2Path;
        int i = 0;
        while (i < args.length) {
            parameters[i + 1] = args[i];
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder(parameters);
            Process p = pb.start();
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                log.debug(line);
                sb.append(line);
            }
            input.close();
        }
        catch (Exception err) {
            log.error((Object)err);
        }
        return sb.toString();
    }
}

