/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.test.conformance;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.File;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;
import net.sansa_stack.test.conformance.TestCase;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.RDFDataMgr;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.XML$;

public final class TestCases$ {
    public static final TestCases$ MODULE$;
    private final Logger logger;
    private FileSystem fs;

    static {
        new TestCases$();
    }

    public Logger logger() {
        return this.logger;
    }

    public FileSystem fs() {
        return this.fs;
    }

    public void fs_$eq(FileSystem x$1) {
        this.fs = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<TestCase> loadTestCases(File directory, Set<String> ids) {
        void var3_3;
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"loading test cases from ", "..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{directory.getAbsolutePath()})));
        ListBuffer testCases = new ListBuffer();
        Predef$.MODULE$.println((Object)directory);
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])directory.listFiles()).filter((Function1)new Serializable(ids){
            public static final long serialVersionUID = 0L;
            private final Set ids$2;

            public final boolean apply(File f) {
                return f.isDirectory() && (this.ids$2.isEmpty() || this.ids$2.contains((Object)f.getName()));
            }
            {
                this.ids$2 = ids$2;
            }
        })).foreach((Function1)new Serializable(testCases){
            public static final long serialVersionUID = 0L;
            private final ListBuffer testCases$1;

            public final Object apply(File subDirectory) {
                BoxedUnit boxedUnit;
                String entailmentType;
                File[] files = subDirectory.listFiles();
                File metadataFile = (File)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])files).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File x$1) {
                        return x$1.getName().endsWith(".metadata.properties");
                    }
                })).head();
                Elem metadata = (Elem)XML$.MODULE$.loadFile(metadataFile);
                String id = ((NodeSeq)metadata.$bslash$bslash("entry").filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Node n) {
                        String string = NodeSeq$.MODULE$.seqToNodeSeq((Seq)n.attribute("key").get()).text();
                        String string2 = "testcase.id";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                })).text();
                String description = ((NodeSeq)metadata.$bslash$bslash("entry").filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Node n) {
                        String string = NodeSeq$.MODULE$.seqToNodeSeq((Seq)n.attribute("key").get()).text();
                        String string2 = "testcase.description";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                })).text();
                String string = entailmentType = ((NodeSeq)metadata.$bslash$bslash("entry").filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Node n) {
                        String string = NodeSeq$.MODULE$.seqToNodeSeq((Seq)n.attribute("key").get()).text();
                        String string2 = "testcase.type";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                })).text();
                String string2 = "POSITIVE_ENTAILMENT";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Model inputGraph = RDFDataMgr.loadModel((String)((File)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])files).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(File x$2) {
                            return x$2.getName().endsWith(".premisegraph.ttl");
                        }
                    })).head()).getPath());
                    Model outputGraph = RDFDataMgr.loadModel((String)((File)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])files).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(File x$3) {
                            return x$3.getName().endsWith(".conclusiongraph.ttl");
                        }
                    })).head()).getPath());
                    boxedUnit = this.testCases$1.$plus$eq((Object)new TestCase(id, description, entailmentType, inputGraph, outputGraph));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.testCases$1 = testCases$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"loaded ", " test cases"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)testCases.size())})));
        return var3_3;
    }

    public Set<String> loadTestCases$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    /*
     * WARNING - void declaration
     */
    public Seq<TestCase> loadTestCasesJar(String directory, Set<String> ids) {
        void var3_3;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("loading test cases from {}...", new Object[]{directory});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ListBuffer testCases = new ListBuffer();
        ((TraversableLike)this.net$sansa_stack$test$conformance$TestCases$$listFiles(directory, this.listFiles$default$2()).filter((Function1)new Serializable(ids){
            public static final long serialVersionUID = 0L;
            private final Set ids$1;

            public final boolean apply(Path f) {
                return this.ids$1.isEmpty() || this.ids$1.contains((Object)((Object)f.getFileName()).toString().replace("/", ""));
            }
            {
                this.ids$1 = ids$1;
            }
        })).map((Function1)new Serializable(testCases){
            public static final long serialVersionUID = 0L;
            private final ListBuffer testCases$2;

            public final Object apply(Path p) {
                BoxedUnit boxedUnit;
                String entailmentType;
                String string = p.toUri().getScheme();
                String string2 = "jar";
                Seq<Path> files = TestCases$.MODULE$.net$sansa_stack$test$conformance$TestCases$$listFiles(!(string != null ? !string.equals(string2) : string2 != null) ? ((Object)p).toString().substring(1) : ((Object)p).toString(), true);
                Path metadataFile = (Path)((IterableLike)files.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Path x$4) {
                        return ((Object)x$4).toString().endsWith(".metadata.properties");
                    }
                })).head();
                Elem metadata = (Elem)XML$.MODULE$.load(metadataFile.toUri().toURL().openStream());
                String id = ((NodeSeq)metadata.$bslash$bslash("entry").filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Node n) {
                        String string = NodeSeq$.MODULE$.seqToNodeSeq((Seq)n.attribute("key").get()).text();
                        String string2 = "testcase.id";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                })).text();
                String description = ((NodeSeq)metadata.$bslash$bslash("entry").filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Node n) {
                        String string = NodeSeq$.MODULE$.seqToNodeSeq((Seq)n.attribute("key").get()).text();
                        String string2 = "testcase.description";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                })).text();
                String string3 = entailmentType = ((NodeSeq)metadata.$bslash$bslash("entry").filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Node n) {
                        String string = NodeSeq$.MODULE$.seqToNodeSeq((Seq)n.attribute("key").get()).text();
                        String string2 = "testcase.type";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                })).text();
                String string4 = "POSITIVE_ENTAILMENT";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    Model inputGraph = ModelFactory.createDefaultModel();
                    inputGraph.read(((Path)((IterableLike)files.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Path x$5) {
                            return ((Object)x$5).toString().endsWith(".premisegraph.ttl");
                        }
                    })).head()).toUri().toURL().openStream(), null, "Turtle");
                    Model outputGraph = ModelFactory.createDefaultModel();
                    outputGraph.read(((Path)((IterableLike)files.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Path x$6) {
                            return ((Object)x$6).toString().endsWith(".conclusiongraph.ttl");
                        }
                    })).head()).toUri().toURL().openStream(), null, "Turtle");
                    boxedUnit = this.testCases$2.$plus$eq((Object)new TestCase(id, description, entailmentType, inputGraph, outputGraph));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.testCases$2 = testCases$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"loaded ", " test cases"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)testCases.size())})));
        if (this.fs() != null) {
            this.fs().close();
        }
        return var3_3;
    }

    public Set<String> loadTestCasesJar$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    public Seq<Path> net$sansa_stack$test$conformance$TestCases$$listFiles(String path, boolean subDir) {
        URI uri = path.startsWith("/") ? new File(path).toURI() : TestCase.class.getClassLoader().getResource(path).toURI();
        Path myPath = null;
        String string = uri.getScheme();
        String string2 = "jar";
        if (!(string != null ? !string.equals(string2) : string2 != null) && !subDir) {
            this.fs_$eq(FileSystems.newFileSystem(uri, Collections.emptyMap()));
            myPath = this.fs().getPath(path, new String[0]);
        } else {
            myPath = Paths.get(uri);
        }
        Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);
        Iterator it = walk.iterator();
        Seq files = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (it.hasNext()) {
            Path subPath = (Path)it.next();
            if (((Object)subPath).equals(myPath)) continue;
            files = (Seq)files.$colon$plus((Object)subPath, Seq$.MODULE$.canBuildFrom());
        }
        return files;
    }

    private boolean listFiles$default$2() {
        return false;
    }

    private TestCases$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply("TestCases");
        this.fs = null;
    }
}

