/*
 * Decompiled with CFR 0.152.
 */
package net.rossillo.spring.web.mvc;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.rossillo.spring.web.mvc.CacheControl;
import net.rossillo.spring.web.mvc.CachePolicy;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class CacheControlHandlerInterceptor
extends HandlerInterceptorAdapter
implements HandlerInterceptor {
    private static final String HEADER_EXPIRES = "Expires";
    private static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private boolean useExpiresHeader = true;

    protected final void assignCacheControlHeader(HttpServletRequest request, HttpServletResponse response, Object handler) {
        CacheControl cacheControl = this.getCacheControl(request, response, handler);
        String cacheControlHeader = this.createCacheControlHeader(cacheControl);
        if (cacheControlHeader != null) {
            response.setHeader(HEADER_CACHE_CONTROL, cacheControlHeader);
            if (this.useExpiresHeader) {
                response.setDateHeader(HEADER_EXPIRES, this.createExpiresHeader(cacheControl));
            }
        }
    }

    protected final String createCacheControlHeader(CacheControl cacheControl) {
        StringBuilder builder = new StringBuilder();
        if (cacheControl == null) {
            return null;
        }
        CachePolicy[] policies = cacheControl.policy();
        if (cacheControl.maxAge() >= 0) {
            builder.append("max-age=").append(cacheControl.maxAge());
        }
        if (cacheControl.sharedMaxAge() >= 0) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append("s-maxage=").append(cacheControl.sharedMaxAge());
        }
        if (policies != null) {
            for (CachePolicy policy : policies) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(policy.policy());
            }
        }
        return builder.length() > 0 ? builder.toString() : null;
    }

    protected final long createExpiresHeader(CacheControl cacheControl) {
        GregorianCalendar expires = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        if (cacheControl.maxAge() >= 0) {
            ((Calendar)expires).add(13, cacheControl.maxAge());
        }
        return expires.getTime().getTime();
    }

    protected final CacheControl getCacheControl(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (handler == null || !(handler instanceof HandlerMethod)) {
            return null;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        CacheControl cacheControl = (CacheControl)handlerMethod.getMethodAnnotation(CacheControl.class);
        if (cacheControl == null) {
            return handlerMethod.getBeanType().getAnnotation(CacheControl.class);
        }
        return cacheControl;
    }

    public final boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.assignCacheControlHeader(request, response, handler);
        return super.preHandle(request, response, handler);
    }

    public final void setUseExpiresHeader(boolean useExpiresHeader) {
        this.useExpiresHeader = useExpiresHeader;
    }
}

