/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.internal.sync;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import net.roboconf.agent.internal.AgentMessageProcessor;
import net.roboconf.agent.internal.sync.NazgulMessageProcessor;
import net.roboconf.agent.internal.sync.SauronAgent;
import net.roboconf.messaging.api.messages.Message;

public class SauronMessageProcessor
extends AgentMessageProcessor {
    static final Map<Message, NazgulMessageProcessor> THE_SINGLE_MQ = new ConcurrentHashMap<Message, NazgulMessageProcessor>();
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public SauronMessageProcessor(SauronAgent sauronAgent) {
        super(sauronAgent);
    }

    @Override
    protected void processMessage(Message message) {
        NazgulMessageProcessor nazgul = THE_SINGLE_MQ.get(message);
        if (nazgul == null) {
            this.logger.warning("No Nazgul was found for message " + message.getClass().getSimpleName() + ". Message is dropped.");
        } else {
            this.logger.finer("Delegating message " + message.getClass().getSimpleName() + " to Nazgul " + nazgul.getAgentId());
            nazgul.processMessageForReal(message);
        }
    }
}

