/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.internal.misc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.roboconf.agent.internal.AgentProperties;
import net.roboconf.agent.internal.misc.AgentUtils;
import net.roboconf.core.utils.UriUtils;
import net.roboconf.core.utils.Utils;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UserDataHelper {
    public AgentProperties findParametersForAmazonOrOpenStack(Logger logger) {
        logger.info("User data are being retrieved for AWS / Openstack...");
        String userData = Utils.readUrlContentQuietly((String)"http://169.254.169.254/latest/user-data", (Logger)logger);
        String ip = Utils.readUrlContentQuietly((String)"http://169.254.169.254/latest/meta-data/public-ipv4", (Logger)logger);
        AgentProperties result = null;
        try {
            result = AgentProperties.readIaasProperties(userData, logger);
            if (!AgentUtils.isValidIP(ip)) {
                ip = Utils.readUrlContentQuietly((String)"http://169.254.169.254/latest/meta-data/local-ipv4", (Logger)logger);
            }
            if (AgentUtils.isValidIP(ip)) {
                result.setIpAddress(ip);
            } else {
                logger.severe("No IP address could be retrieved (either public-ipv4 or local-ipv4).");
            }
        }
        catch (IOException e) {
            logger.severe("The network properties could not be read. " + e.getMessage());
            Utils.logException((Logger)logger, (Throwable)e);
        }
        return result;
    }

    public AgentProperties findParametersForAzure(Logger logger) {
        logger.info("User data are being retrieved for Microsoft Azure...");
        String userData = "";
        try {
            String userDataEncoded = UserDataHelper.getValueOfTagInXMLFile("/var/lib/waagent/ovf-env.xml", "CustomData");
            userData = new String(Base64.decodeBase64(userDataEncoded.getBytes(StandardCharsets.UTF_8)), "UTF-8");
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.severe("The agent properties could not be read. " + e.getMessage());
            Utils.logException((Logger)logger, (Throwable)e);
        }
        AgentProperties result = null;
        try {
            result = AgentProperties.readIaasProperties(userData, logger);
            String publicIPAddress = UserDataHelper.getSpecificAttributeOfTagInXMLFile("/var/lib/waagent/SharedConfig.xml", "Endpoint", "loadBalancedPublicAddress");
            result.setIpAddress(publicIPAddress);
        }
        catch (ParserConfigurationException | SAXException e) {
            logger.severe("The agent could not retrieve a public IP address. " + e.getMessage());
            Utils.logException((Logger)logger, (Throwable)e);
        }
        catch (IOException e) {
            logger.severe("The agent could not retrieve its configuration. " + e.getMessage());
            Utils.logException((Logger)logger, (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentProperties findParametersForVmware(Logger logger) {
        AgentProperties result;
        block11: {
            logger.info("User data are being retrieved for VMWare...");
            result = null;
            File propertiesFile = new File("/tmp/roboconf.properties");
            try {
                InputStream in;
                block10: {
                    int retries = 30;
                    while (!(propertiesFile.exists() && propertiesFile.canRead() || retries-- <= 0)) {
                        logger.fine("Agent tries to read properties file " + propertiesFile + ": trial #" + (30 - retries));
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            throw new IOException("Cannot read properties file: " + e);
                        }
                    }
                    result = AgentProperties.readIaasProperties(Utils.readPropertiesFile((File)propertiesFile));
                    in = null;
                    try {
                        URL userDataUrl = new URL("http://169.254.169.254/latest/meta-data/public-ipv4");
                        in = userDataUrl.openStream();
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        Utils.copyStreamSafely((InputStream)in, (ByteArrayOutputStream)os);
                        String ip = os.toString("UTF-8");
                        if (!AgentUtils.isValidIP(ip)) {
                            Utils.closeQuietly((InputStream)in);
                            userDataUrl = new URL("http://169.254.169.254/latest/meta-data/local-ipv4");
                            in = userDataUrl.openStream();
                            os = new ByteArrayOutputStream();
                            Utils.copyStreamSafely((InputStream)in, (ByteArrayOutputStream)os);
                            ip = os.toString("UTF-8");
                        }
                        if (!AgentUtils.isValidIP(ip)) break block10;
                        result.setIpAddress(os.toString("UTF-8"));
                    }
                    catch (IOException e) {
                        try {
                            Utils.logException((Logger)logger, (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            Utils.closeQuietly(in);
                            throw throwable;
                        }
                        Utils.closeQuietly((InputStream)in);
                        break block11;
                    }
                }
                Utils.closeQuietly((InputStream)in);
            }
            catch (IOException e) {
                logger.fine("Agent failed to read properties file " + propertiesFile);
                result = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentProperties findParametersFromUrl(String url, Logger logger) {
        logger.info("User data are being retrieved from URL: " + url);
        AgentProperties result = null;
        try {
            URI uri = UriUtils.urlToUri((String)url);
            Properties props = new Properties();
            InputStream in = null;
            try {
                in = uri.toURL().openStream();
                props.load(in);
            }
            finally {
                Utils.closeQuietly((InputStream)in);
            }
            result = AgentProperties.readIaasProperties(props);
        }
        catch (Exception e) {
            logger.fine("Agent parameters could not be read from " + url);
            result = null;
        }
        return result;
    }

    public void reconfigureMessaging(String etcDir, Map<String, String> msgData) throws IOException {
        String messagingType = msgData.get("net.roboconf.messaging.type");
        Logger.getLogger(this.getClass().getName()).fine("Messaging type for reconfiguration: " + messagingType);
        if (!Utils.isEmptyOrWhitespaces((String)etcDir) && !Utils.isEmptyOrWhitespaces((String)messagingType)) {
            File f = new File(etcDir, "net.roboconf.messaging." + messagingType + ".cfg");
            Logger logger = Logger.getLogger(this.getClass().getName());
            Properties props = Utils.readPropertiesFileQuietly((File)f, (Logger)logger);
            props.putAll(msgData);
            props.remove("net.roboconf.messaging.type");
            Utils.writePropertiesFile((Properties)props, (File)f);
            f = new File(etcDir, "net.roboconf.agent.configuration.cfg");
            props = Utils.readPropertiesFileQuietly((File)f, (Logger)Logger.getLogger(this.getClass().getName()));
            if (messagingType != null) {
                props.put("messaging-type", messagingType);
                Utils.writePropertiesFile((Properties)props, (File)f);
            }
        }
    }

    private static String getValueOfTagInXMLFile(String filePath, String tagName) throws ParserConfigurationException, SAXException, IOException {
        File fXmlFile = new File(filePath);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(fXmlFile);
        doc.getDocumentElement().normalize();
        NodeList nList = doc.getElementsByTagName(tagName);
        String valueOfTagName = "";
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Node nNode = nList.item(temp);
            valueOfTagName = nNode.getTextContent();
        }
        return valueOfTagName;
    }

    private static String getSpecificAttributeOfTagInXMLFile(String filePath, String tagName, String attrName) throws ParserConfigurationException, SAXException, IOException {
        File fXmlFile = new File(filePath);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(fXmlFile);
        doc.getDocumentElement().normalize();
        NodeList nList = doc.getElementsByTagName(tagName);
        Node aNode = nList.item(2);
        NamedNodeMap attributes = aNode.getAttributes();
        String attrValue = "";
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node theAttribute = attributes.item(a);
            if (!attrName.equals(theAttribute.getNodeName())) continue;
            attrValue = theAttribute.getTextContent().split(":")[0];
        }
        return attrValue;
    }
}

