/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.internal.misc;

import java.util.logging.Logger;
import net.roboconf.core.model.beans.Import;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.plugin.api.PluginException;
import net.roboconf.plugin.api.PluginInterface;

public class PluginMock
implements PluginInterface {
    public static final String INIT_PROPERTY = "initialized";
    public static final String PLUGIN_NAME = "mock";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private String agentId;
    private Instance.InstanceStatus currentState = Instance.InstanceStatus.NOT_DEPLOYED;

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    public void setNames(String applicationName, String rootInstanceName) {
        this.agentId = "'" + rootInstanceName + "' agent";
    }

    public void initialize(Instance instance) throws PluginException {
        String name = instance != null ? instance.getName() : null;
        this.logger.fine(this.agentId + " is initializing the plug-in for " + name + ".");
        if (instance != null) {
            instance.data.put(INIT_PROPERTY, "true");
        }
    }

    public void deploy(Instance instance) throws PluginException {
        String name = instance != null ? instance.getName() : null;
        this.logger.info(this.agentId + " is deploying instance " + name + ".");
        this.currentState = Instance.InstanceStatus.DEPLOYED_STOPPED;
    }

    public void start(Instance instance) throws PluginException {
        String name = instance != null ? instance.getName() : null;
        this.logger.info(this.agentId + " is starting instance " + name + ".");
        this.currentState = Instance.InstanceStatus.DEPLOYED_STARTED;
    }

    public void update(Instance instance, Import importChanged, Instance.InstanceStatus statusChanged) throws PluginException {
        String name = instance != null ? instance.getName() : null;
        this.logger.info(this.agentId + " is updating instance " + name + ".");
    }

    public void stop(Instance instance) throws PluginException {
        String name = instance != null ? instance.getName() : null;
        this.logger.info(this.agentId + " is stopping instance " + name + ".");
        this.currentState = Instance.InstanceStatus.DEPLOYED_STOPPED;
    }

    public void undeploy(Instance instance) throws PluginException {
        String name = instance != null ? instance.getName() : null;
        this.logger.info(this.agentId + " is undeploying instance " + name + ".");
        this.currentState = Instance.InstanceStatus.NOT_DEPLOYED;
    }

    public Instance.InstanceStatus getCurrentState() {
        return this.currentState;
    }
}

