/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.internal.misc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.utils.ProgramUtils;
import net.roboconf.core.utils.Utils;

public final class AgentUtils {
    public static final String INJECTED_CONFIGS_DIR = "roboconf/cfg-injection";

    private AgentUtils() {
    }

    public static boolean isValidIP(String ip) {
        boolean result;
        block3: {
            result = false;
            try {
                String[] parts;
                if (Utils.isEmptyOrWhitespaces((String)ip) || (parts = ip.split("\\.")).length != 4) break block3;
                result = true;
                for (String s : parts) {
                    int part = Integer.parseInt(s);
                    if (part >= 0 && part <= 255) continue;
                    result = false;
                    break;
                }
            }
            catch (NumberFormatException e) {
                result = false;
            }
        }
        return result;
    }

    public static void copyInstanceResources(Instance instance, Map<String, byte[]> fileNameToFileContent) throws IOException {
        File dir = InstanceHelpers.findInstanceDirectoryOnAgent((Instance)instance);
        Utils.createDirectory((File)dir);
        if (fileNameToFileContent != null) {
            for (Map.Entry<String, byte[]> entry : fileNameToFileContent.entrySet()) {
                File f = new File(dir, entry.getKey());
                Utils.createDirectory((File)f.getParentFile());
                ByteArrayInputStream in = new ByteArrayInputStream(entry.getValue());
                Utils.copyStream((InputStream)in, (File)f);
            }
        }
    }

    public static void executeScriptResources(File scriptsDir) throws IOException {
        if (scriptsDir.isDirectory()) {
            List scriptFiles = Utils.listAllFiles((File)scriptsDir);
            Logger logger = Logger.getLogger(AgentUtils.class.getName());
            for (File script : scriptFiles) {
                if (!script.getName().contains("agent.script.")) continue;
                script.setExecutable(true);
                String[] command = new String[]{script.getAbsolutePath()};
                try {
                    ProgramUtils.executeCommand((Logger)logger, (String[])command, (File)script.getParentFile(), null, null, null);
                }
                catch (InterruptedException e) {
                    Utils.logException((Logger)logger, (Throwable)e);
                }
            }
        }
    }

    public static void deleteInstanceResources(Instance instance) throws IOException {
        File dir = InstanceHelpers.findInstanceDirectoryOnAgent((Instance)instance);
        Utils.deleteFilesRecursively((File[])new File[]{dir});
    }

    public static void changeRoboconfLogLevel(String logLevel, String etcDir) throws IOException {
        File f;
        if (!Utils.isEmptyOrWhitespaces((String)etcDir) && (f = new File(etcDir, "org.ops4j.pax.logging.cfg")).exists()) {
            Properties props = Utils.readPropertiesFile((File)f);
            props.put("log4j.logger.net.roboconf", logLevel + ", roboconf");
            Utils.writePropertiesFile((Properties)props, (File)f);
        }
    }

    public static Map<String, byte[]> collectLogs(String karafData) throws IOException {
        HashMap<String, byte[]> logFiles = new HashMap<String, byte[]>(2);
        if (!Utils.isEmptyOrWhitespaces((String)karafData)) {
            String[] names;
            for (String name : names = new String[]{"karaf.log", "roboconf.log"}) {
                File log = new File(karafData, "log/" + name);
                if (!log.exists()) continue;
                String content = Utils.readFileContent((File)log);
                logFiles.put(name, content.getBytes(StandardCharsets.UTF_8));
            }
        }
        return logFiles;
    }

    public static String findIpAddress(String networkInterface) {
        String ipAddress = null;
        Logger logger = Logger.getLogger(AgentUtils.class.getName());
        try {
            NetworkInterface nif;
            if (networkInterface != null && !"rbcf-default-network".equalsIgnoreCase(networkInterface) && (nif = NetworkInterface.getByName(networkInterface)) != null) {
                Enumeration<InetAddress> addrs = nif.getInetAddresses();
                while (addrs.hasMoreElements() && (ipAddress == null || ipAddress.startsWith("127.0"))) {
                    InetAddress obj = addrs.nextElement();
                    if (!(obj instanceof Inet4Address) || !(ipAddress = ((Object)obj).toString()).startsWith("/")) continue;
                    ipAddress = ipAddress.substring(1);
                }
            } else if (!"rbcf-default-network".equalsIgnoreCase(networkInterface)) {
                logger.severe("Network interface " + networkInterface + " does not exists. The host's default IP will be picked up.");
            }
            if (ipAddress == null) {
                logger.fine("Picking up the host's default IP address.");
                ipAddress = InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (Exception e) {
            ipAddress = "127.0.0.1";
            logger.warning("The IP address could not be found. " + e.getMessage());
            Utils.logException((Logger)logger, (Throwable)e);
        }
        logger.info("The agent's address was resolved to " + ipAddress);
        return ipAddress;
    }

    public static void injectConfigurations(String karafEtc, String applicationName, String scopedInstancePath, String domain, String ipAddress) {
        File injectionDir = new File(karafEtc, INJECTED_CONFIGS_DIR);
        if (injectionDir.isDirectory()) {
            for (File source : Utils.listAllFiles((File)injectionDir, (String)".cfg.tpl")) {
                try {
                    File target = new File(karafEtc, source.getName().replaceFirst("\\.tpl$", ""));
                    if ("net.roboconf.agent.configuration.cfg".equalsIgnoreCase(target.getName())) continue;
                    String content = Utils.readFileContent((File)source);
                    content = content.replace("<domain>", domain);
                    content = content.replace("<application-name>", applicationName);
                    content = content.replace("<scoped-instance-path>", scopedInstancePath);
                    content = content.replace("<ip-address>", ipAddress);
                    Utils.writeStringInto((String)content, (File)target);
                }
                catch (IOException e) {
                    Logger logger = Logger.getLogger(AgentUtils.class.getName());
                    logger.severe("A configuration file could not be injected from " + source.getName());
                    Utils.logException((Logger)logger, (Throwable)e);
                }
            }
        }
    }
}

