/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.internal.lifecycle;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.roboconf.agent.internal.lifecycle.AbstractLifeCycleManager;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.messaging.api.business.IAgentClient;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifInstanceChanged;
import net.roboconf.plugin.api.PluginException;
import net.roboconf.plugin.api.PluginInterface;

class Unresolved
extends AbstractLifeCycleManager {
    public Unresolved(String appName, IAgentClient messagingClient) {
        super(appName, messagingClient);
    }

    @Override
    public void changeInstanceState(Instance instance, PluginInterface plugin, Instance.InstanceStatus newStatus, Map<String, byte[]> fileNameToFileContent) throws IOException, PluginException {
        if (newStatus == Instance.InstanceStatus.NOT_DEPLOYED) {
            this.undeploy(instance, plugin);
        } else if (newStatus == Instance.InstanceStatus.DEPLOYED_STOPPED) {
            instance.setStatus(Instance.InstanceStatus.DEPLOYED_STOPPED);
            this.messagingClient.sendMessageToTheDm((Message)new MsgNotifInstanceChanged(this.appName, instance));
            List childrenInstances = InstanceHelpers.buildHierarchicalList((Instance)instance);
            childrenInstances.remove(instance);
            for (Instance childInstance : childrenInstances) {
                if (childInstance.getStatus() != Instance.InstanceStatus.WAITING_FOR_ANCESTOR) continue;
                childInstance.setStatus(Instance.InstanceStatus.DEPLOYED_STOPPED);
                this.messagingClient.sendMessageToTheDm((Message)new MsgNotifInstanceChanged(this.appName, childInstance));
            }
        }
    }
}

