/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.internal.lifecycle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.roboconf.agent.internal.lifecycle.DeployedStarted;
import net.roboconf.agent.internal.lifecycle.DeployedStopped;
import net.roboconf.agent.internal.lifecycle.NotDeployed;
import net.roboconf.agent.internal.lifecycle.TransitiveStates;
import net.roboconf.agent.internal.lifecycle.Unresolved;
import net.roboconf.agent.internal.lifecycle.WaitingForAncestor;
import net.roboconf.agent.internal.misc.AgentUtils;
import net.roboconf.core.model.beans.Import;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ImportHelpers;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.business.IAgentClient;
import net.roboconf.messaging.api.business.ListenerCommand;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifInstanceChanged;
import net.roboconf.plugin.api.PluginException;
import net.roboconf.plugin.api.PluginInterface;

public abstract class AbstractLifeCycleManager {
    private static final String FORCE = "force";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    protected final String appName;
    protected final IAgentClient messagingClient;

    protected AbstractLifeCycleManager(String appName, IAgentClient messagingClient) {
        this.appName = appName;
        this.messagingClient = messagingClient;
    }

    public static AbstractLifeCycleManager build(Instance instance, String appName, IAgentClient messagingClient) {
        AbstractLifeCycleManager result;
        switch (instance.getStatus()) {
            case DEPLOYED_STARTED: {
                result = new DeployedStarted(appName, messagingClient);
                break;
            }
            case DEPLOYED_STOPPED: {
                result = new DeployedStopped(appName, messagingClient);
                break;
            }
            case NOT_DEPLOYED: {
                result = new NotDeployed(appName, messagingClient);
                break;
            }
            case UNRESOLVED: {
                result = new Unresolved(appName, messagingClient);
                break;
            }
            case WAITING_FOR_ANCESTOR: {
                result = new WaitingForAncestor(appName, messagingClient);
                break;
            }
            default: {
                result = new TransitiveStates(appName, messagingClient);
            }
        }
        return result;
    }

    public abstract void changeInstanceState(Instance var1, PluginInterface var2, Instance.InstanceStatus var3, Map<String, byte[]> var4) throws IOException, PluginException;

    public void updateStateFromImports(Instance impactedInstance, PluginInterface plugin, Import importChanged, Instance.InstanceStatus statusChanged) throws IOException, PluginException {
        boolean haveAllImports = ImportHelpers.hasAllRequiredImports((Instance)impactedInstance, (Logger)this.logger);
        if (haveAllImports) {
            if (impactedInstance.getStatus() == Instance.InstanceStatus.UNRESOLVED || impactedInstance.data.remove(FORCE) != null) {
                Instance.InstanceStatus oldState = impactedInstance.getStatus();
                impactedInstance.setStatus(Instance.InstanceStatus.STARTING);
                try {
                    this.messagingClient.sendMessageToTheDm((Message)new MsgNotifInstanceChanged(this.appName, impactedInstance));
                    plugin.start(impactedInstance);
                    impactedInstance.setStatus(Instance.InstanceStatus.DEPLOYED_STARTED);
                    this.messagingClient.sendMessageToTheDm((Message)new MsgNotifInstanceChanged(this.appName, impactedInstance));
                    this.messagingClient.publishExports(impactedInstance);
                    this.messagingClient.listenToRequestsFromOtherAgents(ListenerCommand.START, impactedInstance);
                }
                catch (Exception e) {
                    this.logger.severe("An error occured while starting " + InstanceHelpers.computeInstancePath((Instance)impactedInstance));
                    Utils.logException((Logger)this.logger, (Throwable)e);
                    impactedInstance.setStatus(oldState);
                    this.messagingClient.sendMessageToTheDm((Message)new MsgNotifInstanceChanged(this.appName, impactedInstance));
                }
            } else if (impactedInstance.getStatus() == Instance.InstanceStatus.DEPLOYED_STARTED) {
                plugin.update(impactedInstance, importChanged, statusChanged);
            } else {
                this.logger.fine(InstanceHelpers.computeInstancePath((Instance)impactedInstance) + " checked import changes but has nothing to update (1).");
            }
        } else if (impactedInstance.getStatus() == Instance.InstanceStatus.DEPLOYED_STARTED) {
            this.stopInstance(impactedInstance, plugin, true);
        } else {
            this.logger.fine(InstanceHelpers.computeInstancePath((Instance)impactedInstance) + " checked import changes but has nothing to update (2).");
        }
    }

    void deploy(Instance instance, PluginInterface plugin, Map<String, byte[]> fileNameToFileContent) throws IOException {
        String instancePath = InstanceHelpers.computeInstancePath((Instance)instance);
        if (instance.getStatus() != Instance.InstanceStatus.NOT_DEPLOYED) {
            this.logger.fine(instancePath + " cannot be deployed. Prerequisite status: NOT_DEPLOYED (but was " + instance.getStatus() + ").");
        } else if (instance.getParent() != null && instance.getParent().getStatus() != Instance.InstanceStatus.DEPLOYED_STARTED && instance.getParent().getStatus() != Instance.InstanceStatus.DEPLOYED_STOPPED && instance.getParent().getStatus() != Instance.InstanceStatus.UNRESOLVED && instance.getParent().getStatus() != Instance.InstanceStatus.WAITING_FOR_ANCESTOR) {
            this.logger.fine(instancePath + " cannot be deployed because its parent is not deployed. Parent status: " + instance.getParent().getStatus() + ".");
        } else {
            this.logger.fine("Deploying instance " + instancePath);
            instance.setStatus(Instance.InstanceStatus.DEPLOYING);
            try {
                this.messagingClient.sendMessageToTheDm((Message)new MsgNotifInstanceChanged(this.appName, instance));
                AgentUtils.deleteInstanceResources(instance);
                AgentUtils.copyInstanceResources(instance, fileNameToFileContent);
                plugin.initialize(instance);
                plugin.deploy(instance);
                instance.setStatus(Instance.InstanceStatus.DEPLOYED_STOPPED);
                this.messagingClient.sendMessageToTheDm((Message)new MsgNotifInstanceChanged(this.appName, instance));
            }
            catch (Exception e) {
                this.logger.severe("An error occured while deploying " + instancePath);
                Utils.logException((Logger)this.logger, (Throwable)e);
                instance.setStatus(Instance.InstanceStatus.NOT_DEPLOYED);
                this.messagingClient.sendMessageToTheDm((Message)new MsgNotifInstanceChanged(this.appName, instance));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void undeploy(Instance instance, PluginInterface plugin) throws IOException {
        String instancePath = InstanceHelpers.computeInstancePath((Instance)instance);
        if (instance.getStatus() != Instance.InstanceStatus.DEPLOYED_STOPPED && instance.getStatus() != Instance.InstanceStatus.UNRESOLVED && instance.getStatus() != Instance.InstanceStatus.WAITING_FOR_ANCESTOR) {
            this.logger.fine(instancePath + " cannot be undeployed. Prerequisite status: DEPLOYED_STOPPED or UNRESOLVED or WAITING_FOR_ANCESTOR (but was " + instance.getStatus() + ").");
            return;
        }
        List instancesToUndeploy = InstanceHelpers.buildHierarchicalList((Instance)instance);
        Collections.reverse(instancesToUndeploy);
        Instance.InstanceStatus newStatus = Instance.InstanceStatus.NOT_DEPLOYED;
        try {
            for (Instance i : instancesToUndeploy) {
                if (i.getStatus() == Instance.InstanceStatus.NOT_DEPLOYED) continue;
                i.setStatus(Instance.InstanceStatus.UNDEPLOYING);
                this.messagingClient.sendMessageToTheDm((Message)new MsgNotifInstanceChanged(this.appName, i));
                this.messagingClient.unpublishExports(i);
            }
            try {
                plugin.undeploy(instance);
                for (Instance i : instancesToUndeploy) {
                    AgentUtils.deleteInstanceResources(i);
                }
            }
            catch (PluginException e) {
                this.logger.severe("An error occured while undeploying " + InstanceHelpers.computeInstancePath((Instance)instance));
                Utils.logException((Logger)this.logger, (Throwable)e);
                newStatus = Instance.InstanceStatus.DEPLOYED_STOPPED;
            }
        }
        catch (Exception e) {
            newStatus = Instance.InstanceStatus.DEPLOYED_STOPPED;
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
        finally {
            for (Instance i : instancesToUndeploy) {
                i.setStatus(newStatus);
                this.messagingClient.sendMessageToTheDm((Message)new MsgNotifInstanceChanged(this.appName, i));
            }
        }
    }

    void start(Instance instance, PluginInterface plugin) throws IOException {
        String instancePath = InstanceHelpers.computeInstancePath((Instance)instance);
        if (instance.getStatus() != Instance.InstanceStatus.DEPLOYED_STOPPED && instance.getStatus() != Instance.InstanceStatus.WAITING_FOR_ANCESTOR) {
            this.logger.fine(instancePath + " cannot be started. Prerequisite status: DEPLOYED_STOPPED or WAITING_FOR_ANCESTOR (but was " + instance.getStatus() + ").");
        } else if (instance.getParent() != null && instance.getParent().getStatus() != Instance.InstanceStatus.DEPLOYED_STARTED) {
            this.logger.fine(instancePath + " cannot be started because its parent is not started. Parent status: " + instance.getParent().getStatus() + ".");
            if (instance.getParent().getStatus() == Instance.InstanceStatus.UNRESOLVED || instance.getParent().getStatus() == Instance.InstanceStatus.WAITING_FOR_ANCESTOR) {
                instance.setStatus(Instance.InstanceStatus.WAITING_FOR_ANCESTOR);
                this.logger.fine(instancePath + " will start as soon as its parent starts.");
            }
        } else {
            try {
                if (ImportHelpers.hasAllRequiredImports((Instance)instance, (Logger)this.logger)) {
                    instance.data.put(FORCE, "whatever");
                    this.updateStateFromImports(instance, plugin, null, null);
                } else {
                    this.logger.fine("Instance " + InstanceHelpers.computeInstancePath((Instance)instance) + " cannot be started, dependencies are missing. Requesting exports from other agents.");
                    instance.setStatus(Instance.InstanceStatus.UNRESOLVED);
                    this.messagingClient.sendMessageToTheDm((Message)new MsgNotifInstanceChanged(this.appName, instance));
                    this.messagingClient.requestExportsFromOtherAgents(instance);
                }
            }
            catch (PluginException e) {
                this.logger.severe("An error occured while starting " + InstanceHelpers.computeInstancePath((Instance)instance));
                Utils.logException((Logger)this.logger, (Throwable)e);
                instance.setStatus(Instance.InstanceStatus.DEPLOYED_STOPPED);
                this.messagingClient.sendMessageToTheDm((Message)new MsgNotifInstanceChanged(this.appName, instance));
            }
        }
    }

    void stop(Instance instance, PluginInterface plugin) throws IOException {
        String instancePath = InstanceHelpers.computeInstancePath((Instance)instance);
        if (instance.getStatus() != Instance.InstanceStatus.DEPLOYED_STARTED) {
            this.logger.fine(instancePath + " cannot be stopped. Prerequisite status: DEPLOYED_STARTED (but was " + instance.getStatus() + ").");
        } else {
            this.stopInstance(instance, plugin, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopInstance(Instance instance, PluginInterface plugin, boolean isDueToImportsChange) throws IOException {
        this.logger.fine("Stopping instance " + InstanceHelpers.computeInstancePath((Instance)instance) + "...");
        List instancesToStop = InstanceHelpers.buildHierarchicalList((Instance)instance);
        Collections.reverse(instancesToStop);
        try {
            for (Instance i : instancesToStop) {
                if (i.getStatus() != Instance.InstanceStatus.DEPLOYED_STARTED) continue;
                i.setStatus(Instance.InstanceStatus.STOPPING);
                this.messagingClient.sendMessageToTheDm((Message)new MsgNotifInstanceChanged(this.appName, i));
                this.messagingClient.listenToRequestsFromOtherAgents(ListenerCommand.STOP, i);
                this.messagingClient.unpublishExports(i);
            }
            try {
                plugin.stop(instance);
            }
            catch (PluginException e) {
                this.logger.severe("An error occured while stopping " + InstanceHelpers.computeInstancePath((Instance)instance));
                Utils.logException((Logger)this.logger, (Throwable)e);
            }
        }
        finally {
            ArrayList<Instance> forNotifications = new ArrayList<Instance>();
            for (Instance i : instancesToStop) {
                if (i.getStatus() != Instance.InstanceStatus.STOPPING && i.getStatus() != Instance.InstanceStatus.UNRESOLVED) continue;
                Instance.InstanceStatus newStatus = !isDueToImportsChange ? Instance.InstanceStatus.DEPLOYED_STOPPED : (i == instance ? Instance.InstanceStatus.UNRESOLVED : Instance.InstanceStatus.WAITING_FOR_ANCESTOR);
                i.setStatus(newStatus);
                forNotifications.add(i);
            }
            for (Instance i : forNotifications) {
                this.messagingClient.sendMessageToTheDm((Message)new MsgNotifInstanceChanged(this.appName, i));
            }
        }
    }
}

