/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.internal;

import java.util.concurrent.atomic.AtomicInteger;
import net.roboconf.core.model.beans.Import;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.plugin.api.PluginException;
import net.roboconf.plugin.api.PluginInterface;

public class PluginProxy
implements PluginInterface {
    static AtomicInteger initializeCount = new AtomicInteger(0);
    static AtomicInteger deployCount = new AtomicInteger(0);
    static AtomicInteger undeployCount = new AtomicInteger(0);
    static AtomicInteger startCount = new AtomicInteger(0);
    static AtomicInteger stopCount = new AtomicInteger(0);
    static AtomicInteger updateCount = new AtomicInteger(0);
    static AtomicInteger errorCount = new AtomicInteger(0);
    PluginInterface plugin;

    public PluginProxy(PluginInterface plugin) {
        this.plugin = plugin;
    }

    public static synchronized void resetAllCounters() {
        initializeCount.set(0);
        deployCount.set(0);
        undeployCount.set(0);
        startCount.set(0);
        stopCount.set(0);
        updateCount.set(0);
        errorCount.set(0);
    }

    public void initialize(Instance instance) throws PluginException {
        try {
            this.plugin.initialize(instance);
        }
        catch (PluginException e) {
            PluginProxy.incrementErrorCount();
            throw e;
        }
        initializeCount.incrementAndGet();
    }

    public void deploy(Instance instance) throws PluginException {
        try {
            this.plugin.deploy(instance);
        }
        catch (PluginException e) {
            PluginProxy.incrementErrorCount();
            throw e;
        }
        deployCount.incrementAndGet();
    }

    public void start(Instance instance) throws PluginException {
        try {
            this.plugin.start(instance);
        }
        catch (PluginException e) {
            PluginProxy.incrementErrorCount();
            throw e;
        }
        startCount.incrementAndGet();
    }

    public void update(Instance instance, Import importChanged, Instance.InstanceStatus statusChanged) throws PluginException {
        try {
            this.plugin.update(instance, importChanged, statusChanged);
        }
        catch (PluginException e) {
            PluginProxy.incrementErrorCount();
            throw e;
        }
        updateCount.incrementAndGet();
    }

    public void stop(Instance instance) throws PluginException {
        try {
            this.plugin.stop(instance);
        }
        catch (PluginException e) {
            PluginProxy.incrementErrorCount();
            throw e;
        }
        stopCount.incrementAndGet();
    }

    public void undeploy(Instance instance) throws PluginException {
        try {
            this.plugin.undeploy(instance);
        }
        catch (PluginException e) {
            PluginProxy.incrementErrorCount();
            throw e;
        }
        undeployCount.incrementAndGet();
    }

    public void setNames(String applicationName, String rootInstanceName) {
        this.plugin.setNames(applicationName, rootInstanceName);
    }

    public String getPluginName() {
        return this.plugin.getPluginName();
    }

    public static int getInitializeCount() {
        return initializeCount.intValue();
    }

    public static int getDeployCount() {
        return deployCount.intValue();
    }

    public static int getUndeployCount() {
        return undeployCount.intValue();
    }

    public static int getStartCount() {
        return startCount.intValue();
    }

    public static int getStopCount() {
        return stopCount.intValue();
    }

    public static int getUpdateCount() {
        return updateCount.intValue();
    }

    public static int getErrorCount() {
        return errorCount.intValue();
    }

    public PluginInterface getPlugin() {
        return this.plugin;
    }

    private static void incrementErrorCount() {
        errorCount.incrementAndGet();
    }
}

