/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.monitoring.internal.nagios;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import net.roboconf.core.utils.Utils;

public class LiveStatusClient {
    private static final String NAGIOS_COLUMNS = "columns:";
    static final String DEFAULT_HOST = "localhost";
    static final int DEFAULT_PORT = 50000;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    final String host;
    final int port;

    public LiveStatusClient(String host, int port) {
        this.host = Utils.isEmptyOrWhitespaces((String)host) ? DEFAULT_HOST : host;
        this.port = port < 1 ? 50000 : port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryLivestatus(String nagiosQuery) throws UnknownHostException, IOException {
        Socket liveStatusSocket = null;
        try {
            this.logger.fine("About to open a connection through Live Status...");
            liveStatusSocket = new Socket(this.host, this.port);
            this.logger.fine("A connection was established through Live Status.");
            OutputStreamWriter osw = new OutputStreamWriter(liveStatusSocket.getOutputStream(), StandardCharsets.UTF_8);
            PrintWriter printer = new PrintWriter((Writer)osw, false);
            printer.print(nagiosQuery);
            printer.flush();
            liveStatusSocket.shutdownOutput();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Utils.copyStreamSafely((InputStream)liveStatusSocket.getInputStream(), (ByteArrayOutputStream)os);
            String result = os.toString("UTF-8");
            String string = result = this.format(nagiosQuery, result);
            return string;
        }
        finally {
            if (liveStatusSocket != null) {
                liveStatusSocket.close();
            }
            this.logger.fine("The Live Status connection was closed.");
        }
    }

    String format(String request, String liveStatusResponse) {
        String columnsDecl = null;
        for (String s : request.split("\n")) {
            if (!(s = s.trim()).toLowerCase().startsWith(NAGIOS_COLUMNS)) continue;
            columnsDecl = s.substring(NAGIOS_COLUMNS.length()).trim();
            break;
        }
        String result = liveStatusResponse;
        if (columnsDecl != null) {
            columnsDecl = columnsDecl.replaceAll("\\s+", ";");
            result = columnsDecl + "\n" + result;
        }
        return result;
    }
}

