/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.monitoring.internal.file;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import net.roboconf.agent.monitoring.api.IMonitoringHandler;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifAutonomic;

public class FileHandler
implements IMonitoringHandler {
    static final String HANDLER_NAME = "file";
    static final String DELETE_IF_EXISTS = "delete if exists";
    static final String NOTIFY_IF_NOT_EXISTS = "notify if not exists";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private String applicationName;
    private String scopedInstancePath;
    private String eventId;
    String fileLocation;
    boolean deleteIfExists = false;
    boolean notifyIfNotExists = false;

    public String getName() {
        return HANDLER_NAME;
    }

    public void setAgentId(String applicationName, String scopedInstancePath) {
        this.applicationName = applicationName;
        this.scopedInstancePath = scopedInstancePath;
    }

    public void reset(Instance associatedInstance, String eventId, String fileContent) {
        this.eventId = eventId;
        if ((fileContent = fileContent.trim()).contains("\n")) {
            this.logger.severe("Invalid content for the 'file' handler in the agent's monitoring.");
        } else {
            this.fileLocation = fileContent;
            this.notifyIfNotExists = false;
            this.deleteIfExists = false;
            if (this.fileLocation.toLowerCase().startsWith(DELETE_IF_EXISTS)) {
                this.deleteIfExists = true;
                this.fileLocation = this.fileLocation.substring(DELETE_IF_EXISTS.length()).trim();
            } else if (this.fileLocation.toLowerCase().startsWith(NOTIFY_IF_NOT_EXISTS)) {
                this.notifyIfNotExists = true;
                this.fileLocation = this.fileLocation.substring(NOTIFY_IF_NOT_EXISTS.length()).trim();
            }
        }
    }

    public MsgNotifAutonomic process() {
        MsgNotifAutonomic result = null;
        try {
            if (this.fileLocation != null) {
                File f = new File(this.fileLocation);
                String cause = null;
                if (!f.exists() && this.notifyIfNotExists) {
                    cause = this.fileLocation + " does not exist.";
                } else if (f.exists()) {
                    if (this.deleteIfExists) {
                        Utils.deleteFilesRecursively((File[])new File[]{f});
                    }
                    cause = this.fileLocation + " was " + (this.deleteIfExists ? "deleted" : "checked") + ".";
                }
                if (cause != null) {
                    result = new MsgNotifAutonomic(this.applicationName, this.scopedInstancePath, this.eventId, cause);
                }
            }
        }
        catch (IOException e) {
            this.logger.severe("Cannot delete file " + this.fileLocation + ". Monitoring notification is discarded.");
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
        return result;
    }
}

