/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.monitoring.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.roboconf.agent.AgentMessagingInterface;
import net.roboconf.agent.monitoring.api.IMonitoringHandler;
import net.roboconf.agent.monitoring.internal.MonitoringRunnable;
import net.roboconf.agent.monitoring.internal.file.FileHandler;
import net.roboconf.agent.monitoring.internal.nagios.NagiosHandler;
import net.roboconf.agent.monitoring.internal.rest.RestHandler;
import net.roboconf.core.Constants;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;

public class AgentMonitoring
implements Pojo {
    InstanceManager __IM;
    private boolean __FagentInterface;
    private AgentMessagingInterface agentInterface;
    private boolean __Fhandlers;
    private final List<IMonitoringHandler> handlers;
    private boolean __Flogger;
    private final Logger logger;
    private boolean __Ftimer;
    private ScheduledThreadPoolExecutor timer;
    boolean __Mstart;
    boolean __Mstop;
    boolean __MhandlerAppears$net_roboconf_agent_monitoring_api_IMonitoringHandler;
    boolean __MhandlerDisappears$net_roboconf_agent_monitoring_api_IMonitoringHandler;
    boolean __MsetAgentInterface$net_roboconf_agent_AgentMessagingInterface;

    AgentMessagingInterface __getagentInterface() {
        if (!this.__FagentInterface) {
            return this.agentInterface;
        }
        return (AgentMessagingInterface)this.__IM.onGet((Object)this, "agentInterface");
    }

    void __setagentInterface(AgentMessagingInterface agentMessagingInterface) {
        if (!this.__FagentInterface) {
            this.agentInterface = agentMessagingInterface;
            return;
        }
        this.__IM.onSet((Object)this, "agentInterface", (Object)agentMessagingInterface);
    }

    List __gethandlers() {
        if (!this.__Fhandlers) {
            return this.handlers;
        }
        return (List)this.__IM.onGet((Object)this, "handlers");
    }

    void __sethandlers(List list) {
        if (!this.__Fhandlers) {
            this.handlers = list;
            return;
        }
        this.__IM.onSet((Object)this, "handlers", (Object)list);
    }

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    ScheduledThreadPoolExecutor __gettimer() {
        if (!this.__Ftimer) {
            return this.timer;
        }
        return (ScheduledThreadPoolExecutor)this.__IM.onGet((Object)this, "timer");
    }

    void __settimer(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        if (!this.__Ftimer) {
            this.timer = scheduledThreadPoolExecutor;
            return;
        }
        this.__IM.onSet((Object)this, "timer", (Object)scheduledThreadPoolExecutor);
    }

    public AgentMonitoring() {
        this(null);
    }

    private AgentMonitoring(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__sethandlers(new ArrayList());
        this.__setlogger(Logger.getLogger(this.getClass().getName()));
        this.handlerAppears(new FileHandler());
        this.handlerAppears(new NagiosHandler());
        this.handlerAppears(new RestHandler());
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __M_start() {
        if (this.__gettimer() == null) {
            this.__getlogger().fine("Agent Monitoring is being started.");
            this.__settimer(new ScheduledThreadPoolExecutor(1));
            this.__gettimer().scheduleWithFixedDelay(new MonitoringRunnable(this.__getagentInterface(), this.__gethandlers()), 0L, Constants.PROBES_POLLING_PERIOD, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __M_stop() {
        this.__getlogger().fine("Agent Monitoring is being stopped.");
        if (this.__gettimer() != null) {
            this.__gettimer().shutdownNow();
            this.__settimer(null);
        }
    }

    public void handlerAppears(IMonitoringHandler handler) {
        if (!this.__MhandlerAppears$net_roboconf_agent_monitoring_api_IMonitoringHandler) {
            this.__M_handlerAppears(handler);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "handlerAppears$net_roboconf_agent_monitoring_api_IMonitoringHandler", new Object[]{handler});
            this.__M_handlerAppears(handler);
            this.__IM.onExit((Object)this, "handlerAppears$net_roboconf_agent_monitoring_api_IMonitoringHandler", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "handlerAppears$net_roboconf_agent_monitoring_api_IMonitoringHandler", throwable);
            throw throwable;
        }
    }

    private void __M_handlerAppears(IMonitoringHandler handler) {
        if (handler != null) {
            this.__getlogger().info("Monitoring handler '" + handler.getName() + "' is now available.");
            this.__gethandlers().add(handler);
            AgentMonitoring.listHandlers(this.__gethandlers(), this.__getlogger());
        }
    }

    public void handlerDisappears(IMonitoringHandler handler) {
        if (!this.__MhandlerDisappears$net_roboconf_agent_monitoring_api_IMonitoringHandler) {
            this.__M_handlerDisappears(handler);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "handlerDisappears$net_roboconf_agent_monitoring_api_IMonitoringHandler", new Object[]{handler});
            this.__M_handlerDisappears(handler);
            this.__IM.onExit((Object)this, "handlerDisappears$net_roboconf_agent_monitoring_api_IMonitoringHandler", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "handlerDisappears$net_roboconf_agent_monitoring_api_IMonitoringHandler", throwable);
            throw throwable;
        }
    }

    private void __M_handlerDisappears(IMonitoringHandler handler) {
        if (handler == null) {
            this.__getlogger().info("An invalid monitoring handler is removed.");
        } else {
            this.__gethandlers().remove(handler);
            this.__getlogger().info("Monitoring handler '" + handler.getName() + "' is not available anymore.");
        }
        AgentMonitoring.listHandlers(this.__gethandlers(), this.__getlogger());
    }

    public void setAgentInterface(AgentMessagingInterface agentInterface) {
        if (!this.__MsetAgentInterface$net_roboconf_agent_AgentMessagingInterface) {
            this.__M_setAgentInterface(agentInterface);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setAgentInterface$net_roboconf_agent_AgentMessagingInterface", new Object[]{agentInterface});
            this.__M_setAgentInterface(agentInterface);
            this.__IM.onExit((Object)this, "setAgentInterface$net_roboconf_agent_AgentMessagingInterface", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setAgentInterface$net_roboconf_agent_AgentMessagingInterface", throwable);
            throw throwable;
        }
    }

    private void __M_setAgentInterface(AgentMessagingInterface agentInterface) {
        this.__setagentInterface(agentInterface);
    }

    public static void listHandlers(List<IMonitoringHandler> handlers, Logger logger) {
        if (handlers.isEmpty()) {
            logger.info("No monitoring handler was found.");
        } else {
            StringBuilder sb = new StringBuilder("Available monitoring handlers: ");
            Iterator<IMonitoringHandler> it = handlers.iterator();
            while (it.hasNext()) {
                sb.append(it.next().getName());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(".");
            logger.info(sb.toString());
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("agentInterface")) {
                this.__FagentInterface = true;
            }
            if (set.contains("handlers")) {
                this.__Fhandlers = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("timer")) {
                this.__Ftimer = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("handlerAppears$net_roboconf_agent_monitoring_api_IMonitoringHandler")) {
                this.__MhandlerAppears$net_roboconf_agent_monitoring_api_IMonitoringHandler = true;
            }
            if (set.contains("handlerDisappears$net_roboconf_agent_monitoring_api_IMonitoringHandler")) {
                this.__MhandlerDisappears$net_roboconf_agent_monitoring_api_IMonitoringHandler = true;
            }
            if (set.contains("setAgentInterface$net_roboconf_agent_AgentMessagingInterface")) {
                this.__MsetAgentInterface$net_roboconf_agent_AgentMessagingInterface = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

