/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.karaf.commands.agent.misc;

import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.ansi.SimpleAnsi;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@Command(scope="roboconf", name="info", description="Display information about Roboconf and its environment.")
@Service
public class RoboconfInfoCommand
implements Action {
    static final String KARAF_INFO = "info";
    static final int PAD = 25;
    @Reference
    Session session;
    @Reference
    BundleContext ctx;
    PrintStream out = System.out;

    public Object execute() throws Exception {
        ArrayList<String> versions = new ArrayList<String>();
        for (Bundle bundle : this.ctx.getBundles()) {
            if (!"net.roboconf.core".equals(bundle.getSymbolicName())) continue;
            versions.add(bundle.getVersion().toString());
        }
        this.out.println();
        this.out.println("Roboconf");
        if (versions.size() > 1) {
            this.out.println("\n[ WARNING ] Several versions of Roboconf run in the server.");
            this.out.println("[ WARNING ] Please, run bundle:list | grep roboconf-core for more details.");
            this.out.println();
            this.printValue("Roboconf versions", (String)versions.get(0));
            for (int i = 1; i < versions.size(); ++i) {
                this.printValue("", (String)versions.get(i));
            }
        } else if (versions.size() == 1) {
            this.printValue("Roboconf version", (String)versions.get(0));
        } else {
            this.printValue("Roboconf version", "Undetermined");
        }
        this.out.println();
        this.session.execute((CharSequence)KARAF_INFO);
        this.out.println();
        return null;
    }

    private void printValue(String name, String value) {
        this.out.println("  " + SimpleAnsi.INTENSITY_BOLD + name + SimpleAnsi.INTENSITY_NORMAL + this.spaces(25 - name.length()) + "   " + value);
    }

    private String spaces(int nb) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nb; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }
}

