/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.rabbitmq.internal.utils;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.extensions.MessagingContext;

public final class RabbitMqUtils {
    private RabbitMqUtils() {
    }

    public static void configureFactory(ConnectionFactory factory, Map<String, String> configuration) throws IOException {
        Logger logger = Logger.getLogger(RabbitMqUtils.class.getName());
        logger.fine("Configuring a connection factory for RabbitMQ.");
        String messageServerIp = configuration.get("net.roboconf.messaging.rabbitmq.server.ip");
        if (messageServerIp != null) {
            Map.Entry entry = Utils.findUrlAndPort((String)messageServerIp);
            factory.setHost((String)entry.getKey());
            if ((Integer)entry.getValue() > 0) {
                factory.setPort((Integer)entry.getValue());
            }
        }
        factory.setUsername(configuration.get("net.roboconf.messaging.rabbitmq.server.username"));
        factory.setPassword(configuration.get("net.roboconf.messaging.rabbitmq.server.password"));
        factory.setConnectionTimeout(5000);
        factory.setAutomaticRecoveryEnabled(true);
        factory.setNetworkRecoveryInterval(10000);
        factory.setTopologyRecoveryEnabled(true);
        if (Boolean.parseBoolean(configuration.get("net.roboconf.messaging.rabbitmq.ssl.use"))) {
            logger.fine("Connection factory for RabbitMQ: SSL is used.");
            FileInputStream clientIS = null;
            FileInputStream storeIS = null;
            try {
                clientIS = new FileInputStream(configuration.get("net.roboconf.messaging.rabbitmq.ssl.key.store.path"));
                storeIS = new FileInputStream(configuration.get("net.roboconf.messaging.rabbitmq.ssl.trust.store.path"));
                char[] keyStorePassphrase = configuration.get("net.roboconf.messaging.rabbitmq.ssl.key.store.passphrase").toCharArray();
                KeyStore ks = KeyStore.getInstance(Utils.getValue(configuration, (String)"net.roboconf.messaging.rabbitmq.ssl.key.store.type", (String)"PKCS12"));
                ks.load(clientIS, keyStorePassphrase);
                String value = Utils.getValue(configuration, (String)"net.roboconf.messaging.rabbitmq.ssl.key.manager.factory", (String)"SunX509");
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(value);
                kmf.init(ks, keyStorePassphrase);
                char[] trustStorePassphrase = configuration.get("net.roboconf.messaging.rabbitmq.ssl.trust.store.passphrase").toCharArray();
                KeyStore tks = KeyStore.getInstance(Utils.getValue(configuration, (String)"net.roboconf.messaging.rabbitmq.ssl.trust.store.type", (String)"JKS"));
                tks.load(storeIS, trustStorePassphrase);
                value = Utils.getValue(configuration, (String)"net.roboconf.messaging.rabbitmq.ssl.trust.manager.factory", (String)"SunX509");
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(value);
                tmf.init(tks);
                SSLContext c = SSLContext.getInstance(Utils.getValue(configuration, (String)"net.roboconf.messaging.rabbitmq.ssl.protocol", (String)"TLSv1.1"));
                c.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                factory.useSslProtocol(c);
            }
            catch (GeneralSecurityException e) {
                try {
                    throw new IOException("SSL configuration for the RabbitMQ factory failed.", e);
                }
                catch (Throwable throwable) {
                    Utils.closeQuietly(storeIS);
                    Utils.closeQuietly(clientIS);
                    throw throwable;
                }
            }
            Utils.closeQuietly((InputStream)storeIS);
            Utils.closeQuietly((InputStream)clientIS);
        }
    }

    public static void closeConnection(Channel channel) throws IOException {
        if (channel != null) {
            if (channel.isOpen()) {
                channel.close();
            }
            if (channel.getConnection().isOpen()) {
                channel.getConnection().close();
            }
        }
    }

    public static void declareApplicationExchanges(String domain, String applicationName, Channel channel) throws IOException {
        if (applicationName != null) {
            String exch = RabbitMqUtils.buildExchangeNameForAgent(domain, applicationName);
            channel.exchangeDeclare(exch, "topic");
        }
    }

    public static void declareGlobalExchanges(String domain, Channel channel) throws IOException {
        channel.exchangeDeclare(RabbitMqUtils.buildExchangeNameForTheDm(domain), "topic");
        channel.exchangeDeclare(RabbitMqUtils.buildExchangeNameForInterApp(domain), "topic");
    }

    public static String buildExchangeNameForAgent(String domain, String applicationName) {
        return domain + "." + applicationName + ".agents";
    }

    public static String buildExchangeNameForTheDm(String domain) {
        return domain + "." + "roboconf.dm";
    }

    public static String buildExchangeNameForInterApp(String domain) {
        return domain + "." + "roboconf.inter-app";
    }

    public static String buildExchangeName(MessagingContext ctx) {
        String exchangeName = ctx.getKind() == MessagingContext.RecipientKind.DM ? RabbitMqUtils.buildExchangeNameForTheDm(ctx.getDomain()) : (ctx.getKind() == MessagingContext.RecipientKind.INTER_APP ? RabbitMqUtils.buildExchangeNameForInterApp(ctx.getDomain()) : RabbitMqUtils.buildExchangeNameForAgent(ctx.getDomain(), ctx.getApplicationName()));
        return exchangeName;
    }
}

