/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.rabbitmq.internal;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Recoverable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Application;
import net.roboconf.messaging.api.extensions.IMessagingClient;
import net.roboconf.messaging.api.extensions.MessagingContext;
import net.roboconf.messaging.api.jmx.RoboconfMessageQueue;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.reconfigurables.ReconfigurableClient;
import net.roboconf.messaging.api.utils.MessagingUtils;
import net.roboconf.messaging.api.utils.SerializationUtils;
import net.roboconf.messaging.rabbitmq.internal.impl.RoboconfConsumer;
import net.roboconf.messaging.rabbitmq.internal.impl.RoboconfRecoveryListener;
import net.roboconf.messaging.rabbitmq.internal.impl.RoboconfReturnListener;
import net.roboconf.messaging.rabbitmq.internal.utils.RabbitMqUtils;

public class RabbitMqClient
implements IMessagingClient {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Map<String, String> configuration;
    private final WeakReference<ReconfigurableClient<?>> reconfigurable;
    private RoboconfMessageQueue messageQueue;
    private MessagingContext.RecipientKind ownerKind;
    private String applicationName;
    private String scopedInstancePath;
    private String domain;
    String consumerTag;
    Channel channel;

    protected RabbitMqClient(ReconfigurableClient<?> reconfigurable, Map<String, String> messagingProperties) {
        this(reconfigurable, messagingProperties, reconfigurable.getOwnerKind());
    }

    protected RabbitMqClient(ReconfigurableClient<?> reconfigurable, Map<String, String> messagingProperties, MessagingContext.RecipientKind ownerKind) {
        this.reconfigurable = new WeakReference(reconfigurable);
        this.ownerKind = ownerKind;
        LinkedHashMap<String, String> copy = new LinkedHashMap<String, String>(messagingProperties);
        copy.put("net.roboconf.messaging.type", "rabbitmq");
        this.configuration = Collections.unmodifiableMap(copy);
    }

    public final ReconfigurableClient<?> getReconfigurableClient() {
        return (ReconfigurableClient)this.reconfigurable.get();
    }

    public final void setMessageQueue(RoboconfMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    public final synchronized boolean isConnected() {
        return this.channel != null;
    }

    public final String getMessagingType() {
        return "rabbitmq";
    }

    public final Map<String, String> getConfiguration() {
        HashMap<String, String> result = new HashMap<String, String>(this.configuration);
        String useSsl = this.configuration.get("net.roboconf.messaging.rabbitmq.ssl.use");
        ArrayList<String> allSslProperties = new ArrayList<String>(Arrays.asList("net.roboconf.messaging.rabbitmq.ssl.key.store.passphrase", "net.roboconf.messaging.rabbitmq.ssl.key.store.path", "net.roboconf.messaging.rabbitmq.ssl.key.store.type", "net.roboconf.messaging.rabbitmq.ssl.key.manager.factory", "net.roboconf.messaging.rabbitmq.ssl.trust.manager.factory", "net.roboconf.messaging.rabbitmq.ssl.trust.store.passphrase", "net.roboconf.messaging.rabbitmq.ssl.trust.store.path", "net.roboconf.messaging.rabbitmq.ssl.trust.store.type", "net.roboconf.messaging.rabbitmq.ssl.pass.as.user.data", "net.roboconf.messaging.rabbitmq.ssl.protocol", "net.roboconf.messaging.rabbitmq.ssl.use"));
        if (useSsl == null || "false".equalsIgnoreCase(useSsl)) {
            result.keySet().removeAll(allSslProperties);
        } else if ("false".equalsIgnoreCase(this.configuration.get("net.roboconf.messaging.rabbitmq.ssl.pass.as.user.data"))) {
            allSslProperties.remove("net.roboconf.messaging.rabbitmq.ssl.pass.as.user.data");
            allSslProperties.remove("net.roboconf.messaging.rabbitmq.ssl.protocol");
            allSslProperties.remove("net.roboconf.messaging.rabbitmq.ssl.use");
            result.keySet().removeAll(allSslProperties);
        } else {
            result.put("net.roboconf.messaging.rabbitmq.ssl.pass.as.user.data", "true");
            result.put("@file@net.roboconf.messaging.rabbitmq.ssl.key.store.path", "");
            result.put("@file@net.roboconf.messaging.rabbitmq.ssl.trust.store.path", "");
        }
        return result;
    }

    public void setOwnerProperties(MessagingContext.RecipientKind ownerKind, String domain, String applicationName, String scopedInstancePath) {
        this.ownerKind = ownerKind;
        this.applicationName = applicationName;
        this.scopedInstancePath = scopedInstancePath;
        this.domain = domain;
        this.logger.fine("Owner properties changed to " + this.getId());
    }

    public void openConnection() throws IOException {
        this.logger.info(this.getId() + " is opening a connection to RabbitMQ.");
        if (this.isConnected()) {
            this.logger.info(this.getId() + " has already a connection to RabbitMQ.");
            return;
        }
        ConnectionFactory factory = new ConnectionFactory();
        RabbitMqUtils.configureFactory(factory, this.configuration);
        this.channel = factory.newConnection().createChannel();
        this.logger.info(this.getId() + " established a new connection with RabbitMQ. Channel # " + this.channel.getChannelNumber());
        this.channel.addReturnListener(new RoboconfReturnListener());
        ((Recoverable)((Object)this.channel)).addRecoveryListener(new RoboconfRecoveryListener());
        RabbitMqUtils.declareGlobalExchanges(this.domain, this.channel);
        RabbitMqUtils.declareApplicationExchanges(this.domain, this.applicationName, this.channel);
        String queueName = this.getQueueName();
        this.channel.queueDeclare(queueName, true, false, true, null);
        RoboconfConsumer consumer = new RoboconfConsumer(this.getId(), this.channel, this.messageQueue);
        consumer.handleConsumeOk(queueName);
        this.consumerTag = this.channel.basicConsume(queueName, true, consumer);
        this.logger.finer("A new consumer tag was created: " + this.consumerTag);
    }

    public void closeConnection() throws IOException {
        StringBuilder sb = new StringBuilder(this.getId() + " is closing its connection to RabbitMQ.");
        if (this.channel != null) {
            sb.append(" Channel # ").append(this.channel.getChannelNumber());
        }
        this.logger.info(sb.toString());
        if (this.channel != null && this.channel.isOpen() && this.consumerTag != null) {
            this.channel.basicCancel(this.consumerTag);
            this.logger.finer("A consumer tag was cancelled: " + this.consumerTag);
        }
        this.consumerTag = null;
        if (this.isConnected()) {
            this.logger.finer("Closing the connection and the channel # " + this.channel.getChannelNumber());
            RabbitMqUtils.closeConnection(this.channel);
        }
        this.channel = null;
    }

    public void deleteMessagingServerArtifacts(Application application) throws IOException {
        this.channel.exchangeDelete(RabbitMqUtils.buildExchangeNameForAgent(this.domain, application.getName()));
        this.logger.fine("Messaging artifacts were deleted for application " + application);
    }

    public void publish(MessagingContext ctx, Message msg) throws IOException {
        String exchangeName = RabbitMqUtils.buildExchangeName(ctx);
        String routingKey = ctx.getTopicName();
        this.logger.fine("A message is about to be published to " + exchangeName + " with routing key = " + routingKey);
        AMQP.BasicProperties props = null;
        if (ctx.getKind() == MessagingContext.RecipientKind.DM) {
            props = new AMQP.BasicProperties.Builder().expiration("500").build();
        }
        boolean mandatory = false;
        if (this.ownerKind == MessagingContext.RecipientKind.DM && this.ownerKind != ctx.getKind() || this.ownerKind == MessagingContext.RecipientKind.AGENTS && ctx.getKind() == MessagingContext.RecipientKind.DM) {
            mandatory = true;
        }
        this.channel.basicPublish(exchangeName, routingKey, mandatory, false, props, SerializationUtils.serializeObject((Serializable)msg));
    }

    public void subscribe(MessagingContext ctx) throws IOException {
        String exchangeName = RabbitMqUtils.buildExchangeName(ctx);
        String queueName = this.getQueueName();
        this.logger.fine("Binding queue " + queueName + " and exchange " + exchangeName + " with routing key = " + ctx.getTopicName());
        this.channel.queueBind(queueName, exchangeName, ctx.getTopicName());
    }

    public void unsubscribe(MessagingContext ctx) throws IOException {
        String exchangeName = RabbitMqUtils.buildExchangeName(ctx);
        String queueName = this.getQueueName();
        this.logger.fine("Unbinding queue " + queueName + " and exchange " + exchangeName + " with routing key = " + ctx.getTopicName());
        this.channel.queueUnbind(queueName, exchangeName, ctx.getTopicName());
    }

    String getQueueName() {
        StringBuilder queueName = new StringBuilder();
        queueName.append(this.domain);
        queueName.append(".");
        if (this.ownerKind == MessagingContext.RecipientKind.DM) {
            queueName.append("roboconf-dm");
        } else {
            queueName.append(this.applicationName);
            queueName.append(".");
            queueName.append(MessagingUtils.escapeInstancePath((String)this.scopedInstancePath));
        }
        return queueName.toString();
    }

    String getId() {
        return MessagingUtils.buildId((MessagingContext.RecipientKind)this.ownerKind, (String)this.domain, (String)this.applicationName, (String)this.scopedInstancePath);
    }
}

