/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.agent.monitoring.docker.internal;

import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.roboconf.agent.monitoring.api.IMonitoringHandler;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.utils.DockerAndScriptUtils;
import net.roboconf.core.utils.ProgramUtils;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifAutonomic;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;

public class DockerMonitoringHandler
implements IMonitoringHandler,
Pojo {
    InstanceManager __IM;
    static final String HANDLER_NAME = "docker";
    private boolean __FapplicationName;
    String applicationName;
    private boolean __FscopedInstancePath;
    String scopedInstancePath;
    private boolean __FeventName;
    String eventName;
    private boolean __FcontainerName;
    String containerName;
    boolean __MgetName;
    boolean __MsetAgentId$java_lang_String$java_lang_String;
    boolean __Mreset$net_roboconf_core_model_beans_Instance$java_lang_String$java_lang_String;
    boolean __Mprocess;
    boolean __McontainerIsRunning$java_lang_String;

    String __getapplicationName() {
        if (!this.__FapplicationName) {
            return this.applicationName;
        }
        return (String)this.__IM.onGet((Object)this, "applicationName");
    }

    void __setapplicationName(String string) {
        if (!this.__FapplicationName) {
            this.applicationName = string;
            return;
        }
        this.__IM.onSet((Object)this, "applicationName", (Object)string);
    }

    String __getscopedInstancePath() {
        if (!this.__FscopedInstancePath) {
            return this.scopedInstancePath;
        }
        return (String)this.__IM.onGet((Object)this, "scopedInstancePath");
    }

    void __setscopedInstancePath(String string) {
        if (!this.__FscopedInstancePath) {
            this.scopedInstancePath = string;
            return;
        }
        this.__IM.onSet((Object)this, "scopedInstancePath", (Object)string);
    }

    String __geteventName() {
        if (!this.__FeventName) {
            return this.eventName;
        }
        return (String)this.__IM.onGet((Object)this, "eventName");
    }

    void __seteventName(String string) {
        if (!this.__FeventName) {
            this.eventName = string;
            return;
        }
        this.__IM.onSet((Object)this, "eventName", (Object)string);
    }

    String __getcontainerName() {
        if (!this.__FcontainerName) {
            return this.containerName;
        }
        return (String)this.__IM.onGet((Object)this, "containerName");
    }

    void __setcontainerName(String string) {
        if (!this.__FcontainerName) {
            this.containerName = string;
            return;
        }
        this.__IM.onSet((Object)this, "containerName", (Object)string);
    }

    public DockerMonitoringHandler() {
        this(null);
    }

    private DockerMonitoringHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public String getName() {
        String string;
        if (!this.__MgetName) {
            return this.__M_getName();
        }
        try {
            this.__IM.onEntry((Object)this, "getName", new Object[0]);
            string = this.__M_getName();
            this.__IM.onExit((Object)this, "getName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getName() {
        return HANDLER_NAME;
    }

    public void setAgentId(String applicationName, String scopedInstancePath) {
        if (!this.__MsetAgentId$java_lang_String$java_lang_String) {
            this.__M_setAgentId(applicationName, scopedInstancePath);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setAgentId$java_lang_String$java_lang_String", new Object[]{applicationName, scopedInstancePath});
            this.__M_setAgentId(applicationName, scopedInstancePath);
            this.__IM.onExit((Object)this, "setAgentId$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setAgentId$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setAgentId(String applicationName, String scopedInstancePath) {
        this.__setapplicationName(applicationName);
        this.__setscopedInstancePath(scopedInstancePath);
    }

    public void reset(Instance associatedInstance, String eventName, String rawRulesText) {
        if (!this.__Mreset$net_roboconf_core_model_beans_Instance$java_lang_String$java_lang_String) {
            this.__M_reset(associatedInstance, eventName, rawRulesText);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "reset$net_roboconf_core_model_beans_Instance$java_lang_String$java_lang_String", new Object[]{associatedInstance, eventName, rawRulesText});
            this.__M_reset(associatedInstance, eventName, rawRulesText);
            this.__IM.onExit((Object)this, "reset$net_roboconf_core_model_beans_Instance$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "reset$net_roboconf_core_model_beans_Instance$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_reset(Instance associatedInstance, String eventName, String rawRulesText) {
        this.__seteventName(eventName);
        String name = Utils.isEmptyOrWhitespaces((String)rawRulesText) ? "ROBOCONF_CLEAN_REVERSED_INSTANCE_PATH" : rawRulesText.trim();
        for (Map.Entry entry : DockerAndScriptUtils.buildReferenceMap((Instance)associatedInstance).entrySet()) {
            name = name.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        this.__setcontainerName(name);
    }

    public MsgNotifAutonomic process() {
        MsgNotifAutonomic msgNotifAutonomic;
        if (!this.__Mprocess) {
            return this.__M_process();
        }
        try {
            this.__IM.onEntry((Object)this, "process", new Object[0]);
            msgNotifAutonomic = this.__M_process();
            this.__IM.onExit((Object)this, "process", (Object)msgNotifAutonomic);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "process", throwable);
            throw throwable;
        }
        return msgNotifAutonomic;
    }

    private MsgNotifAutonomic __M_process() {
        MsgNotifAutonomic result = null;
        if (!this.containerIsRunning(this.__getcontainerName())) {
            result = new MsgNotifAutonomic(this.__getapplicationName(), this.__getscopedInstancePath(), this.__geteventName(), null);
        }
        return result;
    }

    boolean containerIsRunning(String containerName) {
        boolean bl;
        if (!this.__McontainerIsRunning$java_lang_String) {
            return this.__M_containerIsRunning(containerName);
        }
        try {
            this.__IM.onEntry((Object)this, "containerIsRunning$java_lang_String", new Object[]{containerName});
            bl = this.__M_containerIsRunning(containerName);
            this.__IM.onExit((Object)this, "containerIsRunning$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "containerIsRunning$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_containerIsRunning(String containerName) {
        boolean running = false;
        Logger logger = Logger.getLogger(DockerMonitoringHandler.class.getName());
        try {
            String[] cmd = new String[]{HANDLER_NAME, "inspect", "-f", "{{.State.Running}}", containerName};
            ProgramUtils.ExecutionResult res = ProgramUtils.executeCommandWithResult((Logger)logger, (String[])cmd, null, null, (String)this.__getapplicationName(), (String)this.__getscopedInstancePath());
            logger.finest("Execution's result: " + res.getExitValue());
            logger.finest("Execution's normal output: " + res.getNormalOutput());
            running = res.getExitValue() == 0 && Boolean.parseBoolean(res.getNormalOutput());
        }
        catch (Exception e) {
            logger.severe("An error occurred while verifying that " + containerName + " was still running (in Docker).");
            Utils.logException((Logger)logger, (Throwable)e);
        }
        return running;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("applicationName")) {
                this.__FapplicationName = true;
            }
            if (set.contains("containerName")) {
                this.__FcontainerName = true;
            }
            if (set.contains("eventName")) {
                this.__FeventName = true;
            }
            if (set.contains("scopedInstancePath")) {
                this.__FscopedInstancePath = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getName")) {
                this.__MgetName = true;
            }
            if (set.contains("setAgentId$java_lang_String$java_lang_String")) {
                this.__MsetAgentId$java_lang_String$java_lang_String = true;
            }
            if (set.contains("reset$net_roboconf_core_model_beans_Instance$java_lang_String$java_lang_String")) {
                this.__Mreset$net_roboconf_core_model_beans_Instance$java_lang_String$java_lang_String = true;
            }
            if (set.contains("process")) {
                this.__Mprocess = true;
            }
            if (set.contains("containerIsRunning$java_lang_String")) {
                this.__McontainerIsRunning$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

