/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public final class UriUtils {
    private UriUtils() {
    }

    public static URI urlToUri(URL url) throws URISyntaxException {
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (Exception e) {
            try {
                uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            }
            catch (Exception e1) {
                throw new URISyntaxException(String.valueOf(url), "Broken URL.");
            }
        }
        uri = uri.normalize();
        return uri;
    }

    public static URI urlToUri(String urlAsString) throws URISyntaxException {
        URL url;
        try {
            url = new URL(urlAsString);
        }
        catch (Exception e) {
            throw new URISyntaxException(urlAsString, "Invalid URL.");
        }
        return UriUtils.urlToUri(url);
    }

    public static URI buildNewURI(URI referenceUri, String uriSuffix) throws URISyntaxException {
        if (uriSuffix == null) {
            throw new IllegalArgumentException("The URI suffix cannot be null.");
        }
        uriSuffix = uriSuffix.replaceAll("\\\\", "/");
        URI importUri = null;
        try {
            importUri = UriUtils.urlToUri(new URL(uriSuffix));
        }
        catch (Exception e) {
            try {
                if (!referenceUri.toString().endsWith("/") && !uriSuffix.startsWith("/")) {
                    referenceUri = new URI(referenceUri.toString() + "/");
                }
                importUri = referenceUri.resolve(new URI(null, uriSuffix, null));
            }
            catch (Exception e2) {
                String msg = "An URI could not be built from the URI " + referenceUri.toString() + " and the suffix " + uriSuffix + ".";
                throw new URISyntaxException(msg, e2.getMessage());
            }
        }
        return importUri.normalize();
    }
}

