/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.utils.Utils;

public final class MavenUtils {
    private MavenUtils() {
    }

    public static String findMavenUrlForRoboconf(String artifactId, String version) throws IOException {
        return MavenUtils.findMavenUrl("net.roboconf", artifactId, version, "jar");
    }

    public static String findMavenUrl(String groupId, String artifactId, String version, String extension) throws IOException {
        Logger logger = Logger.getLogger(MavenUtils.class.getName());
        String result = null;
        File defaultRepo = new File(System.getProperty("user.home"), ".m2/repository");
        if (defaultRepo.exists()) {
            String fixedVersion = version.replaceAll("(?i)-snapshot", "-SNAPSHOT");
            StringBuilder sb = new StringBuilder();
            sb.append(groupId.replace('.', '/'));
            sb.append("/");
            sb.append(artifactId);
            sb.append("/");
            sb.append(fixedVersion);
            sb.append("/");
            sb.append(artifactId);
            sb.append("-");
            sb.append(fixedVersion);
            sb.append(".");
            sb.append(extension);
            File localFile = new File(defaultRepo, sb.toString());
            if (localFile.exists()) {
                result = localFile.toURI().toString();
            } else {
                logger.fine("Maven resolution: " + localFile + " does not exist (no local artifact).");
            }
        }
        if (result == null) {
            StringBuilder requestUrl = new StringBuilder();
            requestUrl.append("https://oss.sonatype.org/service/local/artifact/maven/resolve?r=");
            requestUrl.append(version.toLowerCase().endsWith("-snapshot") ? "snapshots" : "releases");
            requestUrl.append("&g=");
            requestUrl.append(groupId);
            requestUrl.append("&a=");
            requestUrl.append(artifactId);
            requestUrl.append("&v=");
            requestUrl.append(version);
            requestUrl.append("&p=");
            requestUrl.append(extension);
            logger.fine("Maven resolution: requesting the address from " + requestUrl);
            URL url = new URL(requestUrl.toString());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Utils.copyStreamSafely(url.openStream(), os);
            Pattern p = Pattern.compile("<repositoryPath>(.*)</repositoryPath>", 42);
            Matcher m = p.matcher(os.toString("UTF-8"));
            if (m.find()) {
                StringBuilder sb = new StringBuilder();
                sb.append("https://oss.sonatype.org/content/repositories/");
                sb.append(version.toLowerCase().endsWith("-snapshot") ? "snapshots/" : "releases/");
                sb.append(m.group(1));
                result = sb.toString();
            }
        }
        logger.fine("Maven resolution: the final artifact location is " + result);
        return result;
    }
}

