/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.helpers;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Import;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.helpers.VariableHelpers;
import net.roboconf.core.utils.Utils;

public final class ImportHelpers {
    private ImportHelpers() {
    }

    public static boolean hasAllRequiredImports(Instance instance, Logger logger) {
        boolean haveAllImports = true;
        for (String facetOrComponentName : VariableHelpers.findPrefixesForMandatoryImportedVariables(instance)) {
            Collection<Import> imports = instance.getImports().get(facetOrComponentName);
            if (imports != null && !imports.isEmpty()) continue;
            haveAllImports = false;
            if (logger == null) break;
            logger.fine(InstanceHelpers.computeInstancePath(instance) + " is still missing dependencies '" + facetOrComponentName + ".*'.");
            break;
        }
        return haveAllImports;
    }

    public static Import buildTailoredImport(Instance instanceThatUseTheImport, String exportingInstancePath, String exportingInstanceComponent, Map<String, String> exportedVariables) {
        Import imp = new Import(exportingInstancePath, exportingInstanceComponent);
        if (exportedVariables != null && !exportedVariables.isEmpty()) {
            Component comp = instanceThatUseTheImport.getComponent();
            for (ImportedVariable var : ComponentHelpers.findAllImportedVariables(comp).values()) {
                String importedVariable = var.getName();
                if (var.getName().endsWith(".*")) {
                    String prefix = VariableHelpers.parseVariableName(importedVariable).getKey();
                    for (Map.Entry<String, String> entry : exportedVariables.entrySet()) {
                        String exportedVarPrefix;
                        String exportedVariable = entry.getKey();
                        if (Utils.isEmptyOrWhitespaces(exportedVariable) || !prefix.equals(exportedVarPrefix = VariableHelpers.parseVariableName(exportedVariable).getKey())) continue;
                        imp.getExportedVars().put(entry.getKey(), entry.getValue());
                    }
                    continue;
                }
                if (!exportedVariables.containsKey(importedVariable)) continue;
                imp.getExportedVars().put(importedVariable, exportedVariables.get(importedVariable));
            }
        }
        return imp;
    }

    public static void addImport(Instance instance, String componentOrFacetName, Import imp) {
        Collection<Import> imports = instance.getImports().get(componentOrFacetName);
        if (imports == null) {
            imports = new LinkedHashSet<Import>();
            instance.getImports().put(componentOrFacetName, imports);
        }
        if (!imports.contains(imp)) {
            imports.add(imp);
        }
    }

    public static void updateImports(Instance instance, Map<String, Collection<Import>> variablePrefixToImports) {
        instance.getImports().clear();
        if (variablePrefixToImports != null) {
            instance.getImports().putAll(variablePrefixToImports);
        }
    }

    public static Import findImportByExportingInstance(Collection<Import> imports, String exportingInstancePath) {
        Import result = null;
        if (imports != null && exportingInstancePath != null) {
            for (Import imp : imports) {
                if (!exportingInstancePath.equals(imp.getInstancePath())) continue;
                result = imp;
                break;
            }
        }
        return result;
    }
}

