/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.AbstractType;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.ExportedVariable;
import net.roboconf.core.model.beans.Facet;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.comparators.AbstractTypeComparator;
import net.roboconf.core.model.helpers.VariableHelpers;

public final class ComponentHelpers {
    private ComponentHelpers() {
    }

    public static Component findComponent(Graphs graphs, String name) {
        Component result = null;
        Iterator<Component> it = ComponentHelpers.findAllComponents(graphs).iterator();
        while (it.hasNext() && result == null) {
            Component c = it.next();
            if (!name.equals(c.getName())) continue;
            result = c;
        }
        return result;
    }

    public static Component findComponent(AbstractApplication app, String name) {
        Graphs graphs = app.getGraphs();
        return ComponentHelpers.findComponent(graphs, name);
    }

    public static Component findComponentFrom(Component component, String componentName) {
        Graphs partialGraph = new Graphs();
        if (component != null) {
            partialGraph.getRootComponents().add(component);
        }
        return ComponentHelpers.findComponent(partialGraph, componentName);
    }

    public static List<String> extractNames(Collection<? extends AbstractType> types) {
        ArrayList<String> result = new ArrayList<String>();
        for (AbstractType abstractType : types) {
            result.add(abstractType.getName());
        }
        return result;
    }

    public static boolean isTarget(Component component) {
        return "target".equalsIgnoreCase(component.getInstallerName());
    }

    public static Collection<Component> findAllChildren(Component component) {
        return ComponentHelpers.findAncestorsOrChildren(component, true);
    }

    public static Collection<Component> findAllAncestors(Component component) {
        return ComponentHelpers.findAncestorsOrChildren(component, false);
    }

    public static String findComponentInstaller(Component component) {
        Component c;
        String installer = null;
        Iterator<Component> iterator = ComponentHelpers.findAllExtendedComponents(component).iterator();
        while (iterator.hasNext() && (installer = (c = iterator.next()).getInstallerName()) == null) {
        }
        return installer;
    }

    public static Map<String, String> findAllExportedVariables(Component component) {
        return ComponentHelpers.findAllExportedVariables(component, new HashSet<Component>(0));
    }

    public static Map<String, String> findAllExportedVariables(AbstractType type) {
        Map<String, String> result = type instanceof Facet ? ComponentHelpers.findAllExportedVariables((Facet)type) : ComponentHelpers.findAllExportedVariables((Component)type);
        return result;
    }

    public static Map<String, String> findAllExportedVariables(Graphs graphs) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Component c : ComponentHelpers.findAllComponents(graphs)) {
            result.putAll(ComponentHelpers.findAllExportedVariables(c));
        }
        return result;
    }

    public static Map<String, String> findAllExportedVariables(Facet facet) {
        HashMap<Facet, Boolean> facetToResolved = new HashMap<Facet, Boolean>();
        HashMap facetToResolvedExports = new HashMap();
        HashSet<Facet> facets = new HashSet<Facet>(ComponentHelpers.findAllExtendedFacets(facet));
        facets.add(facet);
        for (Facet f : facets) {
            facetToResolvedExports.put(f, new HashMap());
            facetToResolved.put(f, Boolean.FALSE);
        }
        while (facetToResolved.containsValue(Boolean.FALSE)) {
            block2: for (Facet f : facetToResolvedExports.keySet()) {
                if (((Boolean)facetToResolved.get(f)).booleanValue()) continue;
                if (ComponentHelpers.searchForInheritanceCycle(f) != null) {
                    facetToResolved.put(f, Boolean.TRUE);
                    continue;
                }
                HashMap localExportedVariables = new HashMap();
                for (Facet facet2 : f.getExtendedFacets()) {
                    if (!((Boolean)facetToResolved.get(facet2)).booleanValue()) continue block2;
                    localExportedVariables.putAll((Map)facetToResolvedExports.get(facet2));
                }
                for (Map.Entry entry : f.exportedVariables.entrySet()) {
                    String value = ((ExportedVariable)entry.getValue()).getValue();
                    if (localExportedVariables.containsKey(entry.getKey())) {
                        localExportedVariables.put(entry.getKey(), value);
                        continue;
                    }
                    localExportedVariables.put(ComponentHelpers.fixVariableName(f, (String)entry.getKey()), value);
                }
                facetToResolvedExports.put(f, localExportedVariables);
                facetToResolved.put(f, Boolean.TRUE);
            }
        }
        return (Map)facetToResolvedExports.get(facet);
    }

    public static Map<String, ImportedVariable> findAllImportedVariables(Component component) {
        HashMap<String, ImportedVariable> result = new HashMap<String, ImportedVariable>();
        List<Component> extendedComponents = ComponentHelpers.findAllExtendedComponents(component);
        Collections.reverse(extendedComponents);
        for (Component c : extendedComponents) {
            result.putAll(c.importedVariables);
        }
        return result;
    }

    public static Collection<Facet> findAllFacets(Component component) {
        HashSet<Facet> result = new HashSet<Facet>();
        ArrayList<Facet> toProcess = new ArrayList<Facet>();
        for (Component c : ComponentHelpers.findAllExtendedComponents(component)) {
            toProcess.addAll(c.getFacets());
        }
        while (!toProcess.isEmpty()) {
            Facet f = (Facet)toProcess.remove(0);
            result.add(f);
            toProcess.addAll(f.getExtendedFacets());
            toProcess.removeAll(result);
        }
        return result;
    }

    public static List<Component> findAllExtendedComponents(Component component) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (Component c = component; c != null && !result.contains(c); c = c.getExtendedComponent()) {
            result.add(c);
        }
        return result;
    }

    public static Collection<Facet> findAllExtendedFacets(Facet facet) {
        HashSet<Facet> result = new HashSet<Facet>();
        HashSet<Facet> toProcess = new HashSet<Facet>(facet.getExtendedFacets());
        while (!toProcess.isEmpty()) {
            Facet f = (Facet)toProcess.iterator().next();
            result.add(f);
            toProcess.addAll(f.getExtendedFacets());
            toProcess.removeAll(result);
        }
        return result;
    }

    public static Collection<Facet> findAllExtendingFacets(Facet facet) {
        HashSet<Facet> result = new HashSet<Facet>();
        HashSet<Facet> toProcess = new HashSet<Facet>(facet.getExtendingFacets());
        while (!toProcess.isEmpty()) {
            Facet f = (Facet)toProcess.iterator().next();
            result.add(f);
            toProcess.addAll(f.getExtendingFacets());
            toProcess.removeAll(result);
        }
        return result;
    }

    public static Collection<Component> findAllExtendingComponents(Component component) {
        HashSet<Component> result = new HashSet<Component>();
        HashSet<Component> toProcess = new HashSet<Component>(component.getExtendingComponents());
        while (!toProcess.isEmpty()) {
            Component c = (Component)toProcess.iterator().next();
            result.add(c);
            toProcess.addAll(c.getExtendingComponents());
            toProcess.removeAll(result);
        }
        result.remove(component);
        return result;
    }

    public static List<Component> findAllComponents(Graphs graphs) {
        HashSet<Component> result = new HashSet<Component>();
        HashSet<Component> toProcess = new HashSet<Component>();
        toProcess.addAll(graphs.getRootComponents());
        while (!toProcess.isEmpty()) {
            Component current = (Component)toProcess.iterator().next();
            result.add(current);
            toProcess.addAll(ComponentHelpers.findAllExtendedComponents(current));
            toProcess.addAll(ComponentHelpers.findAllExtendingComponents(current));
            toProcess.addAll(ComponentHelpers.findAllChildren(current));
            toProcess.addAll(ComponentHelpers.findAllAncestors(current));
            toProcess.removeAll(result);
        }
        return new ArrayList<Component>(result);
    }

    public static List<Component> findAllComponents(AbstractApplication app) {
        ArrayList<Component> result = new ArrayList<Component>();
        if (app.getGraphs() != null) {
            result.addAll(ComponentHelpers.findAllComponents(app.getGraphs()));
        }
        return result;
    }

    public static String searchForLoop(Component component) {
        return ComponentHelpers.searchForLoop(component, new ArrayList<Component>());
    }

    private static String searchForLoop(Component component, List<Component> ancestors) {
        String result = null;
        int index = ancestors.indexOf(component);
        if (index >= 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = index; i < ancestors.size(); ++i) {
                sb.append(ancestors.get(i).getName());
                sb.append(" -> ");
            }
            sb.append(component.getName());
            result = sb.toString();
        } else {
            ancestors.add(component);
            for (Component childComponent : ComponentHelpers.findAllChildren(component)) {
                ArrayList<Component> updatedAncestors;
                String s = ComponentHelpers.searchForLoop(childComponent, updatedAncestors = new ArrayList<Component>(ancestors));
                if (s == null) continue;
                result = s;
                break;
            }
        }
        return result;
    }

    public static String searchForInheritanceCycle(Facet facet) {
        String result = null;
        if (ComponentHelpers.findAllExtendedFacets(facet).contains(facet)) {
            result = facet + " -> ... -> " + facet;
        }
        return result;
    }

    public static String searchForInheritanceCycle(Component component) {
        String result = null;
        for (Component c = component.getExtendedComponent(); c != null && result == null; c = c.getExtendedComponent()) {
            if (!c.equals(component)) continue;
            result = component + " -> ... -> " + component;
        }
        return result;
    }

    public static Map<String, Boolean> findComponentDependenciesFor(Component component) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (ImportedVariable var : ComponentHelpers.findAllImportedVariables(component).values()) {
            String componentOrFacet = VariableHelpers.parseVariableName(var.getName()).getKey();
            Boolean b = (Boolean)map.get(componentOrFacet);
            if (b != null && !b.booleanValue()) continue;
            map.put(componentOrFacet, var.isOptional());
        }
        return map;
    }

    public static Map<Component, Boolean> findComponentDependenciesFor(Component component, ApplicationTemplate app) {
        Map<String, Boolean> map = ComponentHelpers.findComponentDependenciesFor(component);
        HashMap<Component, Boolean> result = new HashMap<Component, Boolean>();
        block0: for (Component c : ComponentHelpers.findAllComponents(app)) {
            Boolean required = map.get(c.getName());
            if (required != null) {
                result.put(c, required);
                continue;
            }
            for (Facet f : ComponentHelpers.findAllFacets(c)) {
                required = map.get(f.getName());
                if (required == null) continue;
                result.put(c, required);
                continue block0;
            }
        }
        return result;
    }

    public static Map<Component, Boolean> findComponentsThatDependOn(Component component, ApplicationTemplate app) {
        HashSet<String> prefixes = new HashSet<String>();
        prefixes.add(component.getName());
        for (Facet f : ComponentHelpers.findAllFacets(component)) {
            prefixes.add(f.getName());
        }
        HashMap<Component, Boolean> result = new HashMap<Component, Boolean>();
        for (Component c : ComponentHelpers.findAllComponents(app)) {
            Map<String, Boolean> map = ComponentHelpers.findComponentDependenciesFor(c);
            map.keySet().retainAll(prefixes);
            if (map.isEmpty()) continue;
            boolean value = true;
            for (Boolean b : map.values()) {
                value = value && b != false;
            }
            result.put(c, value);
        }
        return result;
    }

    static String fixVariableName(AbstractType type, String exportedVariableName) {
        String result = exportedVariableName;
        String prefix = type.getName() + ".";
        if (!result.startsWith(prefix)) {
            result = prefix + exportedVariableName;
        }
        return result;
    }

    private static Collection<Component> findAncestorsOrChildren(Component component, boolean children) {
        TreeSet<AbstractType> result = new TreeSet<AbstractType>(new AbstractTypeComparator());
        for (Component c : ComponentHelpers.findAllExtendedComponents(component)) {
            HashSet<AbstractType> list = new HashSet<AbstractType>();
            list.addAll(children ? c.getChildren() : c.getAncestors());
            for (Facet facet : ComponentHelpers.findAllFacets(c)) {
                list.addAll(children ? facet.getChildren() : facet.getAncestors());
            }
            for (AbstractType type : list) {
                if (type instanceof Component) {
                    Component cType = (Component)type;
                    result.add(cType);
                    result.addAll(ComponentHelpers.findAllExtendingComponents(cType));
                    continue;
                }
                Facet fType = (Facet)type;
                Collection<Facet> allFacets = ComponentHelpers.findAllExtendingFacets(fType);
                allFacets.add(fType);
                for (Facet facet : allFacets) {
                    for (Component cc : facet.getAssociatedComponents()) {
                        result.add(cc);
                        result.addAll(ComponentHelpers.findAllExtendingComponents(cc));
                    }
                }
            }
        }
        return result;
    }

    private static Map<String, String> findAllExportedVariables(Component component, Set<Component> alreadyChecked) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Facet f : component.getFacets()) {
            result.putAll(ComponentHelpers.findAllExportedVariables(f));
        }
        List<Component> extendedComponents = ComponentHelpers.findAllExtendedComponents(component);
        Collections.reverse(extendedComponents);
        extendedComponents.remove(component);
        extendedComponents.removeAll(alreadyChecked);
        HashSet<Component> ac = new HashSet<Component>(alreadyChecked);
        ac.add(component);
        for (Component c : extendedComponents) {
            result.putAll(ComponentHelpers.findAllExportedVariables(c, ac));
        }
        HashMap newVariables = new HashMap();
        for (Map.Entry entry : component.exportedVariables.entrySet()) {
            String variableValue = ((ExportedVariable)entry.getValue()).getValue();
            if (result.containsKey(entry.getKey())) {
                newVariables.put(entry.getKey(), variableValue);
            } else {
                newVariables.put(ComponentHelpers.fixVariableName(component, (String)entry.getKey()), variableValue);
            }
            for (String inheritedName : result.keySet()) {
                String nameSuffix = VariableHelpers.parseVariableName(inheritedName).getValue();
                if (!((String)entry.getKey()).equals(nameSuffix)) continue;
                newVariables.put(inheritedName, variableValue);
            }
        }
        result.putAll(newVariables);
        newVariables.clear();
        for (Map.Entry entry : result.entrySet()) {
            Map.Entry<String, String> var = VariableHelpers.parseVariableName((String)entry.getKey());
            String newKey = component.getName() + "." + var.getValue();
            if (component.getName().equals(var.getKey()) || result.containsKey(newKey)) continue;
            newVariables.put(newKey, (String)entry.getValue());
        }
        result.putAll(newVariables);
        return result;
    }
}

