/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.roboconf.core.Version;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.model.ApplicationTemplateDescriptor;
import net.roboconf.core.model.ModelError;
import net.roboconf.core.model.RecipesValidator;
import net.roboconf.core.model.TargetValidator;
import net.roboconf.core.model.beans.AbstractType;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.ExportedVariable;
import net.roboconf.core.model.beans.Facet;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.helpers.VariableHelpers;
import net.roboconf.core.utils.ResourceUtils;
import net.roboconf.core.utils.Utils;

public final class RuntimeModelValidator {
    private RuntimeModelValidator() {
    }

    public static Collection<ModelError> validate(Component component) {
        ArrayList<ModelError> errors = new ArrayList<ModelError>();
        if (Utils.isEmptyOrWhitespaces(component.getName())) {
            errors.add(new ModelError(ErrorCode.RM_EMPTY_COMPONENT_NAME, component));
        } else if (!component.getName().matches("[a-zA-Z_](\\w|-| |\\.)*")) {
            errors.add(new ModelError(ErrorCode.RM_INVALID_COMPONENT_NAME, component, ErrorDetails.component(component)));
        } else if (component.getName().contains(".")) {
            errors.add(new ModelError(ErrorCode.RM_DOT_IS_NOT_ALLOWED, component, ErrorDetails.component(component)));
        }
        String installerName = ComponentHelpers.findComponentInstaller(component);
        if (Utils.isEmptyOrWhitespaces(installerName)) {
            errors.add(new ModelError(ErrorCode.RM_EMPTY_COMPONENT_INSTALLER, component, ErrorDetails.component(component)));
        } else if (!installerName.matches("[a-zA-Z_](\\w|-| |\\.)*")) {
            errors.add(new ModelError(ErrorCode.RM_INVALID_COMPONENT_INSTALLER, component, ErrorDetails.component(component)));
        } else if (ComponentHelpers.findAllAncestors(component).isEmpty() && !"target".equals(installerName)) {
            errors.add(new ModelError(ErrorCode.RM_ROOT_INSTALLER_MUST_BE_TARGET, component, ErrorDetails.component(component)));
        }
        for (Object exportedVariable : component.exportedVariables.values()) {
            String exportedVarName = ((ExportedVariable)exportedVariable).getName();
            if (Utils.isEmptyOrWhitespaces(exportedVarName)) {
                errors.add(new ModelError(ErrorCode.RM_EMPTY_VARIABLE_NAME, component, ErrorDetails.variable(exportedVarName)));
            } else if (!exportedVarName.matches("[a-zA-Z_](\\w|-|\\.)*")) {
                errors.add(new ModelError(ErrorCode.RM_INVALID_VARIABLE_NAME, component, ErrorDetails.variable(exportedVarName)));
            }
            if (!((ExportedVariable)exportedVariable).isRandom()) continue;
            if (((ExportedVariable)exportedVariable).getRandomKind() == null) {
                errors.add(new ModelError(ErrorCode.RM_INVALID_RANDOM_KIND, component, ErrorDetails.unrecognized(((ExportedVariable)exportedVariable).getRawKind())));
            }
            if (((ExportedVariable)exportedVariable).getValue() == null) continue;
            errors.add(new ModelError(ErrorCode.RM_NO_VALUE_FOR_RANDOM, component, ErrorDetails.variable(exportedVarName)));
        }
        Map<String, String> allExportedVariables = ComponentHelpers.findAllExportedVariables(component);
        for (ImportedVariable var : ComponentHelpers.findAllImportedVariables(component).values()) {
            String varName = var.getName();
            String patternForImports = "[a-zA-Z_](\\w|-|\\.)*";
            patternForImports = patternForImports + "(\\.\\*)?";
            if (Utils.isEmptyOrWhitespaces(varName)) {
                errors.add(new ModelError(ErrorCode.RM_EMPTY_VARIABLE_NAME, component, ErrorDetails.variable(varName)));
            } else if (!varName.matches(patternForImports)) {
                errors.add(new ModelError(ErrorCode.RM_INVALID_VARIABLE_NAME, component, ErrorDetails.variable(varName)));
            }
            if (var.isOptional() || !allExportedVariables.containsKey(varName)) continue;
            errors.add(new ModelError(ErrorCode.RM_COMPONENT_IMPORTS_EXPORTS, component, ErrorDetails.variable(varName)));
        }
        String cycle = ComponentHelpers.searchForInheritanceCycle(component);
        if (cycle != null) {
            errors.add(new ModelError(ErrorCode.RM_CYCLE_IN_COMPONENTS_INHERITANCE, component, ErrorDetails.cycle(cycle)));
        }
        if ((cycle = ComponentHelpers.searchForLoop(component)) != null && cycle.startsWith(component.getName())) {
            errors.add(new ModelError(ErrorCode.RM_CYCLE_IN_COMPONENTS, component, ErrorDetails.cycle(cycle)));
        }
        return errors;
    }

    public static Collection<ModelError> validate(Facet facet) {
        ArrayList<ModelError> result = new ArrayList<ModelError>();
        if (Utils.isEmptyOrWhitespaces(facet.getName())) {
            result.add(new ModelError(ErrorCode.RM_EMPTY_FACET_NAME, facet));
        } else if (!facet.getName().matches("[a-zA-Z_](\\w|-| |\\.)*")) {
            result.add(new ModelError(ErrorCode.RM_INVALID_FACET_NAME, facet, ErrorDetails.facet(facet)));
        } else if (facet.getName().contains(".")) {
            result.add(new ModelError(ErrorCode.RM_DOT_IS_NOT_ALLOWED, facet, ErrorDetails.facet(facet)));
        }
        for (String exportedVarName : facet.exportedVariables.keySet()) {
            if (Utils.isEmptyOrWhitespaces(exportedVarName)) {
                result.add(new ModelError(ErrorCode.RM_EMPTY_VARIABLE_NAME, facet, ErrorDetails.variable(exportedVarName)));
                continue;
            }
            if (exportedVarName.matches("[a-zA-Z_](\\w|-|\\.)*")) continue;
            result.add(new ModelError(ErrorCode.RM_INVALID_VARIABLE_NAME, facet, ErrorDetails.variable(exportedVarName)));
        }
        String cycle = ComponentHelpers.searchForInheritanceCycle(facet);
        if (cycle != null) {
            result.add(new ModelError(ErrorCode.RM_CYCLE_IN_FACETS_INHERITANCE, facet, ErrorDetails.cycle(cycle)));
        }
        return result;
    }

    public static Collection<ModelError> validate(Graphs graphs, File projectDirectory) {
        ArrayList<ModelError> result = new ArrayList<ModelError>();
        for (Component c : ComponentHelpers.findAllComponents(graphs)) {
            File componentDirectory = ResourceUtils.findInstanceResourcesDirectory(projectDirectory, c);
            if (!componentDirectory.exists()) {
                ModelError error = new ModelError(ErrorCode.PROJ_NO_RESOURCE_DIRECTORY, c, ErrorDetails.component(c));
                result.add(error);
                continue;
            }
            if (ComponentHelpers.isTarget(c)) {
                result.addAll(TargetValidator.parseTargetProperties(projectDirectory, c));
                continue;
            }
            result.addAll(RecipesValidator.validateComponentRecipes(projectDirectory, c));
        }
        return result;
    }

    public static Collection<ModelError> validate(Graphs graphs) {
        ArrayList<ModelError> errors = new ArrayList<ModelError>();
        if (graphs.getRootComponents().isEmpty()) {
            errors.add(new ModelError(ErrorCode.RM_NO_ROOT_COMPONENT, graphs));
        }
        for (Component rootComponent : graphs.getRootComponents()) {
            if (ComponentHelpers.findAllAncestors(rootComponent).isEmpty()) continue;
            errors.add(new ModelError(ErrorCode.RM_NOT_A_ROOT_COMPONENT, rootComponent, ErrorDetails.component(rootComponent)));
        }
        HashMap<String, Boolean> importedVariableNameToExported = new HashMap<String, Boolean>();
        HashMap<String, ArrayList<Component>> importedVariableToImporters = new HashMap<String, ArrayList<Component>>();
        for (Component component : ComponentHelpers.findAllComponents(graphs)) {
            errors.addAll(RuntimeModelValidator.validate(component));
            for (Facet facet : ComponentHelpers.findAllFacets(component)) {
                errors.addAll(RuntimeModelValidator.validate(facet));
            }
            for (ImportedVariable var : ComponentHelpers.findAllImportedVariables(component).values()) {
                ArrayList<Component> importers;
                if (var.isExternal()) continue;
                String importedVariableName = var.getName();
                if (!importedVariableNameToExported.containsKey(importedVariableName)) {
                    importedVariableNameToExported.put(importedVariableName, Boolean.FALSE);
                }
                if ((importers = (ArrayList<Component>)importedVariableToImporters.get(importedVariableName)) == null) {
                    importers = new ArrayList<Component>();
                }
                importers.add(component);
                importedVariableToImporters.put(importedVariableName, importers);
            }
            for (String exportedVariableName : ComponentHelpers.findAllExportedVariables(component).keySet()) {
                importedVariableNameToExported.put(exportedVariableName, Boolean.TRUE);
                String prefix = VariableHelpers.parseVariableName(exportedVariableName).getKey();
                importedVariableNameToExported.put((String)prefix + "." + "*", Boolean.TRUE);
            }
        }
        HashSet<Object> facetVariables = new HashSet<Object>();
        for (Facet facet : graphs.getFacetNameToFacet().values()) {
            facetVariables.addAll(facet.exportedVariables.keySet());
            facetVariables.add(facet.getName() + "." + "*");
        }
        for (Map.Entry entry : importedVariableNameToExported.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            ErrorCode errorCode = ErrorCode.RM_UNRESOLVABLE_VARIABLE;
            if (facetVariables.contains(entry.getKey())) {
                errorCode = ErrorCode.RM_UNRESOLVABLE_FACET_VARIABLE;
            }
            for (Component component : (List)importedVariableToImporters.get(entry.getKey())) {
                errors.add(new ModelError(errorCode, component, ErrorDetails.variable((String)entry.getKey())));
            }
        }
        for (Facet facet : graphs.getFacetNameToFacet().values()) {
            if (!facet.getAssociatedComponents().isEmpty()) continue;
            if (facet.getChildren().isEmpty()) {
                errors.add(new ModelError(ErrorCode.RM_ORPHAN_FACET, facet, ErrorDetails.facet(facet)));
            } else {
                errors.add(new ModelError(ErrorCode.RM_ORPHAN_FACET_WITH_CHILDREN, facet, ErrorDetails.facet(facet)));
            }
            for (AbstractType t : facet.getChildren()) {
                if (!(t instanceof Component)) continue;
                errors.add(new ModelError(ErrorCode.RM_UNREACHABLE_COMPONENT, t, ErrorDetails.component(t.getName())));
            }
        }
        return errors;
    }

    public static Collection<ModelError> validate(Instance instance) {
        ArrayList<ModelError> errors = new ArrayList<ModelError>();
        if (Utils.isEmptyOrWhitespaces(instance.getName())) {
            errors.add(new ModelError(ErrorCode.RM_EMPTY_INSTANCE_NAME, instance));
        } else if (!instance.getName().matches("[a-zA-Z_](\\w|-| |\\.)*")) {
            errors.add(new ModelError(ErrorCode.RM_INVALID_INSTANCE_NAME, instance, ErrorDetails.instance(instance)));
        }
        if (instance.getComponent() == null) {
            errors.add(new ModelError(ErrorCode.RM_EMPTY_INSTANCE_COMPONENT, instance));
        }
        if (instance.getComponent() != null) {
            ErrorCode errorCode = null;
            Collection<Component> ancestors = ComponentHelpers.findAllAncestors(instance.getComponent());
            if (instance.getParent() == null && !ancestors.isEmpty()) {
                errorCode = ErrorCode.RM_MISSING_INSTANCE_PARENT;
            } else if (!(instance.getParent() == null || ancestors.contains(instance.getParent().getComponent()) && ComponentHelpers.findAllChildren(instance.getParent().getComponent()).contains(instance.getComponent()))) {
                errorCode = ErrorCode.RM_INVALID_INSTANCE_PARENT;
            }
            if (errorCode != null) {
                ArrayList<ErrorDetails> details = new ArrayList<ErrorDetails>();
                for (Component component : ancestors) {
                    details.add(ErrorDetails.expected(component.getName()));
                }
                errors.add(new ModelError(errorCode, instance, details.toArray(new ErrorDetails[details.size()])));
            }
        }
        HashMap<String, HashSet<String>> localNameToFullNames = new HashMap<String, HashSet<String>>();
        Set<String> inheritedVarNames = instance.getComponent() != null ? ComponentHelpers.findAllExportedVariables(instance.getComponent()).keySet() : new HashSet<String>(0);
        for (String string : inheritedVarNames) {
            String localName = VariableHelpers.parseVariableName(string).getValue();
            HashSet<String> fullNames = (HashSet<String>)localNameToFullNames.get(localName);
            if (fullNames == null) {
                fullNames = new HashSet<String>();
            }
            fullNames.add(string);
            localNameToFullNames.put(localName, fullNames);
        }
        for (Map.Entry entry : instance.overriddenExports.entrySet()) {
            if (inheritedVarNames.contains(entry.getKey())) continue;
            Set fullNames = (Set)localNameToFullNames.get(entry.getKey());
            if (fullNames == null) {
                errors.add(new ModelError(ErrorCode.RM_MAGIC_INSTANCE_VARIABLE, instance, ErrorDetails.variable((String)entry.getKey())));
                continue;
            }
            if (fullNames.size() <= 1) continue;
            ArrayList<ErrorDetails> details = new ArrayList<ErrorDetails>();
            details.add(ErrorDetails.variable((String)entry.getKey()));
            for (String string : fullNames) {
                details.add(ErrorDetails.conflicting(string));
            }
            errors.add(new ModelError(ErrorCode.RM_AMBIGUOUS_OVERRIDING, instance, details.toArray(new ErrorDetails[details.size()])));
        }
        RuntimeModelValidator.randomVariablesTrickForValidation(instance, true);
        for (Map.Entry entry : InstanceHelpers.findAllExportedVariables(instance).entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!Utils.isEmptyOrWhitespaces(value) || "ip".equalsIgnoreCase(name) || name.toLowerCase().endsWith(".ip")) continue;
            errors.add(new ModelError(ErrorCode.RM_MISSING_VARIABLE_VALUE, instance, ErrorDetails.variable(name)));
        }
        RuntimeModelValidator.randomVariablesTrickForValidation(instance, false);
        return errors;
    }

    public static Collection<ModelError> validate(Collection<Instance> instances) {
        ArrayList<ModelError> errors = new ArrayList<ModelError>();
        for (Instance i : instances) {
            errors.addAll(RuntimeModelValidator.validate(i));
        }
        return errors;
    }

    public static Collection<ModelError> validate(ApplicationTemplate app) {
        Map<String, String> allExports;
        ArrayList<ModelError> errors = new ArrayList<ModelError>();
        if (Utils.isEmptyOrWhitespaces(app.getName())) {
            errors.add(new ModelError(ErrorCode.RM_MISSING_APPLICATION_NAME, app));
        } else if (!app.getName().matches("[a-zA-Z_](\\w|[-.() ])*")) {
            errors.add(new ModelError(ErrorCode.RM_INVALID_APPLICATION_NAME, app));
        }
        if (Utils.isEmptyOrWhitespaces(app.getVersion())) {
            errors.add(new ModelError(ErrorCode.RM_MISSING_APPLICATION_VERSION, app));
        } else if (Version.parseVersion(app.getVersion()) == null) {
            errors.add(new ModelError(ErrorCode.RM_INVALID_APPLICATION_VERSION, app, ErrorDetails.unexpected(app.getVersion())));
        }
        if (app.getGraphs() == null) {
            errors.add(new ModelError(ErrorCode.RM_MISSING_APPLICATION_GRAPHS, app));
            allExports = new HashMap<String, String>(0);
        } else {
            errors.addAll(RuntimeModelValidator.validate(app.getGraphs()));
            allExports = ComponentHelpers.findAllExportedVariables(app.getGraphs());
        }
        if (!app.externalExports.isEmpty()) {
            if (Utils.isEmptyOrWhitespaces(app.getExternalExportsPrefix())) {
                errors.add(new ModelError(ErrorCode.RM_MISSING_APPLICATION_EXPORT_PREFIX, app));
            } else if (!app.getExternalExportsPrefix().matches("[a-zA-Z_](\\w|-|\\.)*")) {
                errors.add(new ModelError(ErrorCode.RM_INVALID_APPLICATION_EXPORT_PREFIX, app));
            }
        }
        HashSet<String> alreadySeen = new HashSet<String>();
        for (Map.Entry<String, String> entry : app.externalExports.entrySet()) {
            if (!entry.getKey().matches("[a-zA-Z_](\\w|-|\\.)*")) {
                errors.add(new ModelError(ErrorCode.RM_INVALID_VARIABLE_NAME, app, ErrorDetails.variable(entry.getKey())));
            }
            if (!allExports.containsKey(entry.getKey())) {
                errors.add(new ModelError(ErrorCode.RM_INVALID_EXTERNAL_EXPORT, app, ErrorDetails.variable(entry.getKey())));
            }
            if (!entry.getValue().matches("[a-zA-Z_](\\w|-|\\.)*")) {
                errors.add(new ModelError(ErrorCode.RM_INVALID_VARIABLE_NAME, app, ErrorDetails.variable(entry.getValue())));
            }
            if (alreadySeen.contains(entry.getValue())) {
                errors.add(new ModelError(ErrorCode.RM_ALREADY_DEFINED_EXTERNAL_EXPORT, app, ErrorDetails.variable(entry.getValue())));
                continue;
            }
            alreadySeen.add(entry.getValue());
        }
        errors.addAll(RuntimeModelValidator.validate(InstanceHelpers.getAllInstances(app)));
        return errors;
    }

    public static Collection<ModelError> validate(ApplicationTemplateDescriptor descriptor) {
        ArrayList<ModelError> errors = new ArrayList<ModelError>();
        if (Utils.isEmptyOrWhitespaces(descriptor.getName())) {
            errors.add(new ModelError(ErrorCode.RM_MISSING_APPLICATION_NAME, "name"));
        } else if (!Utils.cleanNameWithAccents(descriptor.getName()).matches("[a-zA-Z_](\\w|[-.() ])*")) {
            errors.add(new ModelError(ErrorCode.RM_INVALID_APPLICATION_NAME, "name", ErrorDetails.expected("[a-zA-Z_](\\w|[-.() ])*")));
        }
        if (Utils.isEmptyOrWhitespaces(descriptor.getVersion())) {
            errors.add(new ModelError(ErrorCode.RM_MISSING_APPLICATION_VERSION, "version"));
        } else if (Version.parseVersion(descriptor.getVersion()) == null) {
            errors.add(new ModelError(ErrorCode.RM_INVALID_APPLICATION_VERSION, "version", ErrorDetails.unexpected(descriptor.getVersion())));
        }
        if (Utils.isEmptyOrWhitespaces(descriptor.getDslId())) {
            errors.add(new ModelError(ErrorCode.RM_MISSING_APPLICATION_DSL_ID, "dsl-id"));
        }
        if (Utils.isEmptyOrWhitespaces(descriptor.getGraphEntryPoint())) {
            errors.add(new ModelError(ErrorCode.RM_MISSING_APPLICATION_GEP, "graph-entry-point"));
        }
        if (!descriptor.invalidExternalExports.isEmpty()) {
            errors.add(new ModelError(ErrorCode.PROJ_INVALID_EXTERNAL_EXPORTS, "exports-prefix"));
        }
        for (Map.Entry<String, String> entry : descriptor.externalExports.entrySet()) {
            if (!entry.getKey().matches("[a-zA-Z_](\\w|-|\\.)*")) {
                errors.add(new ModelError(ErrorCode.RM_INVALID_VARIABLE_NAME, "exports-prefix", ErrorDetails.variable(entry.getKey())));
            }
            if (entry.getValue().matches("[a-zA-Z_](\\w|-|\\.)*")) continue;
            errors.add(new ModelError(ErrorCode.RM_INVALID_VARIABLE_NAME, "exports-prefix", ErrorDetails.variable(entry.getValue())));
        }
        if (!(descriptor.externalExports.isEmpty() && descriptor.invalidExternalExports.isEmpty() || !Utils.isEmptyOrWhitespaces(descriptor.getExternalExportsPrefix()))) {
            errors.add(new ModelError(ErrorCode.RM_MISSING_APPLICATION_EXPORT_PREFIX, descriptor));
        }
        return errors;
    }

    private static void randomVariablesTrickForValidation(Instance instance, boolean set) {
        String trickValue = "@# --- #@";
        Map exportedVariables = instance.getComponent() != null ? instance.getComponent().exportedVariables : new HashMap(0);
        for (ExportedVariable var : exportedVariables.values()) {
            if (!var.isRandom()) continue;
            String overriddenExport = instance.overriddenExports.get(var.getName());
            if (set && overriddenExport == null) {
                instance.overriddenExports.put(var.getName(), "@# --- #@");
                continue;
            }
            if (set || !Objects.equals("@# --- #@", overriddenExport)) continue;
            instance.overriddenExports.remove(var.getName());
        }
    }
}

