/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.model.ModelError;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.VariableHelpers;
import net.roboconf.core.utils.ProgramUtils;
import net.roboconf.core.utils.ResourceUtils;
import net.roboconf.core.utils.Utils;

public final class RecipesValidator {
    public static final String SCRIPTS_DIR_NAME = "scripts";

    private RecipesValidator() {
    }

    public static List<ModelError> validateComponentRecipes(File applicationFilesDirectory, Component component) {
        List<ModelError> result = "puppet".equalsIgnoreCase(component.getInstallerName()) ? RecipesValidator.validatePuppetComponent(applicationFilesDirectory, component) : ("script".equalsIgnoreCase(component.getInstallerName()) ? RecipesValidator.validateScriptComponent(applicationFilesDirectory, component) : Collections.emptyList());
        return result;
    }

    private static List<ModelError> validateScriptComponent(File applicationFilesDirectory, Component component) {
        File scriptsDir;
        ArrayList<ModelError> result = new ArrayList<ModelError>();
        File directory = ResourceUtils.findInstanceResourcesDirectory(applicationFilesDirectory, component);
        List<File> subDirs = Utils.listAllFiles(directory);
        if (!subDirs.isEmpty() && !(scriptsDir = new File(directory, SCRIPTS_DIR_NAME)).exists()) {
            result.add(new ModelError(ErrorCode.REC_SCRIPT_NO_SCRIPTS_DIR, component, ErrorDetails.component(component)));
        }
        return result;
    }

    private static List<ModelError> validatePuppetComponent(File applicationFilesDirectory, Component component) {
        File directory;
        File[] children;
        ArrayList<ModelError> result = new ArrayList<ModelError>();
        for (ImportedVariable var : ComponentHelpers.findAllImportedVariables(component).values()) {
            if (!var.getName().endsWith(".*")) continue;
            result.add(new ModelError(ErrorCode.REC_PUPPET_DISLIKES_WILDCARD_IMPORTS, component, ErrorDetails.component(component)));
            break;
        }
        children = (children = (directory = ResourceUtils.findInstanceResourcesDirectory(applicationFilesDirectory, component)).listFiles()) == null ? new File[]{} : children;
        ArrayList<File> modules = new ArrayList<File>();
        for (File f : children) {
            if (!f.isDirectory() || !f.getName().toLowerCase().startsWith("roboconf_")) continue;
            modules.add(f);
        }
        if (modules.isEmpty()) {
            result.add(new ModelError(ErrorCode.REC_PUPPET_HAS_NO_RBCF_MODULE, component, ErrorDetails.component(component)));
        } else if (modules.size() > 1) {
            result.add(new ModelError(ErrorCode.REC_PUPPET_HAS_TOO_MANY_RBCF_MODULES, component, ErrorDetails.component(component)));
        }
        if (modules.size() == 1) {
            File pp1 = new File((File)modules.get(0), "manifests/update.pp");
            File pp2 = new File((File)modules.get(0), "manifests/init.pp");
            File withUpdateParams = pp1.exists() ? pp1 : pp2;
            children = new File((File)modules.get(0), "manifests").listFiles();
            for (File f : children = children == null ? new File[]{} : children) {
                try {
                    if (!f.isFile() || !f.getName().toLowerCase().endsWith(".pp")) continue;
                    RecipesValidator.checkPuppetFile(f, f.equals(withUpdateParams), component, result);
                }
                catch (IOException e) {
                    Logger logger = Logger.getLogger(RecipesValidator.class.getName());
                    logger.warning("The content of the Puppet file '" + f + "' could not be read.");
                    Utils.logException(logger, e);
                }
            }
        }
        return result;
    }

    private static void checkPuppetFile(File pp, boolean withUpdateParams, Component component, Collection<ModelError> errors) throws IOException {
        String[] cmd = new String[]{"puppet", "parser", "validate", pp.getAbsolutePath()};
        Logger logger = Logger.getLogger(RecipesValidator.class.getName());
        try {
            int execCode = ProgramUtils.executeCommand(logger, cmd, null, null, null, null);
            if (execCode != 0) {
                errors.add(new ModelError(ErrorCode.REC_PUPPET_SYNTAX_ERROR, component, ErrorDetails.component(component), ErrorDetails.file(pp)));
            }
        }
        catch (Exception e) {
            logger.info("Puppet parser is not available on the machine.");
        }
        Pattern pattern = Pattern.compile("class [^(]+\\(([^)]+)\\)", 42);
        String content = Utils.readFileContent(pp);
        Matcher m = pattern.matcher(content);
        HashSet<String> params = new HashSet<String>();
        if (!m.find()) {
            return;
        }
        for (String s : m.group(1).split(",")) {
            Map.Entry<String, String> entry = VariableHelpers.parseExportedVariable(s.trim());
            params.add(entry.getKey());
        }
        if (withUpdateParams && !params.remove("$importDiff")) {
            errors.add(new ModelError(ErrorCode.REC_PUPPET_MISSING_PARAM_IMPORT_DIFF, component, ErrorDetails.component(component), ErrorDetails.file(pp)));
        }
        params.remove("$importDiff");
        if (!params.remove("$runningState")) {
            errors.add(new ModelError(ErrorCode.REC_PUPPET_MISSING_PARAM_RUNNING_STATE, component, ErrorDetails.component(component), ErrorDetails.file(pp)));
        }
        Instance fake = new Instance("fake").component(component);
        for (String facetOrComponentName : VariableHelpers.findPrefixesForImportedVariables(fake)) {
            if (params.remove("$" + facetOrComponentName.toLowerCase())) continue;
            ErrorDetails[] details = new ErrorDetails[]{ErrorDetails.name(component.getName()), ErrorDetails.file(pp), ErrorDetails.expected(facetOrComponentName.toLowerCase())};
            errors.add(new ModelError(ErrorCode.REC_PUPPET_MISSING_PARAM_FROM_IMPORT, component, details));
        }
    }
}

