/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.errors.RoboconfError;

public class ParsingError
extends RoboconfError {
    private final int line;
    private final File file;

    public ParsingError(ErrorCode errorCode, File file, int line) {
        this(errorCode, file, line, new ErrorDetails[0]);
    }

    public ParsingError(ErrorCode errorCode, File file, int line, ErrorDetails ... details) {
        super(errorCode, ParsingError.addLineAndFile(line, file, details));
        this.line = line;
        this.file = file;
    }

    public int getLine() {
        return this.line;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.line, ((ParsingError)obj).line) && Objects.equals(this.file, ((ParsingError)obj).file);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private static ErrorDetails[] addLineAndFile(int line, File file, ErrorDetails ... details) {
        LinkedHashSet<ErrorDetails> updatedDetails = new LinkedHashSet<ErrorDetails>();
        if (details != null) {
            updatedDetails.addAll(Arrays.asList(details));
        }
        if (file != null) {
            updatedDetails.add(ErrorDetails.file(file));
            updatedDetails.add(ErrorDetails.line(line));
        }
        return updatedDetails.toArray(new ErrorDetails[updatedDetails.size()]);
    }
}

