/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.commands.Context;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.beans.AbstractApplication;

public abstract class AbstractCommandInstruction {
    private static final Pattern VAR_PATTERN = Pattern.compile("(\\$\\([^)]*\\))");
    protected final String instruction;
    protected final Context context;
    protected final int line;
    protected boolean syntaxicallyCorrect = false;
    protected boolean disabled = false;

    public AbstractCommandInstruction(Context context, String instruction, int line) {
        this.instruction = instruction;
        this.context = context;
        this.line = line;
    }

    public final List<ParsingError> validate() {
        ArrayList<ParsingError> errors = new ArrayList<ParsingError>();
        if (!this.syntaxicallyCorrect) {
            errors.add(this.error(ErrorCode.CMD_INVALID_SYNTAX, ErrorDetails.instruction(this.instruction)));
        }
        Matcher m = VAR_PATTERN.matcher(this.instruction);
        while (m.find()) {
            boolean found = false;
            String varName = m.group(1);
            for (String variablePattern : this.getVariablesToIgnore()) {
                if (!varName.matches(variablePattern)) continue;
                found = true;
                break;
            }
            if (found) continue;
            errors.add(this.error(ErrorCode.CMD_UNRESOLVED_VARIABLE, ErrorDetails.variable(varName)));
        }
        if (errors.isEmpty()) {
            errors.addAll(this.doValidate());
        }
        return errors;
    }

    public AbstractApplication getApplication() {
        return this.context.getApp();
    }

    protected abstract List<ParsingError> doValidate();

    protected List<String> getVariablesToIgnore() {
        return Collections.emptyList();
    }

    public void updateContext() {
    }

    protected ParsingError error(ErrorCode errorCode, ErrorDetails ... details) {
        return new ParsingError(errorCode, this.context.getCommandFile(), this.line, details);
    }

    protected ParsingError error(ErrorCode errorCode) {
        return this.error(errorCode, null);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }
}

