/*
 * Decompiled with CFR 0.152.
 */
package com4j.tlbimp.driver;

import com4j.tlbimp.BindingException;
import com4j.tlbimp.CodeWriter;
import com4j.tlbimp.ErrorListener;
import com4j.tlbimp.FileCodeWriter;
import com4j.tlbimp.def.IWTypeLib;
import com4j.tlbimp.driver.Driver;
import com4j.tlbimp.driver.Lib;
import com4j.tlbimp.driver.LibConfig;
import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class Com4jgenMojo
extends AbstractMojo
implements ErrorListener {
    private MavenProject project;
    public File outputDirectory;
    private ArrayList<LibConfig> libraries = new ArrayList();

    public void execute() throws MojoExecutionException {
        for (LibConfig libConfig : this.libraries) {
            this.getLog().debug((CharSequence)("Starting Com4jMojo for: " + libConfig.file));
        }
        this.checkEnv();
        this.validate();
        Driver driver = new Driver();
        for (LibConfig l : this.libraries) {
            Lib lib = new Lib();
            if (l.libId != null) {
                lib.setLibid(l.libId);
                if (l.libVer != null) {
                    lib.setLibver(l.libVer);
                }
            } else {
                lib.setFile(l.file);
            }
            lib.setPackage(l._package);
            try {
                lib.validate();
                this.getLog().info((CharSequence)("Generating COM for LIBID: " + lib.getLibid() + " found here: " + lib.getFile()));
                driver.addLib(lib);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Com4j had an error while adding library: \n" + e.getMessage() + "\n\tLIBID: " + l.libId + " at " + l.file));
                throw new MojoExecutionException(e.getMessage());
            }
        }
        try {
            driver.run((CodeWriter)new FileCodeWriter(this.outputDirectory), (ErrorListener)this);
        }
        catch (NullPointerException nullPointerException) {
            this.getLog().warn((CharSequence)"Com4j had an NPE error while running. This usually happens when it can't create an interface. You many need to manually touch the files before trying to compile them.");
        }
        catch (Exception exception) {
            this.getLog().warn((CharSequence)("Com4j had an error while running: \n" + exception.getMessage()));
            throw new MojoExecutionException(exception.getMessage());
        }
        this.getLog().debug((CharSequence)"adding generated files to Maven compile source");
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        for (LibConfig l : this.libraries) {
            this.getLog().debug((CharSequence)("Finished Com4jMojo for: " + l.file));
        }
    }

    private void checkEnv() throws MojoExecutionException {
        String osName = System.getProperty("os.name");
        if (!osName.startsWith("Windows")) {
            this.getLog().warn((CharSequence)("Wrong OS: " + osName));
            throw new MojoExecutionException("Com4j can only be run on a Windows operating system, and you're running: " + osName);
        }
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            this.getLog().warn((CharSequence)"outputDirectory couldn't be created");
            throw new MojoExecutionException("The output directory " + this.outputDirectory + " doesn't exist and couldn't be created.");
        }
    }

    private void validate() throws MojoExecutionException {
        for (LibConfig l : this.libraries) {
            StringBuilder sb = new StringBuilder();
            sb.append("You specified <file> and <libId>.  The <libId> always wins. ");
            sb.append("\n\t<file>").append(l.file).append("</file>");
            sb.append("\n\t<libId>").append(l.libId).append("</libId>");
            if (l.file == null && l.libId == null || l.file != null && l.libId != null) {
                this.getLog().warn((CharSequence)sb.toString());
            }
            if (l.file == null || l.file.exists()) continue;
            this.getLog().warn((CharSequence)("Can't find file: " + l.file));
            throw new MojoExecutionException("The native COM target file couldn't be found: " + l.file);
        }
    }

    public void started(IWTypeLib lib) {
        this.getLog().info((CharSequence)("Generating definitions from " + lib.getName()));
    }

    public void error(BindingException e) {
        this.getLog().error((CharSequence)e.getMessage());
    }

    public void warning(String message) {
        this.getLog().warn((CharSequence)message);
    }
}

