/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.impsort;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.revelc.code.impsort.Import;

public class Result {
    private Boolean isSorted;
    private final Path path;
    private final Charset sourceEncoding;
    private final String originalSection;
    private final String newSection;
    private final Collection<Import> allImports;
    private final List<String> fileLines;
    private final int start;
    private final int stop;

    Result(Path path, Charset sourceEncoding, List<String> fileLines, int start, int stop, String originalSection, String newSection, Collection<Import> allImports) {
        this.path = path;
        this.sourceEncoding = sourceEncoding;
        this.originalSection = originalSection;
        this.newSection = newSection;
        this.allImports = allImports;
        this.fileLines = fileLines;
        this.start = start;
        this.stop = stop;
    }

    public boolean isSorted() {
        if (this.isSorted == null) {
            this.isSorted = this.originalSection.contentEquals(this.newSection);
        }
        return this.isSorted;
    }

    public Collection<Import> getImports() {
        return this.allImports;
    }

    public void saveBackup(Path destination) throws IOException {
        Files.copy(this.path, destination, StandardCopyOption.REPLACE_EXISTING);
    }

    public void saveSorted(Path destination) throws IOException {
        if (this.isSorted()) {
            if (!Files.isSameFile(this.path, destination)) {
                this.saveBackup(destination);
            }
            return;
        }
        List<String> beforeImports = this.fileLines.subList(0, this.start);
        List<String> importLines = Arrays.asList(this.newSection.split("\\n"));
        List<String> afterImports = this.fileLines.subList(this.stop, this.fileLines.size());
        ArrayList<String> allLines = new ArrayList<String>(beforeImports.size() + importLines.size() + afterImports.size() + 1);
        allLines.addAll(beforeImports);
        allLines.addAll(importLines);
        if (afterImports.size() > 0) {
            allLines.add("");
        }
        allLines.addAll(afterImports);
        Files.write(destination, allLines, this.sourceEncoding, new OpenOption[0]);
    }
}

