/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.impsort;

import java.util.Objects;

public class Import {
    private final boolean isStatic;
    private final String imp;
    private final String prefix;
    private final String suffix;

    Import(boolean isStatic, String imp, String prefix, String suffix) {
        this.isStatic = isStatic;
        this.imp = Objects.requireNonNull(imp);
        this.prefix = Objects.requireNonNull(prefix);
        this.suffix = Objects.requireNonNull(suffix);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getImport() {
        return this.imp;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String toString() {
        return this.prefix + (this.prefix.isEmpty() ? "" : "\n") + "import" + (this.isStatic() ? " static" : "") + " " + this.getImport() + ";" + this.suffix;
    }

    public int hashCode() {
        return this.getImport().hashCode() * 2 + (this.isStatic ? 1 : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Import) {
            Import o2 = (Import)obj;
            return this.isStatic == o2.isStatic && this.imp.contentEquals(o2.imp) && this.prefix.contentEquals(o2.prefix) && this.suffix.contentEquals(o2.suffix);
        }
        return false;
    }

    public boolean isDuplicatedBy(Import other) {
        return this.isStatic() == other.isStatic() && this.getImport().contentEquals(other.getImport());
    }

    public Import combineWith(Import duplicate) {
        String newPrefix = this.getPrefix().isEmpty() ? duplicate.getPrefix() : (duplicate.getPrefix().isEmpty() ? this.getPrefix() : this.getPrefix() + "\n" + duplicate.getPrefix());
        String newSuffix = this.getSuffix().isEmpty() ? duplicate.getSuffix() : (duplicate.getSuffix().isEmpty() ? this.getSuffix() : this.getSuffix() + duplicate.getSuffix());
        return new Import(this.isStatic(), this.getImport(), newPrefix, newSuffix);
    }
}

