/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter.xml.lib;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.revelc.code.formatter.xml.lib.CommentFormatter;
import net.revelc.code.formatter.xml.lib.FormattingPreferences;
import net.revelc.code.formatter.xml.lib.XMLTagFormatter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XmlDocumentFormatter {
    private final String fDefaultLineDelimiter;
    private final FormattingPreferences prefs;
    private static ErrorHandler errorHandler = new ErrorHandler(){

        @Override
        public void warning(SAXParseException e) throws SAXException {
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }
    };

    public XmlDocumentFormatter() {
        this(System.lineSeparator(), new FormattingPreferences());
    }

    public XmlDocumentFormatter(FormattingPreferences prefs) {
        this(System.lineSeparator(), prefs);
    }

    public XmlDocumentFormatter(String defaultLineDelimiter, FormattingPreferences prefs) {
        this.fDefaultLineDelimiter = defaultLineDelimiter;
        this.prefs = prefs;
    }

    private void copyNode(Reader reader, FormatState state) throws IOException {
        TagReader tag = TagReaderFactory.createTagReaderFor(reader);
        state.depth += tag.getPreTagDepthModifier();
        if (!state.lastNodeWasText) {
            if (tag.startsOnNewline() && !XmlDocumentFormatter.hasNewlineAlready(state)) {
                state.out.append(this.fDefaultLineDelimiter);
            }
            if (tag.requiresInitialIndent()) {
                this.indent(state.depth, state.out);
            }
        }
        if (tag instanceof XmlElementReader) {
            StringBuilder indentBuilder = new StringBuilder(30);
            this.indent(state.depth, indentBuilder);
            state.out.append(new XMLTagFormatter().format(tag.getTagText(), indentBuilder.toString(), this.fDefaultLineDelimiter, this.prefs));
        } else if (tag instanceof CommentReader) {
            StringBuilder indentBuilder = new StringBuilder(30);
            this.indent(state.depth, indentBuilder);
            state.out.append(new CommentFormatter().format(tag.getTagText(), indentBuilder.toString(), this.fDefaultLineDelimiter));
        } else {
            String tagText = tag.getTagText();
            if (!this.prefs.getDeleteBlankLines() || this.prefs.getDeleteBlankLines() && tagText != null && !tagText.isBlank()) {
                state.out.append(tagText);
            }
        }
        state.depth += tag.getPostTagDepthModifier();
        state.lastNodeWasText = tag.isTextNode();
    }

    public String format(String documentText) {
        if (!this.prefs.getWellFormedValidation().equals("IGNORE")) {
            this.validateWellFormedness(documentText);
        }
        StringReader reader = new StringReader(documentText);
        FormatState state = new FormatState();
        try {
            while (true) {
                ((Reader)reader).mark(1);
                int intChar = ((Reader)reader).read();
                ((Reader)reader).reset();
                if (intChar == -1) break;
                this.copyNode(reader, state);
            }
            ((Reader)reader).close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return state.out.toString();
    }

    private void validateWellFormedness(String documentText) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SAXParser parser = factory.newSAXParser();
            parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            XMLReader reader = parser.getXMLReader();
            reader.setErrorHandler(errorHandler);
            reader.parse(new InputSource(new StringReader(documentText)));
        }
        catch (Exception exception) {
            if (!(exception instanceof SAXParseException) || !this.prefs.getWellFormedValidation().equals("WARN")) {
                throw new IllegalArgumentException(exception);
            }
            System.err.println("WARN: " + exception.getMessage());
        }
    }

    private static boolean hasNewlineAlready(FormatState state) {
        return state.out.lastIndexOf("\n") == state.out.length() - 1 || state.out.lastIndexOf("\r") == state.out.length() - 1;
    }

    private void indent(int depth, StringBuilder out) {
        IntStream.range(0, depth).forEach(i -> out.append(this.prefs.getCanonicalIndent()));
    }

    private static class XmlElementReader
    extends TagReader {
        private boolean complete = false;

        private XmlElementReader() {
        }

        @Override
        protected void clear() {
            this.complete = false;
        }

        @Override
        public int getPostTagDepthModifier() {
            if (this.getTagText().endsWith("/>") || this.getTagText().endsWith("/ >") || this.getTagText().startsWith("</")) {
                return 0;
            }
            return 1;
        }

        @Override
        public int getPreTagDepthModifier() {
            if (this.getTagText().startsWith("</")) {
                return -1;
            }
            return 0;
        }

        @Override
        public String getStartOfTag() {
            return "<";
        }

        @Override
        protected String readTag() throws IOException {
            int intChar;
            StringBuilder node = new StringBuilder();
            boolean insideQuote = false;
            while (!this.complete && (intChar = this.reader.read()) != -1) {
                char c = (char)intChar;
                node.append(c);
                if (c == '\"') {
                    boolean bl = insideQuote = !insideQuote;
                }
                if (c != '>' || insideQuote) continue;
                this.complete = true;
            }
            return node.toString();
        }
    }

    private static class TextReader
    extends TagReader {
        private boolean complete;
        private boolean isTextNode;

        private TextReader() {
        }

        @Override
        protected void clear() {
            this.complete = false;
        }

        @Override
        public String getStartOfTag() {
            return "";
        }

        @Override
        public boolean isTextNode() {
            return this.isTextNode;
        }

        @Override
        protected String readTag() throws IOException {
            StringBuilder node = new StringBuilder();
            while (!this.complete) {
                this.reader.mark(1);
                int intChar = this.reader.read();
                if (intChar == -1) break;
                char c = (char)intChar;
                if (c == '<') {
                    this.reader.reset();
                    this.complete = true;
                    continue;
                }
                node.append(c);
            }
            if (node.length() < 1) {
                this.isTextNode = false;
            } else if (node.toString().trim().length() == 0) {
                String whitespace = node.toString();
                node = new StringBuilder();
                for (int i = 0; i < whitespace.length(); ++i) {
                    char whitespaceCharacter = whitespace.charAt(i);
                    if (whitespaceCharacter != '\n' && whitespaceCharacter != '\r') continue;
                    node.append(whitespaceCharacter);
                }
                this.isTextNode = false;
            } else {
                this.isTextNode = true;
            }
            return node.toString();
        }

        @Override
        public boolean requiresInitialIndent() {
            return false;
        }

        @Override
        public boolean startsOnNewline() {
            return false;
        }
    }

    private static class TagReaderFactory {
        private static final Map<String, Supplier<TagReader>> tagReaders = new LinkedHashMap<String, Supplier<TagReader>>(4);

        private TagReaderFactory() {
        }

        public static TagReader createTagReaderFor(Reader reader) throws IOException {
            char[] buf = new char[10];
            reader.mark(10);
            reader.read(buf, 0, 10);
            reader.reset();
            String startOfTag = String.valueOf(buf);
            for (Map.Entry<String, Supplier<TagReader>> entry : tagReaders.entrySet()) {
                if (!startOfTag.startsWith(entry.getKey())) continue;
                TagReader tagReader = entry.getValue().get();
                tagReader.setReader(reader);
                return tagReader;
            }
            TextReader textNodeReader = new TextReader();
            textNodeReader.setReader(reader);
            return textNodeReader;
        }

        static {
            tagReaders.put("<!--", () -> new CommentReader());
            tagReaders.put("<!", () -> new DoctypeDeclarationReader());
            tagReaders.put("<?", () -> new ProcessingInstructionReader());
            tagReaders.put("<", () -> new XmlElementReader());
        }
    }

    private static abstract class TagReader {
        protected Reader reader;
        private String tagText;

        private TagReader() {
        }

        protected abstract void clear();

        public int getPostTagDepthModifier() {
            return 0;
        }

        public int getPreTagDepthModifier() {
            return 0;
        }

        public abstract String getStartOfTag();

        public String getTagText() {
            return this.tagText;
        }

        public boolean isTextNode() {
            return false;
        }

        protected abstract String readTag() throws IOException;

        public boolean requiresInitialIndent() {
            return true;
        }

        public void setReader(Reader reader) throws IOException {
            this.reader = reader;
            this.clear();
            this.tagText = this.readTag();
        }

        public boolean startsOnNewline() {
            return true;
        }
    }

    private static class ProcessingInstructionReader
    extends TagReader {
        private boolean complete = false;

        private ProcessingInstructionReader() {
        }

        @Override
        protected void clear() {
            this.complete = false;
        }

        @Override
        public String getStartOfTag() {
            return "<?";
        }

        @Override
        protected String readTag() throws IOException {
            int intChar;
            StringBuilder node = new StringBuilder();
            while (!this.complete && (intChar = this.reader.read()) != -1) {
                char c = (char)intChar;
                node.append(c);
                if (c != '>' || !node.toString().endsWith("?>")) continue;
                this.complete = true;
            }
            return node.toString();
        }
    }

    private static class DoctypeDeclarationReader
    extends TagReader {
        private boolean complete = false;

        private DoctypeDeclarationReader() {
        }

        @Override
        protected void clear() {
            this.complete = false;
        }

        @Override
        public String getStartOfTag() {
            return "<!";
        }

        @Override
        protected String readTag() throws IOException {
            int intChar;
            StringBuilder node = new StringBuilder();
            while (!this.complete && (intChar = this.reader.read()) != -1) {
                char c = (char)intChar;
                node.append(c);
                if (c != '>') continue;
                this.complete = true;
            }
            return node.toString();
        }
    }

    private static class CommentReader
    extends TagReader {
        private boolean complete = false;

        private CommentReader() {
        }

        @Override
        protected void clear() {
            this.complete = false;
        }

        @Override
        public String getStartOfTag() {
            return "<!--";
        }

        @Override
        protected String readTag() throws IOException {
            int intChar;
            StringBuilder node = new StringBuilder();
            while (!this.complete && (intChar = this.reader.read()) != -1) {
                char c = (char)intChar;
                node.append(c);
                if (c != '>' || !node.toString().endsWith("-->")) continue;
                this.complete = true;
            }
            return node.toString();
        }

        @Override
        public boolean requiresInitialIndent() {
            return false;
        }
    }

    private static class FormatState {
        private int depth = 0;
        private boolean lastNodeWasText = false;
        private StringBuilder out = new StringBuilder(200);

        private FormatState() {
        }
    }
}

