/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter.xml.lib;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.revelc.code.formatter.xml.lib.FormattingPreferences;
import net.revelc.code.formatter.xml.lib.XMLTagFormatter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XmlDocumentFormatter {
    private final String fDefaultLineDelimiter;
    private final FormattingPreferences prefs;
    private int depth = -1;
    private boolean lastNodeWasText;
    private StringBuilder formattedXml;
    private static ErrorHandler errorHandler = new ErrorHandler(){

        @Override
        public void warning(SAXParseException e) throws SAXException {
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }
    };

    public XmlDocumentFormatter() {
        this(System.lineSeparator(), new FormattingPreferences());
    }

    public XmlDocumentFormatter(FormattingPreferences prefs) {
        this(System.lineSeparator(), prefs);
    }

    public XmlDocumentFormatter(String defaultLineDelimiter, FormattingPreferences prefs) {
        this.fDefaultLineDelimiter = defaultLineDelimiter;
        this.prefs = prefs;
    }

    private void copyNode(Reader reader, StringBuilder out) throws IOException {
        TagReader tag = TagReaderFactory.createTagReaderFor(reader);
        this.depth += tag.getPreTagDepthModifier();
        if (!this.lastNodeWasText) {
            if (tag.startsOnNewline() && !this.hasNewlineAlready(out)) {
                out.append(this.fDefaultLineDelimiter);
            }
            if (tag.requiresInitialIndent()) {
                out.append(this.indent(this.prefs.getCanonicalIndent()));
            }
        }
        if (tag instanceof XmlElementReader) {
            out.append(new XMLTagFormatter().format(tag.getTagText(), this.indent(this.prefs.getCanonicalIndent()), this.fDefaultLineDelimiter, this.prefs));
        } else {
            out.append(tag.getTagText());
        }
        this.depth += tag.getPostTagDepthModifier();
        this.lastNodeWasText = tag.isTextNode();
    }

    public String format(String documentText) {
        this.validateWellFormedness(documentText);
        StringReader reader = new StringReader(documentText);
        this.formattedXml = new StringBuilder();
        if (this.depth == -1) {
            this.depth = 0;
        }
        this.lastNodeWasText = false;
        try {
            while (true) {
                ((Reader)reader).mark(1);
                int intChar = ((Reader)reader).read();
                ((Reader)reader).reset();
                if (intChar == -1) break;
                this.copyNode(reader, this.formattedXml);
            }
            ((Reader)reader).close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return this.formattedXml.toString();
    }

    private void validateWellFormedness(String documentText) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setErrorHandler(errorHandler);
            reader.parse(new InputSource(new StringReader(documentText)));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    private boolean hasNewlineAlready(StringBuilder out) {
        return out.lastIndexOf("\n") == this.formattedXml.length() - 1 || out.lastIndexOf("\r") == this.formattedXml.length() - 1;
    }

    private String indent(String canonicalIndent) {
        StringBuilder indent = new StringBuilder(30);
        for (int i = 0; i < this.depth; ++i) {
            indent.append(canonicalIndent);
        }
        return indent.toString();
    }

    private static class XmlElementReader
    extends TagReader {
        private boolean complete = false;

        private XmlElementReader() {
        }

        @Override
        protected void clear() {
            this.complete = false;
        }

        @Override
        public int getPostTagDepthModifier() {
            if (this.getTagText().endsWith("/>") || this.getTagText().endsWith("/ >")) {
                return 0;
            }
            if (this.getTagText().startsWith("</")) {
                return 0;
            }
            return 1;
        }

        @Override
        public int getPreTagDepthModifier() {
            if (this.getTagText().startsWith("</")) {
                return -1;
            }
            return 0;
        }

        @Override
        public String getStartOfTag() {
            return "<";
        }

        @Override
        protected String readTag() throws IOException {
            int intChar;
            StringBuilder node = new StringBuilder();
            boolean insideQuote = false;
            while (!this.complete && (intChar = this.reader.read()) != -1) {
                char c = (char)intChar;
                node.append(c);
                if (c == '\"') {
                    boolean bl = insideQuote = !insideQuote;
                }
                if (c != '>' || insideQuote) continue;
                this.complete = true;
            }
            return node.toString();
        }
    }

    private static class TextReader
    extends TagReader {
        private boolean complete;
        private boolean isTextNode;

        private TextReader() {
        }

        @Override
        protected void clear() {
            this.complete = false;
        }

        @Override
        public String getStartOfTag() {
            return "";
        }

        @Override
        public boolean isTextNode() {
            return this.isTextNode;
        }

        @Override
        protected String readTag() throws IOException {
            StringBuilder node = new StringBuilder();
            while (!this.complete) {
                this.reader.mark(1);
                int intChar = this.reader.read();
                if (intChar == -1) break;
                char c = (char)intChar;
                if (c == '<') {
                    this.reader.reset();
                    this.complete = true;
                    continue;
                }
                node.append(c);
            }
            if (node.length() < 1) {
                this.isTextNode = false;
            } else if (node.toString().trim().length() == 0) {
                String whitespace = node.toString();
                node = new StringBuilder();
                for (int i = 0; i < whitespace.length(); ++i) {
                    char whitespaceCharacter = whitespace.charAt(i);
                    if (whitespaceCharacter != '\n' && whitespaceCharacter != '\r') continue;
                    node.append(whitespaceCharacter);
                }
                this.isTextNode = false;
            } else {
                this.isTextNode = true;
            }
            return node.toString();
        }

        @Override
        public boolean requiresInitialIndent() {
            return false;
        }

        @Override
        public boolean startsOnNewline() {
            return false;
        }
    }

    private static class TagReaderFactory {
        private static TagReader[] tagReaders = new TagReader[]{new CommentReader(), new DoctypeDeclarationReader(), new ProcessingInstructionReader(), new XmlElementReader()};
        private static TagReader textNodeReader = new TextReader();

        private TagReaderFactory() {
        }

        public static TagReader createTagReaderFor(Reader reader) throws IOException {
            char[] buf = new char[10];
            reader.mark(10);
            reader.read(buf, 0, 10);
            reader.reset();
            String startOfTag = String.valueOf(buf);
            for (int i = 0; i < tagReaders.length; ++i) {
                if (!startOfTag.startsWith(tagReaders[i].getStartOfTag())) continue;
                tagReaders[i].setReader(reader);
                return tagReaders[i];
            }
            textNodeReader.setReader(reader);
            return textNodeReader;
        }
    }

    private static abstract class TagReader {
        protected Reader reader;
        private String tagText;

        private TagReader() {
        }

        protected abstract void clear();

        public int getPostTagDepthModifier() {
            return 0;
        }

        public int getPreTagDepthModifier() {
            return 0;
        }

        public abstract String getStartOfTag();

        public String getTagText() {
            return this.tagText;
        }

        public boolean isTextNode() {
            return false;
        }

        protected abstract String readTag() throws IOException;

        public boolean requiresInitialIndent() {
            return true;
        }

        public void setReader(Reader reader) throws IOException {
            this.reader = reader;
            this.clear();
            this.tagText = this.readTag();
        }

        public boolean startsOnNewline() {
            return true;
        }
    }

    private static class ProcessingInstructionReader
    extends TagReader {
        private boolean complete = false;

        private ProcessingInstructionReader() {
        }

        @Override
        protected void clear() {
            this.complete = false;
        }

        @Override
        public String getStartOfTag() {
            return "<?";
        }

        @Override
        protected String readTag() throws IOException {
            int intChar;
            StringBuilder node = new StringBuilder();
            while (!this.complete && (intChar = this.reader.read()) != -1) {
                char c = (char)intChar;
                node.append(c);
                if (c != '>' || !node.toString().endsWith("?>")) continue;
                this.complete = true;
            }
            return node.toString();
        }
    }

    private static class DoctypeDeclarationReader
    extends TagReader {
        private boolean complete = false;

        private DoctypeDeclarationReader() {
        }

        @Override
        protected void clear() {
            this.complete = false;
        }

        @Override
        public String getStartOfTag() {
            return "<!";
        }

        @Override
        protected String readTag() throws IOException {
            int intChar;
            StringBuilder node = new StringBuilder();
            while (!this.complete && (intChar = this.reader.read()) != -1) {
                char c = (char)intChar;
                node.append(c);
                if (c != '>') continue;
                this.complete = true;
            }
            return node.toString();
        }
    }

    private static class CommentReader
    extends TagReader {
        private boolean complete = false;

        private CommentReader() {
        }

        @Override
        protected void clear() {
            this.complete = false;
        }

        @Override
        public String getStartOfTag() {
            return "<!--";
        }

        @Override
        protected String readTag() throws IOException {
            int intChar;
            StringBuilder node = new StringBuilder();
            while (!this.complete && (intChar = this.reader.read()) != -1) {
                char c = (char)intChar;
                node.append(c);
                if (c != '>' || !node.toString().endsWith("-->")) continue;
                this.complete = true;
            }
            return node.toString();
        }
    }
}

