/*
 * Decompiled with CFR 0.152.
 */
package net.researchgate.release;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import net.researchgate.release.BaseScmAdapter;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public class GitAdapter
extends BaseScmAdapter {
    private static final String LINE = "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~";
    private static final String UNCOMMITTED = "uncommitted";
    private static final String UNVERSIONED = "unversioned";
    private static final String AHEAD = "ahead";
    private static final String BEHIND = "behind";
    private String workingBranch;
    private String releaseBranch;
    private File workingDirectory;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public GitAdapter(Project project, Map<String, Object> attributes) {
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        super(project, attributes);
    }

    @Override
    public boolean isSupported(File directory) {
        File file;
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(callSiteArray[1].call((Object)directory), (Object)".git"))) {
            return DefaultTypeTransformation.booleanUnbox((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty((Object)directory)) ? callSiteArray[3].callCurrent((GroovyObject)this, callSiteArray[4].callGetProperty((Object)directory)) : Boolean.valueOf(false)));
        }
        this.workingDirectory = file = directory;
        return true;
    }

    @Override
    public void init() {
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[5].callCurrent((GroovyObject)this);
            this.workingBranch = ShortTypeHandling.castToString((Object)object);
        } else {
            String string;
            this.workingBranch = string = this.gitCurrentBranch();
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty(callSiteArray[8].callGroovyObjectGetProperty((Object)this))))) {
            Object object = callSiteArray[9].call(callSiteArray[10].callGroovyObjectGetProperty(callSiteArray[11].callGroovyObjectGetProperty((Object)this)));
            this.releaseBranch = ShortTypeHandling.castToString((Object)object);
        } else {
            String string;
            this.releaseBranch = string = this.workingBranch;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].call(callSiteArray[13].callGetProperty(callSiteArray[14].callGroovyObjectGetProperty(callSiteArray[15].callGroovyObjectGetProperty((Object)this))))) && !ScriptBytecodeAdapter.matchRegex((Object)this.workingBranch, (Object)callSiteArray[16].call(callSiteArray[17].callGetProperty(callSiteArray[18].callGroovyObjectGetProperty(callSiteArray[19].callGroovyObjectGetProperty((Object)this)))))) {
            throw (Throwable)callSiteArray[20].callConstructor(GradleException.class, (Object)new GStringImpl(new Object[]{this.workingBranch, callSiteArray[21].call(callSiteArray[22].callGetProperty(callSiteArray[23].callGroovyObjectGetProperty(callSiteArray[24].callGroovyObjectGetProperty((Object)this))))}, new String[]{"Current Git branch is \"", "\" and not \"", "\"."}));
        }
    }

    @Override
    public void checkCommitNeeded() {
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        Object status = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            status = object = callSiteArray[25].callCurrent((GroovyObject)this);
        } else {
            Map<String, List<String>> map = this.gitStatus();
            status = map;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[26].call(status, (Object)UNVERSIONED))) {
            callSiteArray[27].callCurrent((GroovyObject)this, callSiteArray[28].call(callSiteArray[29].callGroovyObjectGetProperty(callSiteArray[30].callGroovyObjectGetProperty((Object)this))), callSiteArray[31].call((Object)((String[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[]{"You have unversioned files:", LINE, LINE}, (Object[])new Object[]{callSiteArray[32].call(status, (Object)UNVERSIONED)}, (int[])new int[]{2})), String[].class)), (Object)"\n"));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[33].call(status, (Object)UNCOMMITTED))) {
            callSiteArray[34].callCurrent((GroovyObject)this, callSiteArray[35].call(callSiteArray[36].callGroovyObjectGetProperty(callSiteArray[37].callGroovyObjectGetProperty((Object)this))), callSiteArray[38].call((Object)((String[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[]{"You have uncommitted files:", LINE, LINE}, (Object[])new Object[]{callSiteArray[39].call(status, (Object)UNCOMMITTED)}, (int[])new int[]{2})), String[].class)), (Object)"\n"));
        }
    }

    @Override
    public void checkUpdateNeeded() {
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        callSiteArray[40].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"directory", this.workingDirectory, "errorPatterns", ScriptBytecodeAdapter.createList((Object[])new Object[]{"error: ", "fatal: "})}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "remote", "update"}));
        Object status = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            status = object = callSiteArray[41].callCurrent((GroovyObject)this);
        } else {
            Map<String, Integer> map = this.gitRemoteStatus();
            status = map;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[42].call(status, (Object)AHEAD))) {
            callSiteArray[43].callCurrent((GroovyObject)this, callSiteArray[44].call(callSiteArray[45].callGroovyObjectGetProperty(callSiteArray[46].callGroovyObjectGetProperty((Object)this))), (Object)new GStringImpl(new Object[]{callSiteArray[47].call(status, (Object)AHEAD)}, new String[]{"You have ", " local change(s) to push."}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].call(status, (Object)BEHIND))) {
            callSiteArray[49].callCurrent((GroovyObject)this, callSiteArray[50].call(callSiteArray[51].callGroovyObjectGetProperty(callSiteArray[52].callGroovyObjectGetProperty((Object)this))), (Object)new GStringImpl(new Object[]{callSiteArray[53].call(status, (Object)BEHIND)}, new String[]{"You have ", " remote change(s) to pull."}));
        }
    }

    @Override
    public void createReleaseTag(String message) {
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        Object tagName = callSiteArray[54].callCurrent((GroovyObject)this);
        List params = ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "tag", "-a", tagName, "-m", message});
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[55].call(callSiteArray[56].callGetProperty(callSiteArray[57].callGroovyObjectGetProperty(callSiteArray[58].callGroovyObjectGetProperty((Object)this)))))) {
            callSiteArray[59].call((Object)params, (Object)"-s");
        }
        callSiteArray[60].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"directory", this.workingDirectory, "errorMessage", new GStringImpl(new Object[]{tagName}, new String[]{"Duplicate tag [", "] or signing error"}), "errorPatterns", ScriptBytecodeAdapter.createList((Object[])new Object[]{"already exists", "failed to sign"})}), (Object)params);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[61].callCurrent((GroovyObject)this))) {
                callSiteArray[62].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"directory", this.workingDirectory, "errorMessage", new GStringImpl(new Object[]{tagName}, new String[]{"Failed to push tag [", "] to remote"}), "errorPatterns", ScriptBytecodeAdapter.createList((Object[])new Object[]{"[rejected]", "error: ", "fatal: "})}), callSiteArray[63].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "push", "--porcelain", callSiteArray[64].call(callSiteArray[65].call(callSiteArray[66].callGetProperty(callSiteArray[67].callGroovyObjectGetProperty(callSiteArray[68].callGroovyObjectGetProperty((Object)this))))), tagName}), callSiteArray[69].call(callSiteArray[70].callGetProperty(callSiteArray[71].callGroovyObjectGetProperty(callSiteArray[72].callGroovyObjectGetProperty((Object)this))))));
            }
        } else if (this.shouldPush()) {
            callSiteArray[73].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"directory", this.workingDirectory, "errorMessage", new GStringImpl(new Object[]{tagName}, new String[]{"Failed to push tag [", "] to remote"}), "errorPatterns", ScriptBytecodeAdapter.createList((Object[])new Object[]{"[rejected]", "error: ", "fatal: "})}), callSiteArray[74].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "push", "--porcelain", callSiteArray[75].call(callSiteArray[76].call(callSiteArray[77].callGetProperty(callSiteArray[78].callGroovyObjectGetProperty(callSiteArray[79].callGroovyObjectGetProperty((Object)this))))), tagName}), callSiteArray[80].call(callSiteArray[81].callGetProperty(callSiteArray[82].callGroovyObjectGetProperty(callSiteArray[83].callGroovyObjectGetProperty((Object)this))))));
        }
    }

    @Override
    public void commit(String message) {
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        List command = ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "commit", "-m", message});
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[84].call(callSiteArray[85].callGetProperty(callSiteArray[86].callGroovyObjectGetProperty(callSiteArray[87].callGroovyObjectGetProperty((Object)this)))))) {
            callSiteArray[88].call((Object)command, callSiteArray[89].call(callSiteArray[90].callGroovyObjectGetProperty((Object)this), callSiteArray[91].call(callSiteArray[92].callGroovyObjectGetProperty(callSiteArray[93].callGroovyObjectGetProperty((Object)this)))));
        } else {
            callSiteArray[94].call((Object)command, (Object)"-a");
        }
        callSiteArray[95].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"directory", this.workingDirectory, "errorPatterns", ScriptBytecodeAdapter.createList((Object[])new Object[]{"error: ", "fatal: "})}), (Object)command);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[96].callCurrent((GroovyObject)this))) {
                Object branch = callSiteArray[97].callCurrent((GroovyObject)this);
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[98].call(callSiteArray[99].callGetProperty(callSiteArray[100].callGroovyObjectGetProperty(callSiteArray[101].callGroovyObjectGetProperty((Object)this)))))) {
                    GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[102].call(callSiteArray[103].callGetProperty(callSiteArray[104].callGroovyObjectGetProperty(callSiteArray[105].callGroovyObjectGetProperty((Object)this)))), branch}, new String[]{"HEAD:", "", ""});
                    branch = gStringImpl;
                }
                callSiteArray[106].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"directory", this.workingDirectory, "errorMessage", "Failed to push to remote", "errorPatterns", ScriptBytecodeAdapter.createList((Object[])new Object[]{"[rejected]", "error: ", "fatal: "})}), callSiteArray[107].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "push", "--porcelain", callSiteArray[108].call(callSiteArray[109].call(callSiteArray[110].callGetProperty(callSiteArray[111].callGroovyObjectGetProperty(callSiteArray[112].callGroovyObjectGetProperty((Object)this))))), branch}), callSiteArray[113].call(callSiteArray[114].callGetProperty(callSiteArray[115].callGroovyObjectGetProperty(callSiteArray[116].callGroovyObjectGetProperty((Object)this))))));
            }
        } else if (this.shouldPush()) {
            String branch = this.gitCurrentBranch();
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[117].call(callSiteArray[118].callGetProperty(callSiteArray[119].callGroovyObjectGetProperty(callSiteArray[120].callGroovyObjectGetProperty((Object)this)))))) {
                GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[121].call(callSiteArray[122].callGetProperty(callSiteArray[123].callGroovyObjectGetProperty(callSiteArray[124].callGroovyObjectGetProperty((Object)this)))), branch}, new String[]{"HEAD:", "", ""});
                branch = gStringImpl;
            }
            callSiteArray[125].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"directory", this.workingDirectory, "errorMessage", "Failed to push to remote", "errorPatterns", ScriptBytecodeAdapter.createList((Object[])new Object[]{"[rejected]", "error: ", "fatal: "})}), callSiteArray[126].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "push", "--porcelain", callSiteArray[127].call(callSiteArray[128].call(callSiteArray[129].callGetProperty(callSiteArray[130].callGroovyObjectGetProperty(callSiteArray[131].callGroovyObjectGetProperty((Object)this))))), branch}), callSiteArray[132].call(callSiteArray[133].callGetProperty(callSiteArray[134].callGroovyObjectGetProperty(callSiteArray[135].callGroovyObjectGetProperty((Object)this))))));
        }
    }

    @Override
    public void add(File file) {
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        callSiteArray[136].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"directory", this.workingDirectory, "errorMessage", new GStringImpl(new Object[]{callSiteArray[137].callGetProperty((Object)file)}, new String[]{"Error adding file ", ""}), "errorPatterns", ScriptBytecodeAdapter.createList((Object[])new Object[]{"error: ", "fatal: "})}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "add", callSiteArray[138].callGetProperty((Object)file)}));
    }

    @Override
    public void revert() {
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        callSiteArray[139].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"directory", this.workingDirectory, "errorMessage", "Error reverting changes made by the release plugin."}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "checkout", callSiteArray[140].callGetProperty(callSiteArray[141].callCurrent((GroovyObject)this))}));
    }

    @Override
    public void checkoutMergeToReleaseBranch() {
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[142].callCurrent((GroovyObject)this, (Object)this.workingBranch, (Object)this.releaseBranch);
        } else {
            this.checkoutMerge(this.workingBranch, this.releaseBranch);
        }
    }

    @Override
    public void checkoutMergeFromReleaseBranch() {
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[143].callCurrent((GroovyObject)this, (Object)this.releaseBranch, (Object)this.workingBranch);
        } else {
            this.checkoutMerge(this.releaseBranch, this.workingBranch);
        }
    }

    private Object checkoutMerge(String fromBranch, String toBranch) {
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        callSiteArray[144].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"directory", this.workingDirectory, "errorPatterns", ScriptBytecodeAdapter.createList((Object[])new Object[]{"error: ", "fatal: "})}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "fetch"}));
        callSiteArray[145].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"directory", this.workingDirectory, "errorPatterns", ScriptBytecodeAdapter.createList((Object[])new Object[]{"error: ", "fatal: "})}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "checkout", toBranch}));
        return callSiteArray[146].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"directory", this.workingDirectory, "errorPatterns", ScriptBytecodeAdapter.createList((Object[])new Object[]{"error: ", "fatal: ", "CONFLICT"})}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "merge", "--no-ff", "--no-commit", fromBranch}));
    }

    private boolean shouldPush() {
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        Reference shouldPush = new Reference((Object)false);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[147].call(callSiteArray[148].callGetProperty(callSiteArray[149].callGroovyObjectGetProperty(callSiteArray[150].callGroovyObjectGetProperty((Object)this)))))) {
            public final class _shouldPush_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference shouldPush;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _shouldPush_closure1(Object _outerInstance, Object _thisObject, Reference shouldPush) {
                    Reference reference;
                    CallSite[] callSiteArray = _shouldPush_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.shouldPush = reference = shouldPush;
                }

                public Object doCall(Object line) {
                    CallSite[] callSiteArray = _shouldPush_closure1.$getCallSiteArray();
                    Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)line, (Object)ScriptBytecodeAdapter.bitwiseNegate((Object)"^\\s*(.*)\\s*$")), Matcher.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call((Object)matcher)) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].call((Object)matcher, (Object)1), (Object)callSiteArray[2].call(callSiteArray[3].callGetProperty(callSiteArray[4].callGroovyObjectGetProperty(callSiteArray[5].callGroovyObjectGetProperty((Object)this)))))) {
                        boolean bl = true;
                        this.shouldPush.set((Object)bl);
                        return bl;
                    }
                    return null;
                }

                @Generated
                public Object getShouldPush() {
                    CallSite[] callSiteArray = _shouldPush_closure1.$getCallSiteArray();
                    return this.shouldPush.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _shouldPush_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "matches";
                    stringArray[1] = "group";
                    stringArray[2] = "get";
                    stringArray[3] = "pushToRemote";
                    stringArray[4] = "git";
                    stringArray[5] = "extension";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[6];
                    _shouldPush_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_shouldPush_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _shouldPush_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[151].call(callSiteArray[152].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"directory", this.workingDirectory}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "remote"})), (Object)new _shouldPush_closure1(this, this, shouldPush));
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (!DefaultTypeTransformation.booleanUnbox((Object)shouldPush.get()) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[153].call(callSiteArray[154].callGetProperty(callSiteArray[155].callGroovyObjectGetProperty(callSiteArray[156].callGroovyObjectGetProperty((Object)this)))), (Object)"origin")) {
                    throw (Throwable)callSiteArray[157].callConstructor(GradleException.class, (Object)new GStringImpl(new Object[]{callSiteArray[158].call(callSiteArray[159].callGetProperty(callSiteArray[160].callGroovyObjectGetProperty(callSiteArray[161].callGroovyObjectGetProperty((Object)this))))}, new String[]{"Could not push to remote ", " as repository has no such remote"}));
                }
            } else if (!DefaultTypeTransformation.booleanUnbox((Object)shouldPush.get()) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[162].call(callSiteArray[163].callGetProperty(callSiteArray[164].callGroovyObjectGetProperty(callSiteArray[165].callGroovyObjectGetProperty((Object)this)))), (Object)"origin")) {
                throw (Throwable)callSiteArray[166].callConstructor(GradleException.class, (Object)new GStringImpl(new Object[]{callSiteArray[167].call(callSiteArray[168].callGetProperty(callSiteArray[169].callGroovyObjectGetProperty(callSiteArray[170].callGroovyObjectGetProperty((Object)this))))}, new String[]{"Could not push to remote ", " as repository has no such remote"}));
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)shouldPush.get());
    }

    private String gitCurrentBranch() {
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        Object matches = callSiteArray[171].call(callSiteArray[172].call(callSiteArray[173].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"directory", this.workingDirectory}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "branch", "--no-color"}))), ScriptBytecodeAdapter.bitwiseNegate((Object)"\\s*\\*.*"));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[174].call(matches))) {
            return ShortTypeHandling.castToString((Object)callSiteArray[175].call(callSiteArray[176].call(callSiteArray[177].call(matches, (Object)0)), ScriptBytecodeAdapter.bitwiseNegate((Object)"^\\*\\s+")));
        }
        throw (Throwable)callSiteArray[178].callConstructor(GradleException.class, (Object)"Error, this repository is empty.");
    }

    private Map<String, List<String>> gitStatus() {
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        public final class _gitStatus_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _gitStatus_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _gitStatus_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _gitStatus_closure2.$getCallSiteArray();
                if (ScriptBytecodeAdapter.matchRegex((Object)it, (Object)"^\\s*\\?{2}.*")) {
                    return callSiteArray[0].callGetProperty(GitAdapter.class);
                }
                return callSiteArray[1].callGetProperty(GitAdapter.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _gitStatus_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _gitStatus_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "UNVERSIONED";
                stringArray[1] = "UNCOMMITTED";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _gitStatus_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_gitStatus_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _gitStatus_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[179].call(callSiteArray[180].call(callSiteArray[181].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"directory", this.workingDirectory}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "status", "--porcelain"}))), (Object)new _gitStatus_closure2(this, this)), Map.class);
    }

    private Map<String, Integer> gitRemoteStatus() {
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        Object branchStatus = callSiteArray[182].call(callSiteArray[183].call(callSiteArray[184].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"directory", this.workingDirectory}), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"git", "status", "--porcelain", "-b"}))), (Object)0);
        Matcher aheadMatcher = ScriptBytecodeAdapter.findRegex((Object)branchStatus, (Object)".*ahead (\\d+).*");
        Matcher behindMatcher = ScriptBytecodeAdapter.findRegex((Object)branchStatus, (Object)".*behind (\\d+).*");
        Map remoteStatus = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[185].call((Object)aheadMatcher))) {
            Object object = callSiteArray[186].call(callSiteArray[187].call((Object)aheadMatcher, (Object)0), (Object)1);
            callSiteArray[188].call((Object)remoteStatus, (Object)AHEAD, object);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[189].call((Object)behindMatcher))) {
            Object object = callSiteArray[190].call(callSiteArray[191].call((Object)behindMatcher, (Object)0), (Object)1);
            callSiteArray[192].call((Object)remoteStatus, (Object)BEHIND, object);
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)remoteStatus, Map.class);
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GitAdapter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GitAdapter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        CallSite[] callSiteArray = GitAdapter.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GitAdapter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GitAdapter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ void super$3$checkoutMergeToReleaseBranch() {
        super.checkoutMergeToReleaseBranch();
    }

    public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ void super$3$checkoutMergeFromReleaseBranch() {
        super.checkoutMergeFromReleaseBranch();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "grep";
        stringArray[1] = "list";
        stringArray[2] = "parentFile";
        stringArray[3] = "isSupported";
        stringArray[4] = "parentFile";
        stringArray[5] = "gitCurrentBranch";
        stringArray[6] = "isPresent";
        stringArray[7] = "pushReleaseVersionBranch";
        stringArray[8] = "extension";
        stringArray[9] = "get";
        stringArray[10] = "pushReleaseVersionBranch";
        stringArray[11] = "extension";
        stringArray[12] = "isPresent";
        stringArray[13] = "requireBranch";
        stringArray[14] = "git";
        stringArray[15] = "extension";
        stringArray[16] = "get";
        stringArray[17] = "requireBranch";
        stringArray[18] = "git";
        stringArray[19] = "extension";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "get";
        stringArray[22] = "requireBranch";
        stringArray[23] = "git";
        stringArray[24] = "extension";
        stringArray[25] = "gitStatus";
        stringArray[26] = "getAt";
        stringArray[27] = "warnOrThrow";
        stringArray[28] = "get";
        stringArray[29] = "failOnUnversionedFiles";
        stringArray[30] = "extension";
        stringArray[31] = "join";
        stringArray[32] = "getAt";
        stringArray[33] = "getAt";
        stringArray[34] = "warnOrThrow";
        stringArray[35] = "get";
        stringArray[36] = "failOnCommitNeeded";
        stringArray[37] = "extension";
        stringArray[38] = "join";
        stringArray[39] = "getAt";
        stringArray[40] = "exec";
        stringArray[41] = "gitRemoteStatus";
        stringArray[42] = "getAt";
        stringArray[43] = "warnOrThrow";
        stringArray[44] = "get";
        stringArray[45] = "failOnPublishNeeded";
        stringArray[46] = "extension";
        stringArray[47] = "getAt";
        stringArray[48] = "getAt";
        stringArray[49] = "warnOrThrow";
        stringArray[50] = "get";
        stringArray[51] = "failOnUpdateNeeded";
        stringArray[52] = "extension";
        stringArray[53] = "getAt";
        stringArray[54] = "tagName";
        stringArray[55] = "get";
        stringArray[56] = "signTag";
        stringArray[57] = "git";
        stringArray[58] = "extension";
        stringArray[59] = "add";
        stringArray[60] = "exec";
        stringArray[61] = "shouldPush";
        stringArray[62] = "exec";
        stringArray[63] = "plus";
        stringArray[64] = "toString";
        stringArray[65] = "get";
        stringArray[66] = "pushToRemote";
        stringArray[67] = "git";
        stringArray[68] = "extension";
        stringArray[69] = "get";
        stringArray[70] = "pushOptions";
        stringArray[71] = "git";
        stringArray[72] = "extension";
        stringArray[73] = "exec";
        stringArray[74] = "plus";
        stringArray[75] = "toString";
        stringArray[76] = "get";
        stringArray[77] = "pushToRemote";
        stringArray[78] = "git";
        stringArray[79] = "extension";
        stringArray[80] = "get";
        stringArray[81] = "pushOptions";
        stringArray[82] = "git";
        stringArray[83] = "extension";
        stringArray[84] = "get";
        stringArray[85] = "commitVersionFileOnly";
        stringArray[86] = "git";
        stringArray[87] = "extension";
        stringArray[88] = "leftShift";
        stringArray[89] = "file";
        stringArray[90] = "project";
        stringArray[91] = "get";
        stringArray[92] = "versionPropertyFile";
        stringArray[93] = "extension";
        stringArray[94] = "leftShift";
        stringArray[95] = "exec";
        stringArray[96] = "shouldPush";
        stringArray[97] = "gitCurrentBranch";
        stringArray[98] = "isPresent";
        stringArray[99] = "pushToBranchPrefix";
        stringArray[100] = "git";
        stringArray[101] = "extension";
        stringArray[102] = "get";
        stringArray[103] = "pushToBranchPrefix";
        stringArray[104] = "git";
        stringArray[105] = "extension";
        stringArray[106] = "exec";
        stringArray[107] = "plus";
        stringArray[108] = "toString";
        stringArray[109] = "get";
        stringArray[110] = "pushToRemote";
        stringArray[111] = "git";
        stringArray[112] = "extension";
        stringArray[113] = "get";
        stringArray[114] = "pushOptions";
        stringArray[115] = "git";
        stringArray[116] = "extension";
        stringArray[117] = "isPresent";
        stringArray[118] = "pushToBranchPrefix";
        stringArray[119] = "git";
        stringArray[120] = "extension";
        stringArray[121] = "get";
        stringArray[122] = "pushToBranchPrefix";
        stringArray[123] = "git";
        stringArray[124] = "extension";
        stringArray[125] = "exec";
        stringArray[126] = "plus";
        stringArray[127] = "toString";
        stringArray[128] = "get";
        stringArray[129] = "pushToRemote";
        stringArray[130] = "git";
        stringArray[131] = "extension";
        stringArray[132] = "get";
        stringArray[133] = "pushOptions";
        stringArray[134] = "git";
        stringArray[135] = "extension";
        stringArray[136] = "exec";
        stringArray[137] = "name";
        stringArray[138] = "path";
        stringArray[139] = "exec";
        stringArray[140] = "name";
        stringArray[141] = "findPropertiesFile";
        stringArray[142] = "checkoutMerge";
        stringArray[143] = "checkoutMerge";
        stringArray[144] = "exec";
        stringArray[145] = "exec";
        stringArray[146] = "exec";
        stringArray[147] = "get";
        stringArray[148] = "pushToRemote";
        stringArray[149] = "git";
        stringArray[150] = "extension";
        stringArray[151] = "eachLine";
        stringArray[152] = "exec";
        stringArray[153] = "get";
        stringArray[154] = "pushToRemote";
        stringArray[155] = "git";
        stringArray[156] = "extension";
        stringArray[157] = "<$constructor$>";
        stringArray[158] = "get";
        stringArray[159] = "pushToRemote";
        stringArray[160] = "git";
        stringArray[161] = "extension";
        stringArray[162] = "get";
        stringArray[163] = "pushToRemote";
        stringArray[164] = "git";
        stringArray[165] = "extension";
        stringArray[166] = "<$constructor$>";
        stringArray[167] = "get";
        stringArray[168] = "pushToRemote";
        stringArray[169] = "git";
        stringArray[170] = "extension";
        stringArray[171] = "grep";
        stringArray[172] = "readLines";
        stringArray[173] = "exec";
        stringArray[174] = "isEmpty";
        stringArray[175] = "minus";
        stringArray[176] = "trim";
        stringArray[177] = "getAt";
        stringArray[178] = "<$constructor$>";
        stringArray[179] = "groupBy";
        stringArray[180] = "readLines";
        stringArray[181] = "exec";
        stringArray[182] = "getAt";
        stringArray[183] = "readLines";
        stringArray[184] = "exec";
        stringArray[185] = "matches";
        stringArray[186] = "getAt";
        stringArray[187] = "getAt";
        stringArray[188] = "putAt";
        stringArray[189] = "matches";
        stringArray[190] = "getAt";
        stringArray[191] = "getAt";
        stringArray[192] = "putAt";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[193];
        GitAdapter.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GitAdapter.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GitAdapter.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class GitConfig
    implements GroovyObject {
        @Input
        private final Property<String> requireBranch;
        @Optional
        @Input
        private final Property<Object> pushToRemote;
        @Optional
        @Input
        private ListProperty<String> pushOptions;
        @Input
        private final Property<Boolean> signTag;
        @Optional
        @Input
        private final Property<String> pushToBranchPrefix;
        @Input
        private final Property<Boolean> commitVersionFileOnly;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        public GitConfig(Project project) {
            MetaClass metaClass;
            CallSite[] callSiteArray = GitConfig.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].callGetProperty((Object)project), String.class), (Object)"main");
            this.requireBranch = (Property)ScriptBytecodeAdapter.castToType((Object)object, Property.class);
            Object object2 = callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGetProperty((Object)project), Object.class), (Object)"origin");
            this.pushToRemote = (Property)ScriptBytecodeAdapter.castToType((Object)object2, Property.class);
            Object object3 = callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].callGetProperty((Object)project), String.class), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
            this.pushOptions = (ListProperty)ScriptBytecodeAdapter.castToType((Object)object3, ListProperty.class);
            Object object4 = callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].callGetProperty((Object)project), Boolean.class), (Object)false);
            this.signTag = (Property)ScriptBytecodeAdapter.castToType((Object)object4, Property.class);
            Object object5 = callSiteArray[12].call(callSiteArray[13].callGetProperty((Object)project), String.class);
            this.pushToBranchPrefix = (Property)ScriptBytecodeAdapter.castToType((Object)object5, Property.class);
            Object object6 = callSiteArray[14].call(callSiteArray[15].call(callSiteArray[16].callGetProperty((Object)project), Boolean.class), (Object)false);
            this.commitVersionFileOnly = (Property)ScriptBytecodeAdapter.castToType((Object)object6, Property.class);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = GitConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(GitConfig.class, GitAdapter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = GitConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(GitConfig.class, GitAdapter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = GitConfig.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, GitAdapter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = GitConfig.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, GitAdapter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = GitConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(GitConfig.class, GitAdapter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = GitConfig.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(GitConfig.class, GitAdapter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != GitConfig.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public final Property<String> getRequireBranch() {
            return this.requireBranch;
        }

        @Generated
        public final Property<Object> getPushToRemote() {
            return this.pushToRemote;
        }

        @Generated
        public ListProperty<String> getPushOptions() {
            return this.pushOptions;
        }

        @Generated
        public void setPushOptions(ListProperty<String> listProperty) {
            this.pushOptions = listProperty;
        }

        @Generated
        public final Property<Boolean> getSignTag() {
            return this.signTag;
        }

        @Generated
        public final Property<String> getPushToBranchPrefix() {
            return this.pushToBranchPrefix;
        }

        @Generated
        public final Property<Boolean> getCommitVersionFileOnly() {
            return this.commitVersionFileOnly;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "convention";
            stringArray[1] = "property";
            stringArray[2] = "objects";
            stringArray[3] = "convention";
            stringArray[4] = "property";
            stringArray[5] = "objects";
            stringArray[6] = "convention";
            stringArray[7] = "listProperty";
            stringArray[8] = "objects";
            stringArray[9] = "convention";
            stringArray[10] = "property";
            stringArray[11] = "objects";
            stringArray[12] = "property";
            stringArray[13] = "objects";
            stringArray[14] = "convention";
            stringArray[15] = "property";
            stringArray[16] = "objects";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[17];
            GitConfig.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(GitConfig.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = GitConfig.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

