/*
 * Decompiled with CFR 0.152.
 */
package net.redwarp.gif.android;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import net.redwarp.gif.android.BitmapPool;
import net.redwarp.gif.decoder.Gif;
import net.redwarp.gif.decoder.LoopCount;
import net.redwarp.gif.decoder.Parser;
import net.redwarp.gif.decoder.PixelPacking;
import net.redwarp.gif.decoder.descriptors.GifDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 I2\u00020\u00012\u00020\u0002:\u0002IJB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010)\u001a\u00020*H\u0002J\u0006\u0010+\u001a\u00020\u0016J\b\u0010,\u001a\u00020*H\u0016J\u0010\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\fH\u0002J\b\u00101\u001a\u00020\u0016H\u0016J\b\u00102\u001a\u00020\u0016H\u0016J\b\u00103\u001a\u00020\u0016H\u0016J\u0006\u00104\u001a\u00020\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u00105\u001a\u00020*H\u0002J\b\u00106\u001a\u00020*H\u0002J\u0010\u00107\u001a\u00020*2\u0006\u00108\u001a\u00020\nH\u0016J\u0010\u00109\u001a\u00020*2\u0006\u0010:\u001a\u00020\u0016H\u0016J(\u0010;\u001a\u00020*2\u0006\u0010<\u001a\u00020\u00162\u0006\u0010=\u001a\u00020\u00162\u0006\u0010>\u001a\u00020\u00162\u0006\u0010?\u001a\u00020\u0016H\u0016J\u0012\u0010@\u001a\u00020*2\b\u0010A\u001a\u0004\u0018\u00010BH\u0016J\u000e\u0010C\u001a\u00020*2\u0006\u0010D\u001a\u00020\u0016J\b\u0010E\u001a\u00020\u001fH\u0002J\b\u0010F\u001a\u00020*H\u0016J\b\u0010G\u001a\u00020*H\u0016J\u0010\u0010H\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\nH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lnet/redwarp/gif/android/GifDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat;", "gifDescriptor", "Lnet/redwarp/gif/decoder/descriptors/GifDescriptor;", "(Lnet/redwarp/gif/decoder/descriptors/GifDescriptor;)V", "_loopCount", "Lnet/redwarp/gif/decoder/LoopCount;", "animationCallbacks", "", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat$AnimationCallback;", "bitmap", "Landroid/graphics/Bitmap;", "bitmapCache", "Lnet/redwarp/gif/android/BitmapPool;", "bitmapPaint", "Landroid/graphics/Paint;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "gif", "Lnet/redwarp/gif/decoder/Gif;", "gifHeight", "", "gifWidth", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "handler$delegate", "Lkotlin/Lazy;", "isRunning", "", "lock", "Ljava/lang/Object;", "loopIteration", "loopJob", "Lkotlinx/coroutines/Job;", "matrix", "Landroid/graphics/Matrix;", "pixels", "", "animationJob", "", "backgroundColor", "clearAnimationCallbacks", "draw", "canvas", "Landroid/graphics/Canvas;", "getCurrentFrame", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "getRepeatCount", "postAnimationEnd", "postAnimationStart", "registerAnimationCallback", "callback", "setAlpha", "alpha", "setBounds", "left", "top", "right", "bottom", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "setRepeatCount", "repeatCount", "shouldAnimate", "start", "stop", "unregisterAnimationCallback", "Companion", "DrawHandler", "android-drawable_release"})
public final class GifDrawable
extends Drawable
implements Animatable2Compat {
    private final Gif gif;
    private final BitmapPool bitmapCache;
    private final List<Animatable2Compat.AnimationCallback> animationCallbacks;
    private final Object lock;
    private volatile boolean isRunning;
    private Job loopJob;
    private final int gifWidth;
    private final int gifHeight;
    private final int[] pixels;
    private Bitmap bitmap;
    private final Paint bitmapPaint;
    private final Matrix matrix;
    private final CoroutineScope coroutineScope;
    private int loopIteration;
    private LoopCount _loopCount;
    private final Lazy handler$delegate;
    public static final int REPEAT_INFINITE = -1;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final Handler getHandler() {
        Lazy lazy = this.handler$delegate;
        GifDrawable gifDrawable = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Handler)lazy.getValue();
    }

    public final void setRepeatCount(int repeatCount) {
        this._loopCount = repeatCount == -1 ? (LoopCount)LoopCount.Infinite.INSTANCE : (repeatCount > 0 ? (LoopCount)new LoopCount.Fixed(repeatCount) : (LoopCount)LoopCount.NoLoop.INSTANCE);
    }

    public final int getRepeatCount() {
        int n;
        LoopCount loopCount;
        LoopCount loopCount2 = this._loopCount;
        if (loopCount2 == null) {
            loopCount2 = loopCount = this.gif.getLoopCount();
        }
        if (Intrinsics.areEqual((Object)loopCount, (Object)LoopCount.Infinite.INSTANCE)) {
            n = -1;
        } else if (Intrinsics.areEqual((Object)loopCount, (Object)LoopCount.NoLoop.INSTANCE)) {
            n = 0;
        } else if (loopCount instanceof LoopCount.Fixed) {
            n = ((LoopCount.Fixed)loopCount).getCount();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    public final int backgroundColor() {
        return this.gif.getBackgroundColor();
    }

    public int getIntrinsicWidth() {
        return this.gif.getAspectRatio() >= 1.0 ? (int)((double)this.gifWidth * this.gif.getAspectRatio()) : this.gifWidth;
    }

    public int getIntrinsicHeight() {
        return this.gif.getAspectRatio() >= 1.0 ? this.gifHeight : (int)((double)this.gifHeight / this.gif.getAspectRatio());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            int checkpoint = canvas.save();
            canvas.concat(this.matrix);
            canvas.drawRect(0.0f, 0.0f, (float)this.gifWidth, (float)this.gifHeight, this.bitmapPaint);
            canvas.restoreToCount(checkpoint);
            Unit unit = Unit.INSTANCE;
        }
        if (this.isRunning && !this.getHandler().hasMessages(1024)) {
            Job job = this.loopJob;
            if (job == null || !job.isActive()) {
                this.loopJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ GifDrawable this$0;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                GifDrawable.access$animationJob(this.this$0);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = gifDrawable;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
    }

    public void setAlpha(int alpha) {
        this.bitmapPaint.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.bitmapPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        if (!this.shouldAnimate()) {
            return;
        }
        this.isRunning = true;
        this.postAnimationStart();
        this.invalidateSelf();
    }

    public void stop() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        Job job = this.loopJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.getHandler().removeMessages(1024);
        this.postAnimationEnd();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void registerAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.animationCallbacks.add(callback);
    }

    public boolean unregisterAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return this.animationCallbacks.remove(callback);
    }

    public void clearAnimationCallbacks() {
        this.animationCallbacks.clear();
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        this.matrix.setRectToRect(new RectF(0.0f, 0.0f, (float)this.gifWidth, (float)this.gifHeight), new RectF((float)left, (float)top, (float)right, (float)bottom), Matrix.ScaleToFit.FILL);
    }

    private final void postAnimationStart() {
        Collection collection = this.animationCallbacks;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.getHandler().post(new Runnable(this){
                final /* synthetic */ GifDrawable this$0;

                public final void run() {
                    Iterable $this$forEach$iv = GifDrawable.access$getAnimationCallbacks$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Animatable2Compat.AnimationCallback callback = (Animatable2Compat.AnimationCallback)element$iv;
                        boolean bl = false;
                        callback.onAnimationStart((Drawable)this.this$0);
                    }
                }
                {
                    this.this$0 = gifDrawable;
                }
            });
        }
    }

    private final void postAnimationEnd() {
        Collection collection = this.animationCallbacks;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.getHandler().post(new Runnable(this){
                final /* synthetic */ GifDrawable this$0;

                public final void run() {
                    Iterable $this$forEach$iv = GifDrawable.access$getAnimationCallbacks$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Animatable2Compat.AnimationCallback callback = (Animatable2Compat.AnimationCallback)element$iv;
                        boolean bl = false;
                        callback.onAnimationEnd((Drawable)this.this$0);
                    }
                }
                {
                    this.this$0 = gifDrawable;
                }
            });
        }
    }

    private final boolean shouldAnimate() {
        if (!this.gif.isAnimated()) {
            return false;
        }
        int repeatCount = this.getRepeatCount();
        return repeatCount != 0 || this.loopIteration < repeatCount;
    }

    private final void animationJob() {
        long startTime = SystemClock.elapsedRealtime();
        if (this.getHandler().hasMessages(1024)) {
            return;
        }
        if (!this.shouldAnimate()) {
            this.postAnimationEnd();
            this.isRunning = false;
            return;
        }
        long l = this.gif.getCurrentDelay();
        boolean bl = false;
        boolean bl2 = false;
        long it = l;
        boolean bl3 = false;
        long frameDelay = it == 0L ? 32L : it;
        this.gif.advance();
        if (this.gif.getCurrentIndex() == 0) {
            int n = this.loopIteration;
            this.loopIteration = n + 1;
        }
        if (!this.shouldAnimate()) {
            this.postAnimationEnd();
            this.isRunning = false;
            return;
        }
        Bitmap nextFrame = this.getCurrentFrame();
        nextFrame.prepareToDraw();
        long elapsedTime = SystemClock.elapsedRealtime() - startTime;
        long delay = RangesKt.coerceIn((long)(frameDelay - elapsedTime), (long)0L, (long)frameDelay);
        Message message = this.getHandler().obtainMessage(1024, (Object)nextFrame);
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"handler.obtainMessage(DRAW_MESSAGE, nextFrame)");
        Message message2 = message;
        this.getHandler().sendMessageDelayed(message2, delay);
    }

    private final Bitmap getCurrentFrame() {
        boolean bl;
        block1: {
            this.gif.getCurrentFrame(this.pixels);
            int[] $this$any$iv = this.pixels;
            boolean $i$f$any = false;
            int[] nArray = $this$any$iv;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int element$iv;
                int it = element$iv = nArray[i];
                boolean bl2 = false;
                if (!(it == 0)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        boolean transparent = bl;
        Bitmap nextFrame = this.bitmapCache.obtain(this.gifWidth, this.gifHeight, transparent ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565);
        nextFrame.setPixels(this.pixels, 0, this.gifWidth, 0, 0, this.gifWidth, this.gifHeight);
        return nextFrame;
    }

    /*
     * WARNING - void declaration
     */
    public GifDrawable(@NotNull GifDescriptor gifDescriptor) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)gifDescriptor, (String)"gifDescriptor");
        this.gif = new Gif(gifDescriptor);
        this.bitmapCache = BitmapPool.Companion.obtain();
        boolean bl = false;
        this.animationCallbacks = new ArrayList();
        this.lock = new Object();
        this.gifWidth = this.gif.getDimension().getWidth();
        this.gifHeight = this.gif.getDimension().getHeight();
        this.pixels = new int[this.gif.getDimension().getSize()];
        this.bitmap = this.getCurrentFrame();
        Paint paint = new Paint();
        boolean bl2 = false;
        boolean bl3 = false;
        Paint paint2 = paint;
        GifDrawable gifDrawable = this;
        boolean bl4 = false;
        $this$apply.setAntiAlias(false);
        $this$apply.setFilterBitmap(false);
        $this$apply.setDither(this.bitmap.getConfig() == Bitmap.Config.RGB_565);
        $this$apply.setShader((Shader)new BitmapShader(this.bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        Unit unit = Unit.INSTANCE;
        gifDrawable.bitmapPaint = paint;
        this.matrix = new Matrix();
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getDefault().plus((CoroutineContext)new CoroutineName("GifDrawable")));
        this.setBounds(0, 0, this.getIntrinsicWidth(), this.getIntrinsicHeight());
        this.handler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DrawHandler>(this){
            final /* synthetic */ GifDrawable this$0;

            @NotNull
            public final DrawHandler invoke() {
                Looper looper = Looper.getMainLooper();
                Intrinsics.checkNotNullExpressionValue((Object)looper, (String)"Looper.getMainLooper()");
                return this.this$0.new DrawHandler(looper);
            }
            {
                this.this$0 = gifDrawable;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ void access$animationJob(GifDrawable $this) {
        $this.animationJob();
    }

    public static final /* synthetic */ List access$getAnimationCallbacks$p(GifDrawable $this) {
        return $this.animationCallbacks;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lnet/redwarp/gif/android/GifDrawable$DrawHandler;", "Landroid/os/Handler;", "looper", "Landroid/os/Looper;", "(Lnet/redwarp/gif/android/GifDrawable;Landroid/os/Looper;)V", "handleMessage", "", "msg", "Landroid/os/Message;", "android-drawable_release"})
    private final class DrawHandler
    extends Handler {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(@NotNull Message msg) {
            block4: {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                Object object = msg.obj;
                if (!(object instanceof Bitmap)) {
                    object = null;
                }
                Bitmap bitmap = (Bitmap)object;
                if (bitmap == null) break block4;
                Bitmap bitmap2 = bitmap;
                boolean bl = false;
                boolean bl2 = false;
                Bitmap nextFrame = bitmap2;
                boolean bl3 = false;
                Object object2 = GifDrawable.this.lock;
                boolean bl4 = false;
                boolean bl5 = false;
                synchronized (object2) {
                    boolean bl6 = false;
                    Bitmap oldBitmap = GifDrawable.this.bitmap;
                    GifDrawable.this.bitmap = nextFrame;
                    GifDrawable.this.bitmapPaint.setShader((Shader)new BitmapShader(GifDrawable.this.bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
                    GifDrawable.this.bitmapPaint.setDither(GifDrawable.this.bitmap.getConfig() == Bitmap.Config.RGB_565);
                    GifDrawable.this.bitmapCache.release(oldBitmap);
                    Unit unit = Unit.INSTANCE;
                }
                GifDrawable.this.invalidateSelf();
            }
        }

        public DrawHandler(Looper looper) {
            Intrinsics.checkNotNullParameter((Object)looper, (String)"looper");
            super(looper);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/redwarp/gif/android/GifDrawable$Companion;", "", "()V", "REPEAT_INFINITE", "", "from", "Lnet/redwarp/gif/android/GifDrawable;", "inputStream", "Ljava/io/InputStream;", "android-drawable_release"})
    public static final class Companion {
        @NotNull
        public final GifDrawable from(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            return new GifDrawable(Parser.INSTANCE.parse(inputStream, PixelPacking.ARGB));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

