/*
 * Decompiled with CFR 0.152.
 */
package net.redhogs.cronparser.builder;

import java.text.MessageFormat;
import net.redhogs.cronparser.I18nMessages;
import net.redhogs.cronparser.builder.AbstractDescriptionBuilder;
import org.joda.time.DateTime;

public class MonthDescriptionBuilder
extends AbstractDescriptionBuilder {
    @Override
    protected String getSingleItemDescription(String expression) {
        return new DateTime().withDayOfMonth(1).withMonthOfYear(Integer.parseInt(expression)).toString("MMMM", I18nMessages.getCurrentLocale());
    }

    @Override
    protected String getIntervalDescriptionFormat(String expression) {
        return MessageFormat.format(", " + I18nMessages.get("every_x") + " " + this.plural(expression, I18nMessages.get("month"), I18nMessages.get("months")), expression);
    }

    @Override
    protected String getBetweenDescriptionFormat(String expression) {
        return ", " + I18nMessages.get("between_description_format");
    }

    @Override
    protected String getDescriptionFormat(String expression) {
        return ", " + I18nMessages.get("only_in");
    }
}

