/*
 * Decompiled with CFR 0.152.
 */
package net.redhogs.cronparser;

import java.text.MessageFormat;
import net.redhogs.cronparser.I18nMessages;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public final class DateAndTimeUtils {
    private DateAndTimeUtils() {
    }

    public static String formatTime(String hoursExpression, String minutesExpression) {
        return DateAndTimeUtils.formatTime(hoursExpression, minutesExpression, "");
    }

    public static String formatTime(String hoursExpression, String minutesExpression, String secondsExpression) {
        String amPM;
        int hour = Integer.parseInt(hoursExpression);
        String string = amPM = hour >= 12 ? I18nMessages.get("time_pm") : I18nMessages.get("time_am");
        if (hour > 12) {
            hour -= 12;
        }
        String minute = String.valueOf(Integer.parseInt(minutesExpression));
        String second = "";
        if (!StringUtils.isEmpty((CharSequence)secondsExpression)) {
            second = ":" + StringUtils.leftPad((String)String.valueOf(Integer.parseInt(secondsExpression)), (int)2, (char)'0');
        }
        return MessageFormat.format("{0}:{1}{2} {3}", String.valueOf(hour), StringUtils.leftPad((String)minute, (int)2, (char)'0'), second, amPM);
    }

    public static String getDayOfWeekName(int dayOfWeek) {
        return new DateTime().withDayOfWeek(dayOfWeek).dayOfWeek().getAsText(I18nMessages.getCurrentLocale());
    }

    public static String formatMinutes(String minutesExpression) {
        if (StringUtils.contains((CharSequence)minutesExpression, (CharSequence)",")) {
            StringBuilder formattedExpression = new StringBuilder();
            for (String minute : StringUtils.split((String)minutesExpression, (char)',')) {
                formattedExpression.append(StringUtils.leftPad((String)minute, (int)2, (char)'0'));
                formattedExpression.append(",");
            }
            return formattedExpression.toString();
        }
        return StringUtils.leftPad((String)minutesExpression, (int)2, (char)'0');
    }
}

