/*
 * Decompiled with CFR 0.152.
 */
package net.redhogs.cronparser;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.redhogs.cronparser.DateAndTimeUtils;
import net.redhogs.cronparser.DescriptionTypeEnum;
import net.redhogs.cronparser.ExpressionParser;
import net.redhogs.cronparser.I18nMessages;
import net.redhogs.cronparser.Options;
import net.redhogs.cronparser.builder.DayOfMonthDescriptionBuilder;
import net.redhogs.cronparser.builder.DayOfWeekDescriptionBuilder;
import net.redhogs.cronparser.builder.HoursDescriptionBuilder;
import net.redhogs.cronparser.builder.MinutesDescriptionBuilder;
import net.redhogs.cronparser.builder.MonthDescriptionBuilder;
import net.redhogs.cronparser.builder.SecondsDescriptionBuilder;
import net.redhogs.cronparser.builder.YearDescriptionBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronExpressionDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger(CronExpressionDescriptor.class);
    private static final char[] specialCharacters = new char[]{'/', '-', ',', '*'};

    private CronExpressionDescriptor() {
    }

    public static String getDescription(String expression) throws ParseException {
        return CronExpressionDescriptor.getDescription(DescriptionTypeEnum.FULL, expression, new Options(), I18nMessages.DEFAULT_LOCALE);
    }

    public static String getDescription(String expression, Options options) throws ParseException {
        return CronExpressionDescriptor.getDescription(DescriptionTypeEnum.FULL, expression, options, I18nMessages.DEFAULT_LOCALE);
    }

    public static String getDescription(String expression, Locale locale) throws ParseException {
        return CronExpressionDescriptor.getDescription(DescriptionTypeEnum.FULL, expression, new Options(), locale);
    }

    public static String getDescription(String expression, Options options, Locale locale) throws ParseException {
        return CronExpressionDescriptor.getDescription(DescriptionTypeEnum.FULL, expression, options, locale);
    }

    public static String getDescription(DescriptionTypeEnum type, String expression) throws ParseException {
        return CronExpressionDescriptor.getDescription(type, expression, new Options(), I18nMessages.DEFAULT_LOCALE);
    }

    public static String getDescription(DescriptionTypeEnum type, String expression, Locale locale) throws ParseException {
        return CronExpressionDescriptor.getDescription(type, expression, new Options(), locale);
    }

    public static String getDescription(DescriptionTypeEnum type, String expression, Options options) throws ParseException {
        return CronExpressionDescriptor.getDescription(type, expression, options, I18nMessages.DEFAULT_LOCALE);
    }

    public static String getDescription(DescriptionTypeEnum type, String expression, Options options, Locale locale) throws ParseException {
        I18nMessages.setCurrentLocale(locale);
        String description = "";
        try {
            String[] expressionParts = ExpressionParser.parse(expression, options);
            switch (type) {
                case FULL: {
                    description = CronExpressionDescriptor.getFullDescription(expressionParts, options);
                    break;
                }
                case TIMEOFDAY: {
                    description = CronExpressionDescriptor.getTimeOfDayDescription(expressionParts);
                    break;
                }
                case HOURS: {
                    description = CronExpressionDescriptor.getHoursDescription(expressionParts);
                    break;
                }
                case MINUTES: {
                    description = CronExpressionDescriptor.getMinutesDescription(expressionParts);
                    break;
                }
                case SECONDS: {
                    description = CronExpressionDescriptor.getSecondsDescription(expressionParts);
                    break;
                }
                case DAYOFMONTH: {
                    description = CronExpressionDescriptor.getDayOfMonthDescription(expressionParts);
                    break;
                }
                case MONTH: {
                    description = CronExpressionDescriptor.getMonthDescription(expressionParts);
                    break;
                }
                case DAYOFWEEK: {
                    description = CronExpressionDescriptor.getDayOfWeekDescription(expressionParts, options);
                    break;
                }
                case YEAR: {
                    description = CronExpressionDescriptor.getYearDescription(expressionParts, options);
                    break;
                }
                default: {
                    description = CronExpressionDescriptor.getSecondsDescription(expressionParts);
                    break;
                }
            }
        }
        catch (ParseException e) {
            if (!options.isThrowExceptionOnParseError()) {
                description = e.getMessage();
                LOG.debug("Exception parsing expression.", (Throwable)e);
            }
            LOG.error("Exception parsing expression.", (Throwable)e);
            throw e;
        }
        return description;
    }

    private static String getYearDescription(String[] expressionParts, Options options) {
        return new YearDescriptionBuilder(options).getSegmentDescription(expressionParts[6], ", " + I18nMessages.get("every_year"));
    }

    private static String getDayOfWeekDescription(String[] expressionParts, Options options) {
        return new DayOfWeekDescriptionBuilder(options).getSegmentDescription(expressionParts[5], ", " + I18nMessages.get("every_day"));
    }

    private static String getMonthDescription(String[] expressionParts) {
        return new MonthDescriptionBuilder().getSegmentDescription(expressionParts[4], "");
    }

    private static String getDayOfMonthDescription(String[] expressionParts) {
        String description = null;
        String exp = expressionParts[3].replace("?", "*");
        if ("L".equals(exp)) {
            description = ", " + I18nMessages.get("on_the_last_day_of_the_month");
        } else if ("WL".equals(exp) || "LW".equals(exp)) {
            description = ", " + I18nMessages.get("on_the_last_weekday_of_the_month");
        } else {
            Pattern pattern = Pattern.compile("(\\dW)|(W\\d)");
            Matcher matcher = pattern.matcher(exp);
            if (matcher.matches()) {
                int dayNumber = Integer.parseInt(matcher.group().replace("W", ""));
                String dayString = dayNumber == 1 ? I18nMessages.get("first_weekday") : MessageFormat.format(I18nMessages.get("weekday_nearest_day"), dayNumber);
                description = MessageFormat.format(", " + I18nMessages.get("on_the_of_the_month"), dayString);
            } else {
                description = new DayOfMonthDescriptionBuilder().getSegmentDescription(exp, ", " + I18nMessages.get("every_day"));
            }
        }
        return description;
    }

    private static String getSecondsDescription(String[] expressionParts) {
        return new SecondsDescriptionBuilder().getSegmentDescription(expressionParts[0], I18nMessages.get("every_second"));
    }

    private static String getMinutesDescription(String[] expressionParts) {
        return new MinutesDescriptionBuilder().getSegmentDescription(expressionParts[1], I18nMessages.get("every_minute"));
    }

    private static String getHoursDescription(String[] expressionParts) {
        return new HoursDescriptionBuilder().getSegmentDescription(expressionParts[2], I18nMessages.get("every_hour"));
    }

    private static String getTimeOfDayDescription(String[] expressionParts) {
        String secondsExpression = expressionParts[0];
        String minutesExpression = expressionParts[1];
        String hoursExpression = expressionParts[2];
        StringBuilder description = new StringBuilder();
        if (!(StringUtils.containsAny((CharSequence)minutesExpression, (char[])specialCharacters) || StringUtils.containsAny((CharSequence)hoursExpression, (char[])specialCharacters) || StringUtils.containsAny((CharSequence)secondsExpression, (char[])specialCharacters))) {
            description.append(I18nMessages.get("at")).append(" ").append(DateAndTimeUtils.formatTime(hoursExpression, minutesExpression, secondsExpression));
        } else if (minutesExpression.contains("-") && !minutesExpression.contains("/") && !StringUtils.containsAny((CharSequence)hoursExpression, (char[])specialCharacters)) {
            String[] minuteParts = minutesExpression.split("-");
            description.append(MessageFormat.format(I18nMessages.get("every_minute_between"), DateAndTimeUtils.formatTime(hoursExpression, minuteParts[0]), DateAndTimeUtils.formatTime(hoursExpression, minuteParts[1])));
        } else if (hoursExpression.contains(",") && !StringUtils.containsAny((CharSequence)minutesExpression, (char[])specialCharacters)) {
            String[] hourParts = hoursExpression.split(",");
            description.append(I18nMessages.get("at"));
            for (int i = 0; i < hourParts.length; ++i) {
                description.append(" ").append(DateAndTimeUtils.formatTime(hourParts[i], minutesExpression));
                if (i < hourParts.length - 2) {
                    description.append(",");
                }
                if (i != hourParts.length - 2) continue;
                description.append(" ");
                description.append(I18nMessages.get("and"));
            }
        } else {
            String secondsDescription = CronExpressionDescriptor.getSecondsDescription(expressionParts);
            String minutesDescription = CronExpressionDescriptor.getMinutesDescription(expressionParts);
            String hoursDescription = CronExpressionDescriptor.getHoursDescription(expressionParts);
            description.append(secondsDescription);
            if (description.length() > 0 && StringUtils.isNotEmpty((CharSequence)minutesDescription)) {
                description.append(", ");
            }
            description.append(minutesDescription);
            if (description.length() > 0 && StringUtils.isNotEmpty((CharSequence)hoursDescription)) {
                description.append(", ");
            }
            description.append(hoursDescription);
        }
        return description.toString();
    }

    private static String getFullDescription(String[] expressionParts, Options options) {
        String description = "";
        String timeSegment = CronExpressionDescriptor.getTimeOfDayDescription(expressionParts);
        String dayOfMonthDesc = CronExpressionDescriptor.getDayOfMonthDescription(expressionParts);
        String monthDesc = CronExpressionDescriptor.getMonthDescription(expressionParts);
        String dayOfWeekDesc = CronExpressionDescriptor.getDayOfWeekDescription(expressionParts, options);
        String yearDesc = CronExpressionDescriptor.getYearDescription(expressionParts, options);
        description = MessageFormat.format("{0}{1}{2}{3}", timeSegment, "*".equals(expressionParts[3]) ? dayOfWeekDesc : dayOfMonthDesc, monthDesc, yearDesc);
        description = CronExpressionDescriptor.transformVerbosity(description, options);
        description = CronExpressionDescriptor.transformCase(description, options);
        return description;
    }

    private static String transformCase(String description, Options options) {
        String descTemp = description;
        switch (options.getCasingType()) {
            case Sentence: {
                descTemp = StringUtils.upperCase((String)("" + descTemp.charAt(0))) + descTemp.substring(1);
                break;
            }
            case Title: {
                descTemp = StringUtils.capitalize((String)descTemp);
                break;
            }
            default: {
                descTemp = descTemp.toLowerCase();
            }
        }
        return descTemp;
    }

    private static String transformVerbosity(String description, Options options) {
        String descTemp = description;
        if (!options.isVerbose()) {
            descTemp = descTemp.replace(I18nMessages.get("every_1_minute"), I18nMessages.get("every_minute"));
            descTemp = descTemp.replace(I18nMessages.get("every_1_hour"), I18nMessages.get("every_hour"));
            descTemp = descTemp.replace(I18nMessages.get("every_1_day"), I18nMessages.get("every_day"));
            descTemp = descTemp.replace(", " + I18nMessages.get("every_minute"), "");
            descTemp = descTemp.replace(", " + I18nMessages.get("every_hour"), "");
            descTemp = descTemp.replace(", " + I18nMessages.get("every_day"), "");
        }
        return descTemp;
    }
}

