/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.rcarz.jiraclient.Component;
import net.rcarz.jiraclient.CustomFieldOption;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.ICredentials;
import net.rcarz.jiraclient.Issue;
import net.rcarz.jiraclient.IssueType;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Priority;
import net.rcarz.jiraclient.Project;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraClient {
    private RestClient restclient = null;
    private String username = null;

    public JiraClient(String uri) {
        this(uri, null);
    }

    public JiraClient(String uri, ICredentials creds) {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        this.restclient = new RestClient((HttpClient)httpclient, creds, URI.create(uri));
        if (creds != null) {
            this.username = creds.getLogonName();
        }
    }

    public Issue.FluentCreate createIssue(String project, String issueType) throws JiraException {
        return Issue.create(this.restclient, project, issueType);
    }

    public Issue getIssue(String key) throws JiraException {
        return Issue.get(this.restclient, key);
    }

    public Issue getIssue(String key, String includedFields) throws JiraException {
        return Issue.get(this.restclient, key, includedFields);
    }

    public Issue getIssue(String key, String includedFields, String expand) throws JiraException {
        return Issue.get(this.restclient, key, includedFields, expand);
    }

    public Issue.SearchResult searchIssues(String jql) throws JiraException {
        return Issue.search(this.restclient, jql, null, null);
    }

    public Issue.SearchResult searchIssues(String jql, Integer maxResults) throws JiraException {
        return Issue.search(this.restclient, jql, null, maxResults);
    }

    public Issue.SearchResult searchIssues(String jql, String includedFields) throws JiraException {
        return Issue.search(this.restclient, jql, includedFields, null);
    }

    public Issue.SearchResult searchIssues(String jql, String includedFields, Integer maxResults) throws JiraException {
        return Issue.search(this.restclient, jql, includedFields, maxResults);
    }

    public Issue.SearchResult searchIssues(String jql, String includedFields, Integer maxResults, Integer startAt) throws JiraException {
        return Issue.search(this.restclient, jql, includedFields, maxResults, startAt);
    }

    public List<Priority> getPriorities() throws JiraException {
        try {
            URI uri = this.restclient.buildURI(Resource.getBaseUri() + "priority");
            JSON response = this.restclient.get(uri);
            JSONArray prioritiesArray = JSONArray.fromObject((Object)response);
            ArrayList<Priority> priorities = new ArrayList<Priority>(prioritiesArray.size());
            for (int i = 0; i < prioritiesArray.size(); ++i) {
                JSONObject p = prioritiesArray.getJSONObject(i);
                priorities.add(new Priority(this.restclient, p));
            }
            return priorities;
        }
        catch (Exception ex) {
            throw new JiraException(ex.getMessage(), ex);
        }
    }

    public List<CustomFieldOption> getCustomFieldAllowedValues(String field, String project, String issueType) throws JiraException {
        JSONObject createMetadata = Issue.getCreateMetadata(this.restclient, project, issueType);
        JSONObject fieldMetadata = (JSONObject)createMetadata.get(field);
        List<CustomFieldOption> customFieldOptions = Field.getResourceArray(CustomFieldOption.class, fieldMetadata.get("allowedValues"), this.restclient);
        return customFieldOptions;
    }

    public List<Component> getComponentsAllowedValues(String project, String issueType) throws JiraException {
        JSONObject createMetadata = Issue.getCreateMetadata(this.restclient, project, issueType);
        JSONObject fieldMetadata = (JSONObject)createMetadata.get("components");
        List<Component> componentOptions = Field.getResourceArray(Component.class, fieldMetadata.get("allowedValues"), this.restclient);
        return componentOptions;
    }

    public RestClient getRestClient() {
        return this.restclient;
    }

    public String getSelf() {
        return this.username;
    }

    public List<Project> getProjects() throws JiraException {
        try {
            URI uri = this.restclient.buildURI(Resource.getBaseUri() + "project");
            JSON response = this.restclient.get(uri);
            JSONArray projectsArray = JSONArray.fromObject((Object)response);
            ArrayList<Project> projects = new ArrayList<Project>(projectsArray.size());
            for (int i = 0; i < projectsArray.size(); ++i) {
                JSONObject p = projectsArray.getJSONObject(i);
                projects.add(new Project(this.restclient, p));
            }
            return projects;
        }
        catch (Exception ex) {
            throw new JiraException(ex.getMessage(), ex);
        }
    }

    public Project getProject(String key) throws JiraException {
        try {
            URI uri = this.restclient.buildURI(Resource.getBaseUri() + "project/" + key);
            JSON response = this.restclient.get(uri);
            return new Project(this.restclient, (JSONObject)response);
        }
        catch (Exception ex) {
            throw new JiraException(ex.getMessage(), ex);
        }
    }

    public List<IssueType> getIssueTypes() throws JiraException {
        try {
            URI uri = this.restclient.buildURI(Resource.getBaseUri() + "issuetype");
            JSON response = this.restclient.get(uri);
            JSONArray issueTypeArray = JSONArray.fromObject((Object)response);
            ArrayList<IssueType> issueTypes = new ArrayList<IssueType>(issueTypeArray.size());
            for (int i = 0; i < issueTypeArray.size(); ++i) {
                JSONObject it = issueTypeArray.getJSONObject(i);
                issueTypes.add(new IssueType(this.restclient, it));
            }
            return issueTypes;
        }
        catch (Exception ex) {
            throw new JiraException(ex.getMessage(), ex);
        }
    }

    public Component.FluentCreate createComponent(String project) {
        return Component.create(this.restclient, project);
    }

    public Component getComponent(String id) throws JiraException {
        return Component.get(this.restclient, id);
    }
}

