/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import java.util.Date;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.User;
import net.sf.json.JSON;
import net.sf.json.JSONObject;

public class Comment
extends Resource {
    private User author = null;
    private String body = null;
    private Date created = null;
    private Date updated = null;
    private User updatedAuthor = null;

    protected Comment(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.self = Field.getString(map.get("self"));
        this.id = Field.getString(map.get("id"));
        this.author = Field.getResource(User.class, map.get("author"), this.restclient);
        this.body = Field.getString(map.get("body"));
        this.created = Field.getDate(map.get("created"));
        this.updated = Field.getDate(map.get("updated"));
        this.updatedAuthor = Field.getResource(User.class, map.get("updatedAuthor"), this.restclient);
    }

    public static Comment get(RestClient restclient, String issue, String id) throws JiraException {
        JSON result = null;
        try {
            result = restclient.get(Comment.getBaseUri() + "issue/" + issue + "/comment/" + id);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve comment " + id + " on issue " + issue, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new Comment(restclient, (JSONObject)result);
    }

    public String toString() {
        return this.created + " by " + this.author;
    }

    public User getAuthor() {
        return this.author;
    }

    public String getBody() {
        return this.body;
    }

    public Date getCreatedDate() {
        return this.created;
    }

    public User getUpdateAuthor() {
        return this.updatedAuthor;
    }

    public Date getUpdatedDate() {
        return this.updated;
    }
}

