/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.serpent;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import net.razorvine.serpent.ComplexNumber;
import net.razorvine.serpent.IClassSerializer;

public class Serializer {
    public int maximumLevel = 500;
    public boolean indent = false;
    public boolean setliterals = true;
    public boolean packageInClassName = false;
    private static Map<Class<?>, IClassSerializer> classToDictRegistry;
    private static final HashSet<Class<?>> boxedTypes;
    private static final String[] repr_255;

    public Serializer() {
    }

    public Serializer(boolean indent, boolean setliterals, boolean packageInClassName) {
        this.indent = indent;
        this.setliterals = setliterals;
        this.packageInClassName = packageInClassName;
    }

    public static void registerClass(Class<?> clazz, IClassSerializer converter) {
        classToDictRegistry.put(clazz, converter);
    }

    public byte[] serialize(Object obj) {
        StringWriter sw = new StringWriter();
        if (this.setliterals) {
            sw.write("# serpent utf-8 python3.2\n");
        } else {
            sw.write("# serpent utf-8 python2.6\n");
        }
        this.serialize(obj, sw, 0);
        sw.flush();
        String ser = sw.toString();
        try {
            sw.close();
            return ser.getBytes("utf-8");
        }
        catch (IOException x) {
            throw new IllegalArgumentException("error creating output bytes: " + x);
        }
    }

    protected void serialize(Object obj, StringWriter sw, int level) {
        Class<?> componentType;
        if (level > this.maximumLevel) {
            throw new IllegalArgumentException("Object graph nesting too deep. Increase serializer.maximumLevel if you think you need more.");
        }
        if (obj != null && obj.getClass().getName().startsWith("org.python.")) {
            obj = this.convertJythonObject(obj);
        }
        Class<?> type = obj == null ? null : obj.getClass();
        Class<?> clazz = componentType = type == null ? null : type.getComponentType();
        if (componentType != null) {
            if (componentType == Byte.TYPE) {
                this.serialize_bytes((byte[])obj, sw, level);
                return;
            }
            this.serialize_primitive_array(obj, sw, level);
            return;
        }
        if (obj == null) {
            sw.write("None");
        } else if (obj instanceof String) {
            this.serialize_string((String)obj, sw, level);
        } else if (type.isPrimitive() || this.isBoxed(type)) {
            this.serialize_primitive(obj, sw, level);
        } else if (obj instanceof Enum) {
            this.serialize_string(obj.toString(), sw, level);
        } else if (obj instanceof BigDecimal) {
            this.serialize_bigdecimal((BigDecimal)obj, sw, level);
        } else if (obj instanceof Number) {
            this.serialize_primitive(obj, sw, level);
        } else if (obj instanceof Date) {
            this.serialize_date((Date)obj, sw, level);
        } else if (obj instanceof Calendar) {
            this.serialize_calendar((Calendar)obj, sw, level);
        } else if (obj instanceof UUID) {
            this.serialize_uuid((UUID)obj, sw, level);
        } else if (obj instanceof Set) {
            this.serialize_set((Set)obj, sw, level);
        } else if (obj instanceof Map) {
            this.serialize_dict((Map)obj, sw, level);
        } else if (obj instanceof Collection) {
            this.serialize_collection((Collection)obj, sw, level);
        } else if (obj instanceof ComplexNumber) {
            this.serialize_complex((ComplexNumber)obj, sw, level);
        } else if (obj instanceof Exception) {
            this.serialize_exception((Exception)obj, sw, level);
        } else if (obj instanceof Serializable) {
            this.serialize_class(obj, sw, level);
        } else {
            throw new IllegalArgumentException("cannot serialize object of type " + type);
        }
    }

    protected Object convertJythonObject(Object obj) {
        Class<?> clazz = obj.getClass();
        String classname = clazz.getName();
        try {
            if (classname.equals("org.python.core.PyTuple")) {
                return clazz.getMethod("toArray", new Class[0]).invoke(obj, new Object[0]);
            }
            if (classname.equals("org.python.core.PyComplex")) {
                Object pyImag = clazz.getMethod("getImag", new Class[0]).invoke(obj, new Object[0]);
                Object pyReal = clazz.getMethod("getReal", new Class[0]).invoke(obj, new Object[0]);
                Double imag = (Double)pyImag.getClass().getMethod("getValue", new Class[0]).invoke(pyImag, new Object[0]);
                Double real = (Double)pyReal.getClass().getMethod("getValue", new Class[0]).invoke(pyReal, new Object[0]);
                return new ComplexNumber(real, imag);
            }
            if (classname.equals("org.python.core.PyByteArray")) {
                Object pyStr = clazz.getMethod("__str__", new Class[0]).invoke(obj, new Object[0]);
                return pyStr.getClass().getMethod("toBytes", new Class[0]).invoke(pyStr, new Object[0]);
            }
            if (classname.equals("org.python.core.PyMemoryView")) {
                Object pyBytes = clazz.getMethod("tobytes", new Class[0]).invoke(obj, new Object[0]);
                return pyBytes.getClass().getMethod("toBytes", new Class[0]).invoke(pyBytes, new Object[0]);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("cannot serialize Jython object of type " + clazz, e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("cannot serialize Jython object of type " + clazz, e);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("cannot serialize Jython object of type " + clazz, e);
        }
        throw new IllegalArgumentException("cannot serialize Jython object of type " + obj.getClass());
    }

    protected void serialize_collection(Collection<?> collection, StringWriter sw, int level) {
        sw.write("[");
        this.serialize_sequence_elements(collection, false, sw, level + 1);
        if (this.indent && collection.size() > 0) {
            for (int i = 0; i < level; ++i) {
                sw.write("  ");
            }
        }
        sw.write("]");
    }

    protected void serialize_sequence_elements(Collection<?> elts, boolean trailingComma, StringWriter sw, int level) {
        if (elts.size() == 0) {
            return;
        }
        int count = 0;
        if (this.indent) {
            sw.write("\n");
            String innerindent = "";
            for (int i = 0; i < level; ++i) {
                innerindent = innerindent + "  ";
            }
            for (Object e : elts) {
                sw.write(innerindent);
                this.serialize(e, sw, level);
                if (++count >= elts.size()) continue;
                sw.write(",\n");
            }
            if (trailingComma) {
                sw.write(",");
            }
            sw.write("\n");
        } else {
            for (Object e : elts) {
                this.serialize(e, sw, level);
                if (++count >= elts.size()) continue;
                sw.write(",");
            }
            if (trailingComma) {
                sw.write(",");
            }
        }
    }

    protected void serialize_set(Set<?> set, StringWriter sw, int level) {
        if (!this.setliterals) {
            this.serialize_tuple(set, sw, level);
            return;
        }
        if (set.size() > 0) {
            sw.write("{");
            Set<?> output = set;
            if (this.indent) {
                Set<?> outputset = set;
                try {
                    outputset = new TreeSet(set);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                output = outputset;
            }
            this.serialize_sequence_elements(output, false, sw, level + 1);
            if (this.indent) {
                for (int i = 0; i < level; ++i) {
                    sw.write("  ");
                }
            }
            sw.write("}");
        } else {
            this.serialize_tuple(Collections.EMPTY_LIST, sw, level + 1);
        }
    }

    protected void serialize_primitive_array(Object array, StringWriter sw, int level) {
        int length = Array.getLength(array);
        ArrayList<Object> items = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            items.add(Array.get(array, i));
        }
        this.serialize_tuple(items, sw, level);
    }

    protected void serialize_tuple(Collection<?> items, StringWriter sw, int level) {
        sw.write("(");
        this.serialize_sequence_elements(items, items.size() == 1, sw, level + 1);
        if (this.indent && items.size() > 0) {
            for (int i = 0; i < level; ++i) {
                sw.write("  ");
            }
        }
        sw.write(")");
    }

    protected void serialize_bytes(byte[] obj, StringWriter sw, int level) {
        String str = Base64.getEncoder().encodeToString(obj);
        HashMap<String, String> dict = new HashMap<String, String>();
        dict.put("data", str);
        dict.put("encoding", "base64");
        this.serialize_dict(dict, sw, level);
    }

    protected void serialize_dict(Map<?, ?> dict, StringWriter sw, int level) {
        if (dict.size() == 0) {
            sw.write("{}");
            return;
        }
        int counter = 0;
        if (this.indent) {
            String innerindent = "  ";
            for (int i = 0; i < level; ++i) {
                innerindent = innerindent + "  ";
            }
            sw.write("{\n");
            Map<?, ?> outputdict = dict;
            try {
                outputdict = new TreeMap(dict);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            for (Map.Entry<?, ?> e : outputdict.entrySet()) {
                sw.write(innerindent);
                this.serialize(e.getKey(), sw, level + 1);
                sw.write(": ");
                this.serialize(e.getValue(), sw, level + 1);
                if (++counter >= dict.size()) continue;
                sw.write(",\n");
            }
            sw.write("\n");
            for (int i = 0; i < level; ++i) {
                sw.write("  ");
            }
            sw.write("}");
        } else {
            sw.write("{");
            for (Map.Entry<?, ?> e : dict.entrySet()) {
                this.serialize(e.getKey(), sw, level + 1);
                sw.write(":");
                this.serialize(e.getValue(), sw, level + 1);
                if (++counter >= dict.size()) continue;
                sw.write(",");
            }
            sw.write("}");
        }
    }

    protected void serialize_calendar(Calendar cal, StringWriter sw, int level) {
        String tzformat = "Z";
        if (cal.get(15) == 0) {
            tzformat = "'Z'";
        }
        SimpleDateFormat df = cal.get(14) > 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS" + tzformat) : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss" + tzformat);
        df.setTimeZone(cal.getTimeZone());
        this.serialize_string(df.format(cal.getTime()), sw, level);
    }

    protected void serialize_date(Date date, StringWriter sw, int level) {
        SimpleDateFormat df = date.getTime() % 1000L != 0L ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.serialize_string(df.format(date), sw, level);
    }

    protected void serialize_complex(ComplexNumber cplx, StringWriter sw, int level) {
        sw.write("(");
        this.serialize_primitive(cplx.real, sw, level);
        if (cplx.imaginary >= 0.0) {
            sw.write("+");
        }
        this.serialize_primitive(cplx.imaginary, sw, level);
        sw.write("j)");
    }

    protected void serialize_uuid(UUID obj, StringWriter sw, int level) {
        this.serialize_string(obj.toString(), sw, level);
    }

    protected void serialize_bigdecimal(BigDecimal decimal, StringWriter sw, int level) {
        this.serialize_string(decimal.toEngineeringString(), sw, level);
    }

    protected boolean isBoxed(Class<?> type) {
        return boxedTypes.contains(type);
    }

    protected void serialize_class(Object obj, StringWriter sw, int level) {
        Map<String, Object> map;
        IClassSerializer converter = this.getCustomConverter(obj.getClass());
        if (null != converter) {
            map = converter.convert(obj);
        } else {
            map = new HashMap<String, Object>();
            try {
                for (Method m : obj.getClass().getMethods()) {
                    int modifiers = m.getModifiers();
                    if ((modifiers & 1) == 0 || (modifiers & 8) != 0) continue;
                    String methodname = m.getName();
                    int prefixlen = 0;
                    if (methodname.equals("getClass")) continue;
                    if (methodname.startsWith("get")) {
                        prefixlen = 3;
                    } else {
                        if (!methodname.startsWith("is")) continue;
                        prefixlen = 2;
                    }
                    Object value = m.invoke(obj, new Object[0]);
                    String name = methodname.substring(prefixlen);
                    if (name.length() == 1) {
                        name = name.toLowerCase();
                    } else if (!Character.isUpperCase(name.charAt(1))) {
                        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                    }
                    map.put(name, value);
                }
                if (this.packageInClassName) {
                    map.put("__class__", obj.getClass().getName());
                } else {
                    map.put("__class__", obj.getClass().getSimpleName());
                }
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("couldn't introspect javabean: " + e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("couldn't introspect javabean: " + e);
            }
        }
        this.serialize_dict(map, sw, level);
    }

    protected IClassSerializer getCustomConverter(Class<?> type) {
        IClassSerializer converter = classToDictRegistry.get(type.getClass());
        if (converter != null) {
            return converter;
        }
        for (Map.Entry<Class<?>, IClassSerializer> x : classToDictRegistry.entrySet()) {
            if (!x.getKey().isAssignableFrom(type)) continue;
            return x.getValue();
        }
        return null;
    }

    protected void serialize_primitive(Object obj, StringWriter sw, int level) {
        if (obj instanceof Boolean || obj.getClass() == Boolean.TYPE) {
            sw.write(obj.equals(Boolean.TRUE) ? "True" : "False");
        } else if (obj instanceof Float || obj.getClass() == Float.TYPE) {
            Float f = (Float)obj;
            this.serialize_primitive(f.doubleValue(), sw, level);
        } else if (obj instanceof Double || obj.getClass() == Double.TYPE) {
            Double d = (Double)obj;
            if (d.isInfinite()) {
                if (d > 0.0) {
                    sw.write("1e30000");
                } else {
                    sw.write("-1e30000");
                }
            } else if (d.isNaN()) {
                sw.write("{'__class__':'float','value':'nan'}");
            } else {
                sw.write(d.toString());
            }
        } else {
            sw.write(obj.toString());
        }
    }

    protected void serialize_string(String str, StringWriter sw, int level) {
        StringBuilder b = new StringBuilder(str.length() * 2);
        boolean containsSingleQuote = false;
        boolean containsQuote = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            containsSingleQuote |= c == '\'';
            containsQuote |= c == '\"';
            if (c < '\u0100') {
                b.append(repr_255[c]);
                continue;
            }
            if (Character.isDefined(c) && !Character.isISOControl(c) && !Character.isSurrogate(c) && !Character.isWhitespace(c)) {
                b.append(c);
                continue;
            }
            b.append(String.format("\\u%04x", c));
        }
        if (!containsSingleQuote) {
            b.insert(0, '\'');
            b.append('\'');
            sw.write(b.toString());
        } else if (!containsQuote) {
            b.insert(0, '\"');
            b.append('\"');
            sw.write(b.toString());
        } else {
            String str2 = b.toString();
            str2 = str2.replace("'", "\\'");
            sw.write("'");
            sw.write(str2);
            sw.write("'");
        }
    }

    protected void serialize_exception(Exception ex, StringWriter sw, int level) {
        Map<String, Object> dict;
        IClassSerializer converter = classToDictRegistry.get(ex.getClass());
        if (null != converter) {
            dict = converter.convert(ex);
        } else {
            dict = new HashMap<String, Object>();
            if (this.packageInClassName) {
                dict.put("__class__", ex.getClass().getName());
            } else {
                dict.put("__class__", ex.getClass().getSimpleName());
            }
            dict.put("__exception__", true);
            dict.put("args", new String[]{ex.getMessage()});
            dict.put("attributes", Collections.EMPTY_MAP);
        }
        this.serialize_dict(dict, sw, level);
    }

    static {
        int c;
        classToDictRegistry = new HashMap();
        boxedTypes = new HashSet();
        boxedTypes.add(Boolean.class);
        boxedTypes.add(Character.class);
        boxedTypes.add(Byte.class);
        boxedTypes.add(Short.class);
        boxedTypes.add(Integer.class);
        boxedTypes.add(Long.class);
        boxedTypes.add(Float.class);
        boxedTypes.add(Double.class);
        repr_255 = new String[256];
        for (c = 0; c < 32; ++c) {
            Serializer.repr_255[c] = String.format("\\x%02x", c);
        }
        for (c = 32; c < 127; c = (int)((char)(c + 1))) {
            Serializer.repr_255[c] = String.valueOf((char)c);
        }
        for (c = 127; c <= 160; ++c) {
            Serializer.repr_255[c] = String.format("\\x%02x", c);
        }
        for (c = 161; c <= 255; c = (int)((char)(c + 1))) {
            Serializer.repr_255[c] = String.valueOf((char)c);
        }
        Serializer.repr_255[9] = "\\t";
        Serializer.repr_255[10] = "\\n";
        Serializer.repr_255[13] = "\\r";
        Serializer.repr_255[92] = "\\\\";
        Serializer.repr_255[173] = "\\xad";
    }
}

