/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pyro;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import net.razorvine.pyro.Config;
import net.razorvine.pyro.IOUtil;
import net.razorvine.pyro.PyroException;

public class Message {
    private static final int MAGIC_NUMBER = 19909;
    public static final int HEADER_SIZE = 40;
    public static final byte MSG_CONNECT = 1;
    public static final byte MSG_CONNECTOK = 2;
    public static final byte MSG_CONNECTFAIL = 3;
    public static final byte MSG_INVOKE = 4;
    public static final byte MSG_RESULT = 5;
    public static final byte MSG_PING = 6;
    public static final int FLAGS_EXCEPTION = 1;
    public static final int FLAGS_COMPRESSED = 2;
    public static final int FLAGS_ONEWAY = 4;
    public static final int FLAGS_BATCH = 8;
    public static final int FLAGS_ITEMSTREAMRESULT = 16;
    public static final int FLAGS_KEEPSERIALIZED = 32;
    public static final int FLAGS_CORR_ID = 64;
    public static final byte SERIALIZER_SERPENT = 1;
    public static final byte SERIALIZER_MARSHAL = 2;
    public static final byte SERIALIZER_JSON = 3;
    public static final byte SERIALIZER_MSGPACK = 4;
    public byte type;
    public int flags;
    public byte[] data;
    public int data_size;
    public int annotations_size;
    public UUID correlation_id;
    public byte serializer_id;
    public int seq;
    public SortedMap<String, byte[]> annotations;

    public Message(byte msgType, byte serializer_id, int flags, int seq, UUID correlation_id) {
        this.type = msgType;
        this.flags = flags;
        this.seq = seq;
        this.serializer_id = serializer_id;
        this.correlation_id = correlation_id;
    }

    public Message(byte msgType, byte[] databytes, byte serializer_id, int flags, int seq, SortedMap<String, byte[]> annotations, UUID correlation_id) {
        this(msgType, serializer_id, flags, seq, correlation_id);
        this.data = databytes;
        this.data_size = databytes.length;
        this.annotations = annotations;
        if (null == annotations) {
            this.annotations = new TreeMap<String, byte[]>();
        }
        this.annotations_size = 0;
        for (Map.Entry<String, byte[]> a : this.annotations.entrySet()) {
            this.annotations_size += a.getValue().length + 8;
        }
    }

    public byte[] to_bytes() {
        byte[] header_bytes = this.get_header_bytes();
        byte[] annotations_bytes = this.get_annotations_bytes();
        byte[] result = new byte[header_bytes.length + annotations_bytes.length + this.data.length];
        System.arraycopy(header_bytes, 0, result, 0, header_bytes.length);
        System.arraycopy(annotations_bytes, 0, result, header_bytes.length, annotations_bytes.length);
        System.arraycopy(this.data, 0, result, header_bytes.length + annotations_bytes.length, this.data.length);
        return result;
    }

    public byte[] get_header_bytes() {
        byte[] header = new byte[40];
        header[0] = 80;
        header[1] = 89;
        header[2] = 82;
        header[3] = 79;
        header[4] = 1;
        header[5] = -10;
        header[6] = this.type;
        header[7] = this.serializer_id;
        header[8] = (byte)(this.flags >> 8);
        header[9] = (byte)(this.flags & 0xFF);
        header[10] = (byte)(this.seq >> 8);
        header[11] = (byte)(this.seq & 0xFF);
        header[12] = (byte)(this.data_size >> 24 & 0xFF);
        header[13] = (byte)(this.data_size >> 16 & 0xFF);
        header[14] = (byte)(this.data_size >> 8 & 0xFF);
        header[15] = (byte)(this.data_size & 0xFF);
        header[16] = (byte)(this.annotations_size >> 24 & 0xFF);
        header[17] = (byte)(this.annotations_size >> 16 & 0xFF);
        header[18] = (byte)(this.annotations_size >> 8 & 0xFF);
        header[19] = (byte)(this.annotations_size & 0xFF);
        if (this.correlation_id != null) {
            ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
            bb.putLong(this.correlation_id.getMostSignificantBits());
            bb.putLong(this.correlation_id.getLeastSignificantBits());
            System.arraycopy(bb.array(), 0, header, 20, 16);
        }
        header[38] = 77;
        header[39] = -59;
        return header;
    }

    public byte[] get_annotations_bytes() {
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        int total_size = 0;
        for (Map.Entry<String, byte[]> ann : this.annotations.entrySet()) {
            String key = ann.getKey();
            byte[] value = ann.getValue();
            if (key.length() != 4) {
                throw new IllegalArgumentException("annotation key must be length 4");
            }
            chunks.add(key.getBytes());
            byte[] size_bytes = new byte[]{(byte)(value.length >> 24 & 0xFF), (byte)(value.length >> 16 & 0xFF), (byte)(value.length >> 8 & 0xFF), (byte)(value.length & 0xFF)};
            chunks.add(size_bytes);
            chunks.add(value);
            total_size += 8 + value.length;
        }
        byte[] result = new byte[total_size];
        int index = 0;
        for (byte[] chunk : chunks) {
            System.arraycopy(chunk, 0, result, index, chunk.length);
            index += chunk.length;
        }
        return result;
    }

    public static Message from_header(byte[] header) {
        if (header == null || header.length != 40) {
            throw new PyroException("header data size mismatch");
        }
        if (header[0] != 80 || header[1] != 89 || header[2] != 82 || header[3] != 79) {
            throw new PyroException("invalid message");
        }
        int version = (header[4] & 0xFF) << 8 | header[5] & 0xFF;
        if (version != 502) {
            throw new PyroException("invalid protocol version: " + version);
        }
        int magic = (header[38] & 0xFF) << 8 | header[39] & 0xFF;
        if (magic != 19909) {
            throw new PyroException("invalid header magic number");
        }
        byte msg_type = header[6];
        byte serializer_id = header[7];
        int flags = (header[8] & 0xFF) << 8 | header[9] & 0xFF;
        int seq = (header[10] & 0xFF) << 8 | header[11] & 0xFF;
        int data_size = header[12] & 0xFF;
        data_size <<= 8;
        data_size |= header[13] & 0xFF;
        data_size <<= 8;
        data_size |= header[14] & 0xFF;
        data_size <<= 8;
        data_size |= header[15] & 0xFF;
        int annotations_size = header[16] & 0xFF;
        annotations_size <<= 8;
        annotations_size |= header[17] & 0xFF;
        annotations_size <<= 8;
        annotations_size |= header[18] & 0xFF;
        annotations_size <<= 8;
        Message msg = new Message(msg_type, serializer_id, flags, seq, null);
        msg.data_size = data_size;
        msg.annotations_size = annotations_size |= header[19] & 0xFF;
        return msg;
    }

    public static Message recv(InputStream connection, int[] requiredMsgTypes) throws IOException {
        byte[] header_data = IOUtil.recv(connection, 40);
        Message msg = Message.from_header(header_data);
        if (requiredMsgTypes != null) {
            boolean found = false;
            for (int req : requiredMsgTypes) {
                if (req != msg.type) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new PyroException(String.format("invalid msg type %d received", msg.type));
            }
        }
        byte[] annotations_data = null;
        msg.annotations = new TreeMap<String, byte[]>();
        if (msg.annotations_size > 0) {
            int length;
            annotations_data = IOUtil.recv(connection, msg.annotations_size);
            for (int i = 0; i < msg.annotations_size; i += 8 + length) {
                String anno = new String(annotations_data, i, 4);
                length = annotations_data[i + 4] << 24 | annotations_data[i + 5] << 16 | annotations_data[i + 6] << 8 | annotations_data[i + 7];
                byte[] annotations_bytes = new byte[length];
                System.arraycopy(annotations_data, i + 8, annotations_bytes, 0, length);
                msg.annotations.put(anno, annotations_bytes);
            }
        }
        msg.data = IOUtil.recv(connection, msg.data_size);
        if (Config.MSG_TRACE_DIR != null) {
            Message.TraceMessageRecv(msg.seq, header_data, annotations_data, msg.data);
        }
        return msg;
    }

    public static void TraceMessageSend(int sequenceNr, byte[] headerdata, byte[] annotations, byte[] data) throws IOException {
        String filename = String.format("%s%s%05d-a-send-header.dat", Config.MSG_TRACE_DIR, File.separator, sequenceNr);
        FileOutputStream fos = new FileOutputStream(filename);
        fos.write(headerdata);
        if (annotations != null) {
            fos.write(annotations);
        }
        fos.close();
        filename = String.format("%s%s%05d-a-send-message.dat", Config.MSG_TRACE_DIR, File.separator, sequenceNr);
        fos = new FileOutputStream(filename);
        fos.write(data);
        fos.close();
    }

    public static void TraceMessageRecv(int sequenceNr, byte[] headerdata, byte[] annotations, byte[] data) throws IOException {
        String filename = String.format("%s%s%05d-b-recv-header.dat", Config.MSG_TRACE_DIR, File.separator, sequenceNr);
        FileOutputStream fos = new FileOutputStream(filename);
        fos.write(headerdata);
        if (annotations != null) {
            fos.write(annotations);
        }
        fos.close();
        filename = String.format("%s%s%05d-b-recv-message.dat", Config.MSG_TRACE_DIR, File.separator, sequenceNr);
        fos = new FileOutputStream(filename);
        fos.write(data);
        fos.close();
    }
}

