/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pyro.serializer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import net.razorvine.pyro.Config;
import net.razorvine.pyro.PyroException;
import net.razorvine.pyro.serializer.PickleSerializer;
import net.razorvine.pyro.serializer.SerpentSerializer;

public abstract class PyroSerializer {
    protected static Map<Config.SerializerType, PyroSerializer> AvailableSerializers = new HashMap<Config.SerializerType, PyroSerializer>();
    protected static PickleSerializer pickleSerializer = new PickleSerializer();
    protected static SerpentSerializer serpentSerializer;

    public abstract int getSerializerId();

    public abstract byte[] serializeCall(String var1, String var2, Object[] var3, Map<String, Object> var4) throws IOException;

    public abstract byte[] serializeData(Object var1) throws IOException;

    public abstract Object deserializeData(byte[] var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PyroSerializer getFor(Config.SerializerType type) {
        switch (type) {
            case pickle: {
                return pickleSerializer;
            }
            case serpent: {
                Class<PyroSerializer> clazz = PyroSerializer.class;
                synchronized (PyroSerializer.class) {
                    if (serpentSerializer == null) {
                        try {
                            serpentSerializer = new SerpentSerializer();
                            String requiredSerpentVersion = "1.17";
                            if (PyroSerializer.compareLibraryVersions("1.17", "1.17") < 0) {
                                throw new RuntimeException("serpent version 1.17 (or newer) is required");
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return serpentSerializer;
                        }
                        catch (LinkageError x) {
                            throw new PyroException("serpent serializer unavailable", x);
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return serpentSerializer;
                }
            }
        }
        throw new IllegalArgumentException("unrecognised serializer type: " + (Object)((Object)type));
    }

    public static PyroSerializer getFor(int serializer_id) {
        if (serpentSerializer != null && serializer_id == serpentSerializer.getSerializerId()) {
            return serpentSerializer;
        }
        if (serializer_id == pickleSerializer.getSerializerId()) {
            return pickleSerializer;
        }
        throw new IllegalArgumentException("unsupported serializer id: " + serializer_id);
    }

    public static int compareLibraryVersions(String actual, String other) {
        Scanner s1 = new Scanner(actual);
        Scanner s2 = new Scanner(other);
        s1.useDelimiter("\\.");
        s2.useDelimiter("\\.");
        while (s1.hasNextInt() && s2.hasNextInt()) {
            int v2;
            int v1 = s1.nextInt();
            if (v1 < (v2 = s2.nextInt())) {
                s1.close();
                s2.close();
                return -1;
            }
            if (v1 <= v2) continue;
            s1.close();
            s2.close();
            return 1;
        }
        int result = 0;
        if (s1.hasNextInt()) {
            result = 1;
        }
        s1.close();
        s2.close();
        return result;
    }
}

