/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.observer.request;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.gotev.uploadservice.UploadRequest;
import net.gotev.uploadservice.UploadService;
import net.gotev.uploadservice.UploadServiceConfig;
import net.gotev.uploadservice.data.BroadcastData;
import net.gotev.uploadservice.data.UploadInfo;
import net.gotev.uploadservice.network.ServerResponse;
import net.gotev.uploadservice.observer.request.CustomManualRequestObserver$WhenMappings;
import net.gotev.uploadservice.observer.request.RequestObserver;
import net.gotev.uploadservice.observer.request.RequestObserverDelegate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u00020\u000b2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/gotev/uploadservice/observer/request/CustomManualRequestObserver;", "Landroid/content/BroadcastReceiver;", "Lnet/gotev/uploadservice/observer/request/RequestObserver;", "context", "Landroid/content/Context;", "uploadID", "", "delegate", "Lnet/gotev/uploadservice/observer/request/RequestObserverDelegate;", "(Landroid/content/Context;Ljava/lang/String;Lnet/gotev/uploadservice/observer/request/RequestObserverDelegate;)V", "onReceive", "", "intent", "Landroid/content/Intent;", "register", "shouldAcceptEventFrom", "", "uploadInfo", "Lnet/gotev/uploadservice/data/UploadInfo;", "subscribe", "request", "Lnet/gotev/uploadservice/UploadRequest;", "unregister", "uploadservice_release"})
public final class CustomManualRequestObserver
extends BroadcastReceiver
implements RequestObserver {
    private final Context context;
    private final String uploadID;
    private final RequestObserverDelegate delegate;

    public void onReceive(@NotNull Context context, @Nullable Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intent intent2 = intent;
        if (intent2 == null) {
            return;
        }
        Intent safeIntent = intent2;
        if (Intrinsics.areEqual((Object)safeIntent.getAction(), (Object)UploadServiceConfig.getBroadcastStatusAction()) ^ true) {
            return;
        }
        BroadcastData broadcastData = BroadcastData.Companion.fromIntent(safeIntent);
        if (broadcastData == null) {
            return;
        }
        BroadcastData data = broadcastData;
        UploadInfo uploadInfo = data.getUploadInfo();
        if (!this.shouldAcceptEventFrom(uploadInfo)) {
            return;
        }
        switch (CustomManualRequestObserver$WhenMappings.$EnumSwitchMapping$0[data.getStatus().ordinal()]) {
            case 1: {
                this.delegate.onProgress(context, uploadInfo);
                break;
            }
            case 2: {
                Throwable throwable = data.getException();
                if (throwable == null) {
                    Intrinsics.throwNpe();
                }
                this.delegate.onError(context, uploadInfo, throwable);
                break;
            }
            case 3: {
                ServerResponse serverResponse = data.getServerResponse();
                if (serverResponse == null) {
                    Intrinsics.throwNpe();
                }
                this.delegate.onSuccess(context, uploadInfo, serverResponse);
                break;
            }
            case 4: {
                this.delegate.onCompleted(context, uploadInfo);
                this.unregister();
            }
        }
    }

    private final boolean shouldAcceptEventFrom(UploadInfo uploadInfo) {
        String string = this.uploadID;
        if (string == null) {
            return true;
        }
        String uploadId = string;
        return Intrinsics.areEqual((Object)uploadId, (Object)uploadInfo.getUploadId());
    }

    @Override
    public void register() {
        LocalBroadcastManager.getInstance((Context)this.context).registerReceiver((BroadcastReceiver)this, UploadServiceConfig.getBroadcastStatusIntentFilter());
        if (!UploadService.Companion.getTaskList().contains(this.uploadID)) {
            this.delegate.onCompletedWhileNotObserving();
        }
    }

    @Override
    public void unregister() {
        LocalBroadcastManager.getInstance((Context)this.context).unregisterReceiver((BroadcastReceiver)this);
    }

    @Override
    public void subscribe(@NotNull UploadRequest<?> request) {
        Intrinsics.checkParameterIsNotNull(request, (String)"request");
        String string = "Not working for this class";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    public CustomManualRequestObserver(@NotNull Context context, @NotNull String uploadID, @NotNull RequestObserverDelegate delegate) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uploadID, (String)"uploadID");
        Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
        this.context = context;
        this.uploadID = uploadID;
        this.delegate = delegate;
    }
}

